<a name="load"></a>

## load(ac, source, options, defaultValue)
Load one or more audio files


Possible option keys:

- __from__ {Function|String}: a function or string to convert from file names to urls.
If is a string it will be prefixed to the name:
`load(ac, 'snare.mp3', { from: 'http://audio.net/samples/' })`
If it's a function it receives the file name and should return the url as string.
- __only__ {Array} - when loading objects, if provided, only the given keys
will be included in the decoded object:
`load(ac, 'piano.json', { only: ['C2', 'D2'] })`

**Kind**: global function  

| Param | Type | Description |
| --- | --- | --- |
| ac | <code>AudioContext</code> | the audio context |
| source | <code>Object</code> | the object to be loaded |
| options | <code>Object</code> | (Optional) the load options for that object |
| defaultValue | <code>Object</code> | (Optional) the default value to return as in a promise if not valid loader found |

