import {
  animationEvent,
  TemplatingEngine
} from 'aurelia-templating';
import {
  DOM
} from 'aurelia-pal';
export declare interface CssAnimation {
  className: string;
  element: Element;
}

/**
 * An implementation of the Animator using CSS3-Animations.
 */
/**
 * An implementation of the Animator using CSS3-Animations.
 */
export declare class CssAnimator {
  
  /**
     * Creates an instance of CssAnimator.
     */
  constructor();
  
  /* Public API Begin */
  /**
     * Execute a single animation.
     * @param element Element to animate
     * @param className Properties to animate or name of the effect to use. For css animators this represents the className to be added and removed right after the animation is done.
     * @param options options for the animation (duration, easing, ...)
     * @returns Resolved when the animation is done
     */
  animate(element: Element | Array<Element>, className: string): Promise<boolean>;
  
  /**
     * Run a sequence of animations one after the other.
     * @param sequence An array of effectNames or classNames
     * @returns Resolved when all animations are done
     */
  runSequence(animations: Array<CssAnimation>): Promise<boolean>;
  
  /**
     * Execute an 'enter' animation on an element
     * @param element Element to animate
     * @returns Resolved when the animation is done
     */
  enter(element: Element): Promise<boolean>;
  
  /**
     * Execute a 'leave' animation on an element
     * @param element Element to animate
     * @returns Resolved when the animation is done
     */
  leave(element: Element): Promise<boolean>;
  
  /**
     * Add a class to an element to trigger an animation.
     * @param element Element to animate
     * @param className Properties to animate or name of the effect to use
     * @param suppressEvents Indicates whether or not to suppress animation events.
     * @returns Resolved when the animation is done
     */
  removeClass(element: Element, className: string, suppressEvents?: boolean): Promise<boolean>;
  
  /**
     * Add a class to an element to trigger an animation.
     * @param element Element to animate
     * @param className Properties to animate or name of the effect to use
     * @param suppressEvents Indicates whether or not to suppress animation events.
     * @returns Resolved when the animation is done
     */
  addClass(element: Element, className: string, suppressEvents?: boolean): Promise<boolean>;
}

/* Public API End */
/**
 * Configuires the CssAnimator as the default animator for Aurelia.
 * @param config The FrameworkConfiguration instance.
 * @param callback A configuration callback provided by the plugin consumer.
 */
export declare function configure(config: Object, callback?: ((animator: CssAnimator) => void)): void;