---
{
  "name": "What is Aurelia?",
  "culture": "en-US",
  "description": "Aurelia is a next generation UI framework. Whether you're building apps for the browser, mobile or desktop, Aurelia can enable you to not only create amazing UI, but do it in a way that is maintainable, testable and extensible.",
  "engines" : { "aurelia-doc" : "^1.0.0" },
  "author": {
  	"name": "Rob Eisenberg",
  	"url": "http://robeisenberg.com"
  },
  "contributors": [],
  "translators": [],
  "keywords": ["JavaScript", "SPA"]
}
---
## [What is it?](aurelia-doc://section/1/version/1.0.0)

Well, it's actually simple. Aurelia is just JavaScript. However, it's not yesterday's JavaScript, but the JavaScript of tomorrow. By using modern tooling we've been able to write Aurelia from the ground up in ECMAScript 2016. This means we have native modules, classes, decorators and more at our disposal...and you have them too.

Not only is Aurelia written in modern and future JavaScript, but it also takes a modern approach to architecture. In the past, frameworks have been monolithic beasts. Not Aurelia though. It's built as a series of collaborating libraries. Taken together, they form a powerful and robust framework for building Single Page Apps (SPAs). However, Aurelia's libraries can often be used individually, in traditional web sites or even on the server-side through technologies like NodeJS.

## [Licensing](aurelia-doc://section/2/version/1.0.0)

Aurelia's code is open sourced under [the MIT License](http://opensource.org/licenses/MIT), a very permissive license used by many popular web projects today. Our starter kits are available under the [Creative Commons 0](http://creativecommons.org/publicdomain/zero/1.0/legalcode) license. We also have a [Contributor's License Agreement (CLA)](https://docs.google.com/forms/d/1Npd68d32UDUKUYuCDDrW0VN5Lv8p-a6Ziaa2JFKp6Cg/viewform?c=0&w=1) for those who wish to join us in working on Aurelia. Ultimately, this means that you can use Aurelia without fear of legal repercussions and we can build it in the same confidence.

## [Benefits](aurelia-doc://section/3/version/1.0.0)

So, Aurelia is a set of modern, modular JavaScript libraries for building UI...and it's open source. Great. There are other projects that might describe themselves in a similar way, so what makes Aurelia unique?

* **Clean and Unobtrusive** - Aurelia is the only framework that lets you build components with plain JavaScript. The framework stays out of your way so your code remains clean and easy to evolve over time.
* **Convention over Configuration** - Simple conventions help developers follow solid patterns and reduce the amount of code they have to write and maintain. It also means less fiddling with framework APIs and more focus on their app.
* **Simple, But Not Simplistic** - Aurelia is simple to learn, but extremely powerful. Because of the simple, consistent design, developers are able to learn a very small set of patterns and APIs that unlock limitless possibilities.
* **Promotes the "-ilities"** - Testability, maintainability, extensibility, learnability, etc. These are often referred to as the "-ilities". Aurelia's design helps developers naturally write code that exhibits these desirable characteristics.
* **Amazingly Extensible** - Aurelia is higly modular and designed to be customized easily. Almost every aspect of Aurelia is extensible, meaning developers will never hit a roadblock or have to "hack" the framework to succeed.
* **Web Standards Focused** - Focused on next generation JavaScript and Web Components, and avoiding unnecessary abstractions that obscure the underlying web, Aurelia is the cleanest and most standards-compliant framework today.
* **Integrates Well with Others** - Because of the extensible design of Aurelia and a number of core technical considerations we made early on, it's easy to integrate Aurelia with any 3rd party library or framework. For example, you can easily integrate with jQuery, React, Polymer, Bootstrap, MaterializeCSS and much more.
* **TypeScript Support** - Each Aurelia library is released with its own d.ts files. We also have official TypeScript beginner kits and production quality starter kits.
* **An Official Product with Commercial Support** - Libraries like Angular, Polymer and React are neither official products of their associated companies nor is any official support or commitment to the library by the company guaranteed. However, Aurelia is an official product of Durandal Inc., has commercial and enterprise support available and we are committed to it over the long haul. If your are building core technology for your business, you want to know that your technology provider is as committed as you are. Aurelia is a clear choice.
* **Thriving Community and Ecosystem** - With one of the largest and most active developer gitter channels in the JavaScript world, a huge number of contributors and a large active core team, Aurelia has an amazing community. Our ecosystem also includes video training resources, books in production, master class opportunities, upcoming conferences, component libraries, tooling, an official partner network and more. Aurelia has been used to build just about every type of application and is used by large, well-known multi-national companies and enterprises.
