---
{
  "name": "O que é Aurelia",
  "culture": "pt-BR",
  "description": "Aurelia é um framework de UI da próxima geração. Se você está construindo aplicativos para o navegador, celular ou desktop, Aurelia pode permitir que você crie não só uma UI incrível, mas faça isso de uma forma que é sustentável, testável e extensível.",
  "engines" : { "aurelia-doc" : "^1.0.0" },
  "author": {
    "name": "Rob Eisenberg",
    "url": "http://robeisenberg.com"
  },
  "contributors": [],
  "translators": [{
    "name": "Daniel Braga",
    "url": "http://danielbraga.com"
  }],
  "keywords": ["JavaScript", "SPA"]
}
---
## [O que é isso?](aurelia-doc://section/1/version/1.0.0)

Bem, é realmente simples. Aurelia é apenas JavaScript. Porém, não é o Javascript de ontem, mas o JavaScript do amanhã. Usando ferramentas modernas, nós fomos capazes de escrever o Aurelia em ECMAScript 2016 a partir do zero. Isso significa que temos módulos nativos, classes, decorators e mais à nossa disposição... e você também os têm..

Aurelia não só é escrito em JavaScript moderno e do futuro, mas ele também leva uma abordagem moderna para a arquitetura. No passado, frameworks foram bestas monolíticas. Aurelia não. Ele é construído como uma série de bibliotecas colaboradoras. Juntas, elas formam um poderoso e robusto framework para construir Single Page Apps (SPAs -Single Page Apps). No entanto, as bibliotecas do Aurelia podem, muitas vezes, ser usadas individualmente, em sites tradicionais ou mesmo através de tecnologias server-side como NodeJS.

## [Licenciamento](aurelia-doc://section/2/version/1.0.0)

O código do Aurelia é open source sob [a Licença MIT](http://opensource.org/licenses/MIT), uma licença muito permissiva usada por muitos projetos web populares hoje. Nossos *starter kits* estão disponíveis sob a licença [Creative Commons 0](http://creativecommons.org/publicdomain/zero/1.0/legalcode). Também temos um [Contrato de Licença do Colaborador (CLA - Contributor's License Agreement)](https://docs.google.com/forms/d/1Npd68d32UDUKUYuCDDrW0VN5Lv8p-a6Ziaa2JFKp6Cg/viewform?c=0&w=1) para aqueles que desejam se juntar a nós trabalhando no Aurelia. Em última análise, isso significa que você pode usar o Aurelia sem medo de repercussões legais e podemos contruí-lo na mesma confiança.

## [Benefícios](aurelia-doc://section/3/version/1.0.0)

Então, Aurelia é um conjunto de modernas bibliotecas JavaScript modulares para criar UI... e é open source. Ótimo. Há outros projetos que podem descrever-se de maneira semelhante, então o que torna Aurelia único?

* **Limpo e Discreto** - Aurelia é o único framework que permite criar componentes com JavaScript simples. O framework fica fora do seu caminho para que o seu código permaneça limpo e fácil para evoluir ao longo do tempo.
* **Convenção sobre Configuração** - Convenções simples ajudam os desenvolvedores a seguir padrões sólidos e reduzir a quantidade de código que eles têm de escrever e manter. Isto também significa mexer menos com APIs de frameworks e mais foco em sua aplicação.
* **Simples, Mas não Simplista** - Aurelia é simples para aprender, mas extremamente poderoso. Devido ao design simples e consistente, os desenvolvedores são capazes de aprender um conjunto muito pequeno de padrões e APIs que desbloqueiam possibilidades ilimitadas.
* **Promove as "-dades"** - Testabilidade,
facilidade de manutenção, extensibilidade, capacidade de aprendizado, etc. Estas são muitas vezes referidas como as "-dades". O design do Aurelia ajuda os desenvolvedores a naturalmente escreverem código que exibe essas características desejáveis.
* **Incrivelmente Extensível** - Aurelia é altamente modular e projetado para ser customizado facilmente. Quase todos os aspectos do Aurelia é extensível, ou seja, os desenvolvedores nunca irão atingir um obstáculo ou terão de "hackear" o framework para ter sucesso.
* **Focado em Padrões Web** - Focado na próxima geração do JavaScript e Web Components e evitando abstrações desnecessárias que obscurece a web fundamental, Aurelia é o framework mais limpo e mais compatível com os padrões hoje
* **Integra Bem com Outros** - Devido ao design extensível do Aurelia e uma série de considerações técnicas fundamentais que fizemos desde o início, é fácil integrar o Aurelia com qualquer biblioteca ou framework de terceiros. Por exemplo, você pode facilmente integrar com jQuery, React, Polymer, Bootstrap, MaterializeCSS e muito mais.
* **Suporte ao TypeScript** - Cada biblioteca Aurelia é lançada com seus próprios arquivos d.ts. Nós também temos kits TypeScript oficiais para iniciantes e *starter kits* com qualidade de produção.
* **Um Produto Official com Suporte Comercial** - Bibliotecas como Angular, Polymer and React não são nem produtos oficiais de suas empresas associadas nem qualquer suporte ou compromisso com a biblioteca é garantida pela empresa. No entanto, Aurelia é um produto oficial da Blue Spire Inc., tem suporte empresarial disponível e estamos comprometidos com isso a longo prazo. Aurelia é uma escolha clara.
* **Comunidade Ativa e Ecossistema** - Com um dos maiores e mais ativos canais Gitter para desenvolvedores no mundo JavaScript, um número enorme de colaboradores e uma grande equipe principal ativa, Aurelia tem uma comunidade incrível. Nosso ecossistema também inclui recursos de vídeos de treinamento, livros em produção, oportunidades de aulas especializadas, conferências para acontecer, biblioteca de componentes, ferramentas, uma rede de parceiros oficial e mais.
