var _class, _temp;

import { I18N } from './i18n';
import { EventAggregator } from 'aurelia-event-aggregator';

export let BaseI18N = (_temp = _class = class BaseI18N {

  constructor(i18n, element, ea) {
    this.i18n = i18n;
    this.element = element;

    this.__i18nDisposer = ea.subscribe('i18n:locale:changed', () => {
      this.i18n.updateTranslations(this.element);
    });
  }

  attached() {
    this.i18n.updateTranslations(this.element);
  }

  detached() {
    this.__i18nDisposer.dispose();
  }
}, _class.inject = [I18N, Element, EventAggregator], _temp);