'use strict';

System.register([], function (_export, _context) {
  "use strict";

  var AbstractRepeater;

  

  return {
    setters: [],
    execute: function () {
      _export('AbstractRepeater', AbstractRepeater = function () {
        function AbstractRepeater(options) {
          

          Object.assign(this, {
            local: 'items',
            viewsRequireLifecycle: true
          }, options);
        }

        AbstractRepeater.prototype.viewCount = function viewCount() {
          throw new Error('subclass must implement `viewCount`');
        };

        AbstractRepeater.prototype.views = function views() {
          throw new Error('subclass must implement `views`');
        };

        AbstractRepeater.prototype.view = function view(index) {
          throw new Error('subclass must implement `view`');
        };

        AbstractRepeater.prototype.matcher = function matcher() {
          throw new Error('subclass must implement `matcher`');
        };

        AbstractRepeater.prototype.addView = function addView(bindingContext, overrideContext) {
          throw new Error('subclass must implement `addView`');
        };

        AbstractRepeater.prototype.insertView = function insertView(index, bindingContext, overrideContext) {
          throw new Error('subclass must implement `insertView`');
        };

        AbstractRepeater.prototype.moveView = function moveView(sourceIndex, targetIndex) {
          throw new Error('subclass must implement `moveView`');
        };

        AbstractRepeater.prototype.removeAllViews = function removeAllViews(returnToCache, skipAnimation) {
          throw new Error('subclass must implement `removeAllViews`');
        };

        AbstractRepeater.prototype.removeViews = function removeViews(viewsToRemove, returnToCache, skipAnimation) {
          throw new Error('subclass must implement `removeView`');
        };

        AbstractRepeater.prototype.removeView = function removeView(index, returnToCache, skipAnimation) {
          throw new Error('subclass must implement `removeView`');
        };

        AbstractRepeater.prototype.updateBindings = function updateBindings(view) {
          throw new Error('subclass must implement `updateBindings`');
        };

        return AbstractRepeater;
      }());

      _export('AbstractRepeater', AbstractRepeater);
    }
  };
});