'use strict';

System.register(['aurelia-templating', 'aurelia-dependency-injection'], function (_export, _context) {
  "use strict";

  var BoundViewFactory, ViewSlot, customAttribute, templateController, inject, _dec, _dec2, _class, If;

  

  return {
    setters: [function (_aureliaTemplating) {
      BoundViewFactory = _aureliaTemplating.BoundViewFactory;
      ViewSlot = _aureliaTemplating.ViewSlot;
      customAttribute = _aureliaTemplating.customAttribute;
      templateController = _aureliaTemplating.templateController;
    }, function (_aureliaDependencyInjection) {
      inject = _aureliaDependencyInjection.inject;
    }],
    execute: function () {
      _export('If', If = (_dec = customAttribute('if'), _dec2 = inject(BoundViewFactory, ViewSlot), _dec(_class = templateController(_class = _dec2(_class = function () {
        function If(viewFactory, viewSlot) {
          

          this.viewFactory = viewFactory;
          this.viewSlot = viewSlot;
          this.showing = false;
          this.view = null;
          this.bindingContext = null;
          this.overrideContext = null;
        }

        If.prototype.bind = function bind(bindingContext, overrideContext) {
          this.bindingContext = bindingContext;
          this.overrideContext = overrideContext;
          this.valueChanged(this.value);
        };

        If.prototype.valueChanged = function valueChanged(newValue) {
          var _this = this;

          if (this.__queuedChanges) {
            this.__queuedChanges.push(newValue);
            return;
          }

          var maybePromise = this._runValueChanged(newValue);
          if (maybePromise instanceof Promise) {
            (function () {
              var queuedChanges = _this.__queuedChanges = [];

              var runQueuedChanges = function runQueuedChanges() {
                if (!queuedChanges.length) {
                  _this.__queuedChanges = undefined;
                  return;
                }

                var nextPromise = _this._runValueChanged(queuedChanges.shift()) || Promise.resolve();
                nextPromise.then(runQueuedChanges);
              };

              maybePromise.then(runQueuedChanges);
            })();
          }
        };

        If.prototype._runValueChanged = function _runValueChanged(newValue) {
          var _this2 = this;

          if (!newValue) {
            var viewOrPromise = void 0;
            if (this.view !== null && this.showing) {
              viewOrPromise = this.viewSlot.remove(this.view);
              if (viewOrPromise instanceof Promise) {
                viewOrPromise.then(function () {
                  return _this2.view.unbind();
                });
              } else {
                this.view.unbind();
              }
            }

            this.showing = false;
            return viewOrPromise;
          }

          if (this.view === null) {
            this.view = this.viewFactory.create();
          }

          if (!this.view.isBound) {
            this.view.bind(this.bindingContext, this.overrideContext);
          }

          if (!this.showing) {
            this.showing = true;
            return this.viewSlot.add(this.view);
          }

          return undefined;
        };

        If.prototype.unbind = function unbind() {
          if (this.view === null) {
            return;
          }

          this.view.unbind();

          if (!this.viewFactory.isCaching) {
            return;
          }

          if (this.showing) {
            this.showing = false;
            this.viewSlot.remove(this.view, true, true);
          }
          this.view.returnToCache();
          this.view = null;
        };

        return If;
      }()) || _class) || _class) || _class));

      _export('If', If);
    }
  };
});