'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TwoWayBindingBehavior = exports.OneWayBindingBehavior = exports.OneTimeBindingBehavior = undefined;

var _dec, _class, _dec2, _class2, _dec3, _class3;

var _aureliaBinding = require('aurelia-binding');

var _aureliaMetadata = require('aurelia-metadata');



var modeBindingBehavior = {
  bind: function bind(binding, source, lookupFunctions) {
    binding.originalMode = binding.mode;
    binding.mode = this.mode;
  },
  unbind: function unbind(binding, source) {
    binding.mode = binding.originalMode;
    binding.originalMode = null;
  }
};

var OneTimeBindingBehavior = exports.OneTimeBindingBehavior = (_dec = (0, _aureliaMetadata.mixin)(modeBindingBehavior), _dec(_class = function OneTimeBindingBehavior() {
  

  this.mode = _aureliaBinding.bindingMode.oneTime;
}) || _class);
var OneWayBindingBehavior = exports.OneWayBindingBehavior = (_dec2 = (0, _aureliaMetadata.mixin)(modeBindingBehavior), _dec2(_class2 = function OneWayBindingBehavior() {
  

  this.mode = _aureliaBinding.bindingMode.oneWay;
}) || _class2);
var TwoWayBindingBehavior = exports.TwoWayBindingBehavior = (_dec3 = (0, _aureliaMetadata.mixin)(modeBindingBehavior), _dec3(_class3 = function TwoWayBindingBehavior() {
  

  this.mode = _aureliaBinding.bindingMode.twoWay;
}) || _class3);