'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.If = undefined;

var _dec, _dec2, _class;

var _aureliaTemplating = require('aurelia-templating');

var _aureliaDependencyInjection = require('aurelia-dependency-injection');



var If = exports.If = (_dec = (0, _aureliaTemplating.customAttribute)('if'), _dec2 = (0, _aureliaDependencyInjection.inject)(_aureliaTemplating.BoundViewFactory, _aureliaTemplating.ViewSlot), _dec(_class = (0, _aureliaTemplating.templateController)(_class = _dec2(_class = function () {
  function If(viewFactory, viewSlot) {
    

    this.viewFactory = viewFactory;
    this.viewSlot = viewSlot;
    this.showing = false;
    this.view = null;
    this.bindingContext = null;
    this.overrideContext = null;
  }

  If.prototype.bind = function bind(bindingContext, overrideContext) {
    this.bindingContext = bindingContext;
    this.overrideContext = overrideContext;
    this.valueChanged(this.value);
  };

  If.prototype.valueChanged = function valueChanged(newValue) {
    var _this = this;

    if (this.__queuedChanges) {
      this.__queuedChanges.push(newValue);
      return;
    }

    var maybePromise = this._runValueChanged(newValue);
    if (maybePromise instanceof Promise) {
      (function () {
        var queuedChanges = _this.__queuedChanges = [];

        var runQueuedChanges = function runQueuedChanges() {
          if (!queuedChanges.length) {
            _this.__queuedChanges = undefined;
            return;
          }

          var nextPromise = _this._runValueChanged(queuedChanges.shift()) || Promise.resolve();
          nextPromise.then(runQueuedChanges);
        };

        maybePromise.then(runQueuedChanges);
      })();
    }
  };

  If.prototype._runValueChanged = function _runValueChanged(newValue) {
    var _this2 = this;

    if (!newValue) {
      var viewOrPromise = void 0;
      if (this.view !== null && this.showing) {
        viewOrPromise = this.viewSlot.remove(this.view);
        if (viewOrPromise instanceof Promise) {
          viewOrPromise.then(function () {
            return _this2.view.unbind();
          });
        } else {
          this.view.unbind();
        }
      }

      this.showing = false;
      return viewOrPromise;
    }

    if (this.view === null) {
      this.view = this.viewFactory.create();
    }

    if (!this.view.isBound) {
      this.view.bind(this.bindingContext, this.overrideContext);
    }

    if (!this.showing) {
      this.showing = true;
      return this.viewSlot.add(this.view);
    }

    return undefined;
  };

  If.prototype.unbind = function unbind() {
    if (this.view === null) {
      return;
    }

    this.view.unbind();

    if (!this.viewFactory.isCaching) {
      return;
    }

    if (this.showing) {
      this.showing = false;
      this.viewSlot.remove(this.view, true, true);
    }
    this.view.returnToCache();
    this.view = null;
  };

  return If;
}()) || _class) || _class) || _class);