/**
 * @typedef {Object} ConnectAction
 * @prop {"connect"} action
 * @prop {string} tcTokenURL
 */
/**
 * @typedef {Object} StatusAction
 * @prop {"status"} action
 * @prop {boolean} [json]
 */
/**
 * @typedef {Object} ShowUIAction
 * @prop {"showui"} action
 * @prop {"PINManagement" | "Settings"} [module]
 */
/**
 * @typedef {Object} GetClientURLCommonOptions
 * @prop {boolean} [mobile] Override the automatic detection based on the user agent.
 */
/**
 * @typedef {(ConnectAction | StatusAction | ShowUIAction) & GetClientURLCommonOptions} GetClientURLOptions
 */
/**
 *
 * @param {GetClientURLOptions} [options]
 * @returns {string}
 */
export function getClientURL(options?: GetClientURLOptions | undefined): string;
export const ClientURLStationary: "http://127.0.0.1:24727/eID-Client";
export const ClientURLMobile: "eid://127.0.0.1:24727/eID-Client";
export type ConnectAction = {
    action: "connect";
    tcTokenURL: string;
};
export type StatusAction = {
    action: "status";
    json?: boolean | undefined;
};
export type ShowUIAction = {
    action: "showui";
    module?: "PINManagement" | "Settings" | undefined;
};
export type GetClientURLCommonOptions = {
    /**
     * Override the automatic detection based on the user agent.
     */
    mobile?: boolean | undefined;
};
export type GetClientURLOptions = (ConnectAction | StatusAction | ShowUIAction) & GetClientURLCommonOptions;
