/**
 * @typedef {import("./stationary").AusweisApp2Status} AusweisApp2Status
 */
/**
 * @callback OnStatusChangeCallback
 * @param {StationaryStatusObserver} this
 * @param {AusweisApp2Status} status
 * @returns {void}
 */
/**
 * @typedef {Object} Options
 * @prop {number} [refreshInterval] polling interval (set to 0 to disable, time in milliseconds)
 * @prop {boolean} [refreshWhenHidden] polling when the window is invisible (if refreshInterval is enabled)
 * @prop {boolean} [refreshOnFocus] refresh when the window gets focused
 * @prop {number} [focusThrottleInterval] only refresh once during this time span (in milliseconds)
 */
/**
 * The StationaryStatusObserver class provides a way to observe changes (user starts or quits the eID client)
 * to the state of the eID client on the clients platform.
 */
export class StationaryStatusObserver {
    /**
     * Creates a new StationaryStatusObserver instance.
     *
     * To start receiving status updates, you must call {@link observe} first.
     *
     * @param {OnStatusChangeCallback} onStatusChange - callback function when the status changes
     * @param {Options} [options] - optional object which customizes the observers' behaviour
     */
    constructor(onStatusChange: OnStatusChangeCallback, options?: Options | undefined);
    /** Read the last known status. Might be null, if the observer hasn't started observing. */
    get status(): import("./stationary.js").AusweisApp2Status | null;
    /** Start observing the status. */
    observe(): void;
    /**
     * Stops observing the status.
     * Make sure to call this function, when the user navigates away from the
     * eID section, to free resources and stop the timers.
     */
    unobserve(): void;
    /**
     * Manually trigger a refresh of the current eID client status.
     */
    refresh(): Promise<void>;
    #private;
}
export type AusweisApp2Status = import("./stationary").AusweisApp2Status;
export type OnStatusChangeCallback = (this: StationaryStatusObserver, status: AusweisApp2Status) => void;
export type Options = {
    /**
     * polling interval (set to 0 to disable, time in milliseconds)
     */
    refreshInterval?: number | undefined;
    /**
     * polling when the window is invisible (if refreshInterval is enabled)
     */
    refreshWhenHidden?: boolean | undefined;
    /**
     * refresh when the window gets focused
     */
    refreshOnFocus?: boolean | undefined;
    /**
     * only refresh once during this time span (in milliseconds)
     */
    focusThrottleInterval?: number | undefined;
};
