/**
 * Augments a HTML anchor element to provide feedback, if the user had an eID client installed
 * and the identification process started or not.
 *
 * Due to significant differences between the way mobile browsers handle custom protocol links,
 * this feature is considered very unstable and not ready for production use, yet.
 *
 * @param {HTMLAnchorElement} target - reference to the target DOM anchor element
 * @param {() => void} notInstalledCallback - callback, which is called, when this function decides that no eID client is installed
 * @experimental
 */
export function observeEIDLink(target: HTMLAnchorElement, notInstalledCallback: () => void): void;
