/**
 * Retrieve the current status of the eID client on the host platform.
 * Only works on desktop environments, where the eID client starts a background
 * http service.
 *
 * Works by trying to reach the status endpoint of the eID client as specified in
 * [TR-03124-1 eID-Client – Part 1: Specifications](https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Publikationen/TechnischeRichtlinien/TR03124/TR-03124-1.pdf?__blob=publicationFile&v=1)
 *
 * Some browsers (as of the time writing only Safari) block requests to localhost origins
 * due to mixed-content restrictions. This function returns the `"unknown"` status in this case.
 *
 * eID clients don't start a background http server on mobile platforms.
 * The returned state is undefined in this case and one should check
 * the platform before using this function with the `isMobile` function.
 *
 * @returns {Promise<AusweisApp2Status>}
 */
export function getStationaryStatus(): Promise<AusweisApp2Status>;
export type AusweisApp2Status = {
    status: "available" | "unavailable" | "unknown" | "safari";
    details: AusweisApp2StatusResponse | null;
};
/**
 * Response body returned by the status response of the eID client.
 */
export type AusweisApp2StatusResponse = {
    implementationTitle: string;
    implementationVendor: string;
    implementationVersion: string;
    name: string;
    specificationTitle: string;
    specificationVendor: string;
    specificationVersion: string;
};
