'use strict';

exports.__esModule = true;
exports.STRATEGIES = undefined;
exports.initSocial = initSocial;
exports.displayName = displayName;
exports.processSocialOptions = processSocialOptions;
exports.socialConnections = socialConnections;
exports.authButtonsTheme = authButtonsTheme;
exports.useBigButtons = useBigButtons;

var _immutable = require('immutable');

var _immutable2 = _interopRequireDefault(_immutable);

var _index = require('../../core/index');

var l = _interopRequireWildcard(_index);

var _data_utils = require('../../utils/data_utils');

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// TODO: Android version also has "unknonwn-social", "evernote" and
// "evernote-sandbox""evernote" in the list, considers "google-openid"
// to be enterprise and doesn't contain "salesforce-community". See
// https://github.com/auth0/Lock.Android/blob/98262cb7110e5d1c8a97e1129faf2621c1d8d111/lock/src/main/java/com/auth0/android/lock/utils/Strategies.java
var STRATEGIES = exports.STRATEGIES = {
  "amazon": "Amazon",
  "aol": "Aol",
  "baidu": "百度",
  "bitbucket": "Bitbucket",
  "box": "Box",
  "dropbox": "Dropbox",
  "dwolla": "Dwolla",
  "ebay": "ebay",
  "exact": "Exact",
  "facebook": "Facebook",
  "fitbit": "Fitbit",
  "github": "GitHub",
  "google-openid": "Google OpenId",
  "google-oauth2": "Google",
  "instagram": "Instagram",
  "linkedin": "LinkedIn",
  "miicard": "miiCard",
  "paypal": "PayPal",
  "planningcenter": "Planning Center",
  "renren": "人人",
  "salesforce": "Salesforce",
  "salesforce-community": "Salesforce Community",
  "salesforce-sandbox": "Salesforce (sandbox)",
  "evernote": "Evernote",
  "evernote-sandbox": "Evernote (sandbox)",
  "shopify": "Shopify",
  "soundcloud": "Soundcloud",
  "thecity": "The City",
  "thecity-sandbox": "The City (sandbox)",
  "thirtysevensignals": "37 Signals",
  "twitter": "Twitter",
  "vkontakte": "vKontakte",
  "windowslive": "Microsoft Account",
  "wordpress": "Wordpress",
  "yahoo": "Yahoo!",
  "yammer": "Yammer",
  "yandex": "Yandex",
  "weibo": "新浪微博"
};

var _dataFns = (0, _data_utils.dataFns)(["social"]),
    get = _dataFns.get,
    tget = _dataFns.tget,
    initNS = _dataFns.initNS;

function initSocial(m, options) {
  return initNS(m, _immutable2.default.fromJS(processSocialOptions(options)));
}

function displayName(connection) {
  if (["oauth1", "oauth2"].indexOf(connection.get("strategy")) !== -1) {
    return connection.get("name");
  }
  return STRATEGIES[connection.get("strategy")];
}

function processSocialOptions(options) {
  var result = {};
  var socialButtonStyle = options.socialButtonStyle;

  // TODO: emit warnings

  if (["big", "small"].indexOf(socialButtonStyle) > -1) {
    result.socialButtonStyle = socialButtonStyle;
  }

  return result;
}

function socialConnections(m) {
  return l.connections(m, "social");
}

function authButtonsTheme(m) {
  return l.ui.authButtonsTheme(m);
}

function useBigButtons(m, notFoundLimit) {
  var style = tget(m, "socialButtonStyle") || get(m, "socialButtonStyle");
  return style ? style === "big" : l.connections(m, "social").count() <= notFoundLimit;
}
