'use strict';

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _email_input = require('../../ui/input/email_input');

var _email_input2 = _interopRequireDefault(_email_input);

var _index = require('../index');

var c = _interopRequireWildcard(_index);

var _index2 = require('../../store/index');

var _index3 = require('../../core/index');

var l = _interopRequireWildcard(_index3);

var _email = require('../email');

var _avatar = require('../../avatar');

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EmailPane = function (_React$Component) {
  _inherits(EmailPane, _React$Component);

  function EmailPane() {
    _classCallCheck(this, EmailPane);

    return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
  }

  EmailPane.prototype.componentDidMount = function componentDidMount() {
    var lock = this.props.lock;

    if (l.ui.avatar(lock) && c.email(lock)) {
      (0, _avatar.requestAvatar)(l.id(lock), c.email(lock));
    }
  };

  EmailPane.prototype.handleChange = function handleChange(e) {
    var lock = this.props.lock;

    if (l.ui.avatar(lock)) {
      (0, _avatar.debouncedRequestAvatar)(l.id(lock), e.target.value);
    }

    (0, _index2.swap)(_index2.updateEntity, "lock", l.id(lock), _email.setEmail, e.target.value);
  };

  EmailPane.prototype.render = function render() {
    var _props = this.props,
        i18n = _props.i18n,
        lock = _props.lock,
        placeholder = _props.placeholder;

    var value = c.getFieldValue(lock, "email");

    return _react2.default.createElement(_email_input2.default, {
      value: value,
      invalidHint: i18n.str(value ? "invalidErrorHint" : "blankErrorHint"),
      isValid: !c.isFieldVisiblyInvalid(lock, "email"),
      onChange: this.handleChange.bind(this),
      placeholder: placeholder
    });
  };

  return EmailPane;
}(_react2.default.Component);

exports.default = EmailPane;


EmailPane.propTypes = {
  i18n: _react2.default.PropTypes.object.isRequired,
  invalidHint: _react2.default.PropTypes.string,
  lock: _react2.default.PropTypes.object.isRequired,
  placeholder: _react2.default.PropTypes.string.isRequired
};
