### Changes

Please describe both what is changing and why this is important. Include:

- Classes and methods added, deleted, deprecated, or changed
- Screenshots of new or changed UI, if applicable
- A summary of usage if this is a new feature or change to a public API (this should also be added to relevant documentation once released)

### References

Please include relevant links supporting this change such as a:

- support ticket
- community post
- StackOverflow post
- support forum thread

Please note any links that are not publicly accessible.

### Testing

Please describe how this can be tested by reviewers. Be specific about anything not tested and reasons why. If this library has unit and/or integration testing, tests should be added for new functionality and existing tests should complete without errors.

* [ ] This change adds unit test coverage
* [ ] This change adds integration test coverage
* [ ] This change has been tested on the latest version of the platform/language

### Checklist

* [ ] I have read the [Auth0 general contribution guidelines](https://github.com/auth0/open-source-template/blob/master/GENERAL-CONTRIBUTING.md)
* [ ] I have read the [Auth0 Code of Conduct](https://github.com/auth0/open-source-template/blob/master/CODE-OF-CONDUCT.md)
* [ ] All existing and new tests complete without errors
* [ ] All code quality tools/guidelines have been run/followed
* [ ] All relevant assets have been compiled
* [ ] All active GitHub checks have passed
