'use strict';

var _immutable = require('immutable');

var _immutable2 = _interopRequireDefault(_immutable);

var _database = require('../../../connection/database');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('databaseUsernameValue', function () {
  var getModel = function getModel(email, username, usernameRequired) {
    return _immutable2.default.fromJS({
      field: {
        email: {
          value: email
        },
        username: {
          value: username
        }
      },
      core: {
        transient: {
          connections: {
            database: [{
              requireUsername: usernameRequired
            }]
          }
        }
      }
    });
  };

  beforeEach(function () {
    jest.resetAllMocks();
  });

  describe('for database connection without username required', function () {
    var model = getModel('user@contoso.com', null, false);

    it('should get the email', function () {
      expect((0, _database.databaseUsernameValue)(model)).toEqual('user@contoso.com');
    });
  });

  describe('for database connection with username required', function () {
    var model = getModel('user@contoso.com', 'user', true);

    it('should get the username', function () {
      expect((0, _database.databaseUsernameValue)(model)).toEqual('user');
    });

    describe('and only email address is filled in', function () {
      var model = getModel('user@contoso.com', null, true);

      it('should get the email address', function () {
        expect((0, _database.databaseUsernameValue)(model)).toEqual('user@contoso.com');
      });
    });
  });
});
