///////////////////////////////////////////////////////////////////////////////
//
//  AutobahnJS - http://autobahn.ws, http://wamp.ws
//
//  A JavaScript library for WAMP ("The Web Application Messaging Protocol").
//
//  Copyright (c) Crossbar.io Technologies GmbH and contributors
//
//  Licensed under the MIT License.
//  http://www.opensource.org/licenses/mit-license.php
//
///////////////////////////////////////////////////////////////////////////////

var when = require('when');
var when_fn = require("when/function");


function auth(session, user, extra) {

   // Persona Issues:
   //
   // Chrome: https://github.com/mozilla/persona/issues/4083
   // IE11: https://groups.google.com/forum/#!topic/mozilla.dev.identity/keEkVpvfLA8

   var d = session.defer();

   navigator.id.watch({
      loggedInUser: user,
      onlogin: function (assertion) {
         // A user has logged in! Here you need to:
         // 1. Send the assertion to your backend for verification and to create a session.
         // 2. Update your UI.
         d.resolve(assertion);
      },
      onlogout: function() {
         // A user has logged out! Here you need to:
         // Tear down the user's session by redirecting the user or making a call to your backend.
         // Also, make sure loggedInUser will get set to null on the next page load.
         // (That's a literal JavaScript null. Not false, 0, or undefined. null.)
         session.leave("wamp.close.logout");
      }
   });

   if (d.promise.then) {
      // whenjs has the actual user promise in an attribute
      return d.promise;
   } else {
      return d;
   }
}

exports.auth = auth;
