'use strict';

var namespace = 'autocomplete:';

var _ = require('../common/utils.js');
var DOM = require('../common/dom.js');

// constructor
// -----------

function EventBus(o) {
  if (!o || !o.el) {
    _.error('EventBus initialized without el');
  }

  this.$el = DOM.element(o.el);
}

// instance methods
// ----------------

_.mixin(EventBus.prototype, {

  // ### public

  trigger: function(type) {
    var args = [].slice.call(arguments, 1);

    var event = _.Event(namespace + type);
    this.$el.trigger(event, args);
    return event;
  }
});

module.exports = EventBus;
