/*!
 * Autolinker.js
 * 3.14.3
 *
 * Copyright(c) 2021 Gregory Jacobs <greg@greg-jacobs.com>
 * MIT License
 *
 * https://github.com/gregjacobs/Autolinker.js
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):(e=e||self).Autolinker=t()}(this,function(){"use strict";function s(e,t){if(Array.prototype.indexOf)return e.indexOf(t);for(var u=0,r=e.length;u<r;u++)if(e[u]===t)return u;return-1}function t(e,t){for(var u=e.length-1;0<=u;u--)!0===t(e[u])&&e.splice(u,1)}function z(e){throw new Error("Unhandled case for value: '"+e+"'")}var u=(e.prototype.setTagName=function(e){return this.tagName=e,this},e.prototype.getTagName=function(){return this.tagName||""},e.prototype.setAttr=function(e,t){return this.getAttrs()[e]=t,this},e.prototype.getAttr=function(e){return this.getAttrs()[e]},e.prototype.setAttrs=function(e){return Object.assign(this.getAttrs(),e),this},e.prototype.getAttrs=function(){return this.attrs||(this.attrs={})},e.prototype.setClass=function(e){return this.setAttr("class",e)},e.prototype.addClass=function(e){for(var t,u=this.getClass(),r=this.whitespaceRegex,n=u?u.split(r):[],a=e.split(r);t=a.shift();)-1===s(n,t)&&n.push(t);return this.getAttrs().class=n.join(" "),this},e.prototype.removeClass=function(e){for(var t,u=this.getClass(),r=this.whitespaceRegex,n=u?u.split(r):[],a=e.split(r);n.length&&(t=a.shift());){var i=s(n,t);-1!==i&&n.splice(i,1)}return this.getAttrs().class=n.join(" "),this},e.prototype.getClass=function(){return this.getAttrs().class||""},e.prototype.hasClass=function(e){return-1!==(" "+this.getClass()+" ").indexOf(" "+e+" ")},e.prototype.setInnerHTML=function(e){return this.innerHTML=e,this},e.prototype.setInnerHtml=function(e){return this.setInnerHTML(e)},e.prototype.getInnerHTML=function(){return this.innerHTML||""},e.prototype.getInnerHtml=function(){return this.getInnerHTML()},e.prototype.toAnchorString=function(){var e=this.getTagName(),t=this.buildAttrsStr();return["<",e,t=t?" "+t:"",">",this.getInnerHtml(),"</",e,">"].join("")},e.prototype.buildAttrsStr=function(){if(!this.attrs)return"";var e=this.getAttrs(),t=[];for(var u in e)e.hasOwnProperty(u)&&t.push(u+'="'+e[u]+'"');return t.join(" ")},e);function e(e){void 0===e&&(e={}),this.tagName="",this.attrs={},this.innerHTML="",this.whitespaceRegex=/\s+/,this.tagName=e.tagName||"",this.attrs=e.attrs||{},this.innerHTML=e.innerHtml||e.innerHTML||""}function c(e,t,i){function u(e){var t="";return e.scheme&&e.host&&(t+=e.scheme+"://"),e.host&&(t+=e.host),e.path&&(t+="/"+e.path),e.query&&(t+="?"+e.query),e.fragment&&(t+="#"+e.fragment),t}function r(e,t){var u=t/2,r=Math.ceil(u),n=-1*Math.floor(u),a="";return n<0&&(a=e.substr(n)),e.substr(0,r)+i+a}var n,a=null==i?(i="&hellip;",n=3,8):(n=i.length,i.length);if(e.length<=t)return e;var s,o,c,h,l=t-n,p=(s={},(c=(o=e).match(/^([a-z]+):\/\//i))&&(s.scheme=c[1],o=o.substr(c[0].length)),(c=o.match(/^(.*?)(?=(\?|#|\/|$))/i))&&(s.host=c[1],o=o.substr(c[0].length)),(c=o.match(/^\/(.*?)(?=(\?|#|$))/i))&&(s.path=c[1],o=o.substr(c[0].length)),(c=o.match(/^\?(.*?)(?=(#|$))/i))&&(s.query=c[1],o=o.substr(c[0].length)),(c=o.match(/^#(.*?)$/i))&&(s.fragment=c[1]),s);if(!p.query||(h=p.query.match(/^(.*?)(?=(\?|\#))(.*?)$/i))&&(p.query=p.query.substr(0,h[1].length),e=u(p)),e.length<=t)return e;if(p.host&&(p.host=p.host.replace(/^www\./,""),e=u(p)),e.length<=t)return e;var g="";if(p.host&&(g+=p.host),g.length>=l)return p.host.length==t?(p.host.substr(0,t-n)+i).substr(0,l+a):r(g,l).substr(0,l+a);var d="";if(p.path&&(d+="/"+p.path),p.query&&(d+="?"+p.query),d){if(l<=(g+d).length)return(g+d).length==t?(g+d).substr(0,t):(g+r(d,l-g.length)).substr(0,l+a);g+=d}if(p.fragment){var f="#"+p.fragment;if(l<=(g+f).length)return(g+f).length==t?(g+f).substr(0,t):(g+r(f,l-g.length)).substr(0,l+a);else g+=f}if(p.scheme&&p.host){var m=p.scheme+"://";if((g+m).length<l)return(m+g).substr(0,t)}if(g.length<=t)return g;var A="";return 0<l&&(A=g.substr(-1*Math.floor(l/2))),(g.substr(0,Math.ceil(l/2))+i+A).substr(0,l+a)}var r=(n.prototype.build=function(e){return new u({tagName:"a",attrs:this.createAttrs(e),innerHtml:this.processAnchorText(e.getAnchorText())})},n.prototype.createAttrs=function(e){var t={href:e.getAnchorHref()},u=this.createCssClass(e);return u&&(t.class=u),this.newWindow&&(t.target="_blank",t.rel="noopener noreferrer"),this.truncate&&this.truncate.length&&this.truncate.length<e.getAnchorText().length&&(t.title=e.getAnchorHref()),t},n.prototype.createCssClass=function(e){var t=this.className;if(t){for(var u=[t],r=e.getCssClassSuffixes(),n=0,a=r.length;n<a;n++)u.push(t+"-"+r[n]);return u.join(" ")}return""},n.prototype.processAnchorText=function(e){return e=this.doTruncate(e)},n.prototype.doTruncate=function(e){var t=this.truncate;if(!t||!t.length)return e;var u,r,n,a,i,s=t.length,o=t.location;return"smart"===o?c(e,s):"middle"===o?function(e,t,u){if(e.length<=t)return e;var r,n=null==u?(u="&hellip;",r=8,3):(r=u.length,u.length),a=t-n,i="";return 0<a&&(i=e.substr(-1*Math.floor(a/2))),(e.substr(0,Math.ceil(a/2))+u+i).substr(0,a+r)}(e,s):(n=s,a=u,(r=e).length>n&&(i=null==a?(a="&hellip;",3):a.length,r=r.substring(0,n-i)+a),r)},n);function n(e){void 0===e&&(e={}),this.newWindow=!1,this.truncate={},this.className="",this.newWindow=e.newWindow||!1,this.truncate=e.truncate||{},this.className=e.className||""}var a=(i.prototype.getMatchedText=function(){return this.matchedText},i.prototype.setOffset=function(e){this.offset=e},i.prototype.getOffset=function(){return this.offset},i.prototype.getCssClassSuffixes=function(){return[this.getType()]},i.prototype.buildTag=function(){return this.tagBuilder.build(this)},i);
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */function i(e){this.__jsduckDummyDocProp=null,this.matchedText="",this.offset=0,this.tagBuilder=e.tagBuilder,this.matchedText=e.matchedText,this.offset=e.offset}var o=function(e,t){return(o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var u in t)t.hasOwnProperty(u)&&(e[u]=t[u])})(e,t)};function h(e,t){function u(){this.constructor=e}o(e,t),e.prototype=null===t?Object.create(t):(u.prototype=t.prototype,new u)}var l,R=function(){return(R=Object.assign||function(e){for(var t,u=1,r=arguments.length;u<r;u++)for(var n in t=arguments[u])Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n]);return e}).apply(this,arguments)},B=(h(p,l=a),p.prototype.getType=function(){return"email"},p.prototype.getEmail=function(){return this.email},p.prototype.getAnchorHref=function(){return"mailto:"+this.email},p.prototype.getAnchorText=function(){return this.email},p);function p(e){var t=l.call(this,e)||this;return t.email="",t.email=e.email,t}var g,d=(h(f,g=a),f.prototype.getType=function(){return"hashtag"},f.prototype.getServiceName=function(){return this.serviceName},f.prototype.getHashtag=function(){return this.hashtag},f.prototype.getAnchorHref=function(){var e=this.serviceName,t=this.hashtag;switch(e){case"twitter":return"https://twitter.com/hashtag/"+t;case"facebook":return"https://www.facebook.com/hashtag/"+t;case"instagram":return"https://instagram.com/explore/tags/"+t;default:throw new Error("Unknown service name to point hashtag to: "+e)}},f.prototype.getAnchorText=function(){return"#"+this.hashtag},f);function f(e){var t=g.call(this,e)||this;return t.serviceName="",t.hashtag="",t.serviceName=e.serviceName,t.hashtag=e.hashtag,t}var m,A=(h(b,m=a),b.prototype.getType=function(){return"mention"},b.prototype.getMention=function(){return this.mention},b.prototype.getServiceName=function(){return this.serviceName},b.prototype.getAnchorHref=function(){switch(this.serviceName){case"twitter":return"https://twitter.com/"+this.mention;case"instagram":return"https://instagram.com/"+this.mention;case"soundcloud":return"https://soundcloud.com/"+this.mention;default:throw new Error("Unknown service name to point mention to: "+this.serviceName)}},b.prototype.getAnchorText=function(){return"@"+this.mention},b.prototype.getCssClassSuffixes=function(){var e=m.prototype.getCssClassSuffixes.call(this),t=this.getServiceName();return t&&e.push(t),e},b);function b(e){var t=m.call(this,e)||this;return t.serviceName="twitter",t.mention="",t.mention=e.mention,t.serviceName=e.serviceName,t}var x,y=(h(F,x=a),F.prototype.getType=function(){return"phone"},F.prototype.getPhoneNumber=function(){return this.number},F.prototype.getNumber=function(){return this.getPhoneNumber()},F.prototype.getAnchorHref=function(){return"tel:"+(this.plusSign?"+":"")+this.number},F.prototype.getAnchorText=function(){return this.matchedText},F);function F(e){var t=x.call(this,e)||this;return t.number="",t.plusSign=!1,t.number=e.number,t.plusSign=e.plusSign,t}var v,w=(h(C,v=a),C.prototype.getType=function(){return"url"},C.prototype.getUrlMatchType=function(){return this.urlMatchType},C.prototype.getUrl=function(){var e=this.url;return this.protocolRelativeMatch||this.protocolUrlMatch||this.protocolPrepended||(e=this.url="http://"+e,this.protocolPrepended=!0),e},C.prototype.getAnchorHref=function(){return this.getUrl().replace(/&amp;/g,"&")},C.prototype.getAnchorText=function(){var e=this.getMatchedText();return this.protocolRelativeMatch&&(e=this.stripProtocolRelativePrefix(e)),this.stripPrefix.scheme&&(e=this.stripSchemePrefix(e)),this.stripPrefix.www&&(e=this.stripWwwPrefix(e)),this.stripTrailingSlash&&(e=this.removeTrailingSlash(e)),this.decodePercentEncoding&&(e=this.removePercentEncoding(e)),e},C.prototype.stripSchemePrefix=function(e){return e.replace(this.schemePrefixRegex,"")},C.prototype.stripWwwPrefix=function(e){return e.replace(this.wwwPrefixRegex,"$1")},C.prototype.stripProtocolRelativePrefix=function(e){return e.replace(this.protocolRelativeRegex,"")},C.prototype.removeTrailingSlash=function(e){return"/"===e.charAt(e.length-1)&&(e=e.slice(0,-1)),e},C.prototype.removePercentEncoding=function(e){var t=e.replace(/%22/gi,"&quot;").replace(/%26/gi,"&amp;").replace(/%27/gi,"&#39;").replace(/%3C/gi,"&lt;").replace(/%3E/gi,"&gt;");try{return decodeURIComponent(t)}catch(e){return t}},C);function C(e){var t=v.call(this,e)||this;return t.url="",t.urlMatchType="scheme",t.protocolUrlMatch=!1,t.protocolRelativeMatch=!1,t.stripPrefix={scheme:!0,www:!0},t.stripTrailingSlash=!0,t.decodePercentEncoding=!0,t.schemePrefixRegex=/^(https?:\/\/)?/i,t.wwwPrefixRegex=/^(https?:\/\/)?(www\.)?/i,t.protocolRelativeRegex=/^\/\//,t.protocolPrepended=!1,t.urlMatchType=e.urlMatchType,t.url=e.url,t.protocolUrlMatch=e.protocolUrlMatch,t.protocolRelativeMatch=e.protocolRelativeMatch,t.stripPrefix=e.stripPrefix,t.stripTrailingSlash=e.stripTrailingSlash,t.decodePercentEncoding=e.decodePercentEncoding,t}function D(e){this.__jsduckDummyDocProp=null,this.tagBuilder=e.tagBuilder}function E(e){return"(?=("+L+"))\\"+e}function k(e){return"(?:"+E(e)+"(?:\\."+E(e+1)+"){0,126}|"+I+")"}var T,q=/[A-Za-z]/,N=/[\d]/,M=/[\D]/,S=/\s/,O=/['"]/,H=/[\x00-\x1F\x7F]/,P=/A-Za-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B4\u08B6-\u08BD\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16F1-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC/.source,j=P+/\u2700-\u27bf\udde6-\uddff\ud800-\udbff\udc00-\udfff\ufe0e\ufe0f\u0300-\u036f\ufe20-\ufe23\u20d0-\u20f0\ud83c\udffb-\udfff\u200d\u3299\u3297\u303d\u3030\u24c2\ud83c\udd70-\udd71\udd7e-\udd7f\udd8e\udd91-\udd9a\udde6-\uddff\ude01-\ude02\ude1a\ude2f\ude32-\ude3a\ude50-\ude51\u203c\u2049\u25aa-\u25ab\u25b6\u25c0\u25fb-\u25fe\u00a9\u00ae\u2122\u2139\udc04\u2600-\u26FF\u2b05\u2b06\u2b07\u2b1b\u2b1c\u2b50\u2b55\u231a\u231b\u2328\u23cf\u23e9-\u23f3\u23f8-\u23fa\udccf\u2935\u2934\u2190-\u21ff/.source+/\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D4-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B62\u0B63\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0C00-\u0C03\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0D01-\u0D03\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D82\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EB9\u0EBB\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F\u109A-\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u192B\u1930-\u193B\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F\u1AB0-\u1ABE\u1B00-\u1B04\u1B34-\u1B44\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BE6-\u1BF3\u1C24-\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF2-\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF5\u1DFB-\u1DFF\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA880\uA881\uA8B4-\uA8C5\uA8E0-\uA8F1\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9E5\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F/.source,U=/0-9\u0660-\u0669\u06F0-\u06F9\u07C0-\u07C9\u0966-\u096F\u09E6-\u09EF\u0A66-\u0A6F\u0AE6-\u0AEF\u0B66-\u0B6F\u0BE6-\u0BEF\u0C66-\u0C6F\u0CE6-\u0CEF\u0D66-\u0D6F\u0DE6-\u0DEF\u0E50-\u0E59\u0ED0-\u0ED9\u0F20-\u0F29\u1040-\u1049\u1090-\u1099\u17E0-\u17E9\u1810-\u1819\u1946-\u194F\u19D0-\u19D9\u1A80-\u1A89\u1A90-\u1A99\u1B50-\u1B59\u1BB0-\u1BB9\u1C40-\u1C49\u1C50-\u1C59\uA620-\uA629\uA8D0-\uA8D9\uA900-\uA909\uA9D0-\uA9D9\uA9F0-\uA9F9\uAA50-\uAA59\uABF0-\uABF9\uFF10-\uFF19/.source,_=j+U,W=j+U,I="(?:["+U+"]{1,3}\\.){3}["+U+"]{1,3}",L="["+W+"](?:["+W+"\\-]{0,61}["+W+"])?",$=new RegExp("["+W+"]"),Z=/(?:xn--vermgensberatung-pwb|xn--vermgensberater-ctb|xn--clchc0ea0b2g2a9gcd|xn--w4r85el8fhu5dnra|northwesternmutual|travelersinsurance|vermögensberatung|xn--3oq18vl8pn36a|xn--5su34j936bgsg|xn--bck1b9a5dre4c|xn--mgbai9azgqp6j|xn--mgberp4a5d4ar|xn--xkc2dl3a5ee0h|vermögensberater|xn--fzys8d69uvgm|xn--mgba7c0bbn0a|xn--xkc2al3hye2a|americanexpress|kerryproperties|sandvikcoromant|xn--i1b6b1a6a2e|xn--kcrx77d1x4a|xn--lgbbat1ad8j|xn--mgba3a4f16a|xn--mgbaakc7dvf|xn--mgbc0a9azcg|xn--nqv7fs00ema|afamilycompany|americanfamily|bananarepublic|cancerresearch|cookingchannel|kerrylogistics|weatherchannel|xn--54b7fta0cc|xn--6qq986b3xl|xn--80aqecdr1a|xn--b4w605ferd|xn--fiq228c5hs|xn--h2breg3eve|xn--jlq61u9w7b|xn--mgba3a3ejt|xn--mgbaam7a8h|xn--mgbayh7gpa|xn--mgbb9fbpob|xn--mgbbh1a71e|xn--mgbca7dzdo|xn--mgbi4ecexp|xn--mgbx4cd0ab|xn--rvc1e0am3e|international|lifeinsurance|spreadbetting|travelchannel|wolterskluwer|xn--eckvdtc9d|xn--fpcrj9c3d|xn--fzc2c9e2c|xn--h2brj9c8c|xn--tiq49xqyj|xn--yfro4i67o|xn--ygbi2ammx|construction|lplfinancial|scholarships|versicherung|xn--3e0b707e|xn--45br5cyl|xn--80adxhks|xn--80asehdb|xn--8y0a063a|xn--gckr3f0f|xn--mgb9awbf|xn--mgbab2bd|xn--mgbgu82a|xn--mgbpl2fh|xn--mgbt3dhd|xn--mk1bu44c|xn--ngbc5azd|xn--ngbe9e0a|xn--ogbpf8fl|xn--qcka1pmc|accountants|barclaycard|blackfriday|blockbuster|bridgestone|calvinklein|contractors|creditunion|engineering|enterprises|foodnetwork|investments|kerryhotels|lamborghini|motorcycles|olayangroup|photography|playstation|productions|progressive|redumbrella|rightathome|williamhill|xn--11b4c3d|xn--1ck2e1b|xn--1qqw23a|xn--2scrj9c|xn--3bst00m|xn--3ds443g|xn--3hcrj9c|xn--42c2d9a|xn--45brj9c|xn--55qw42g|xn--6frz82g|xn--80ao21a|xn--9krt00a|xn--cck2b3b|xn--czr694b|xn--d1acj3b|xn--efvy88h|xn--estv75g|xn--fct429k|xn--fjq720a|xn--flw351e|xn--g2xx48c|xn--gecrj9c|xn--gk3at1e|xn--h2brj9c|xn--hxt814e|xn--imr513n|xn--j6w193g|xn--jvr189m|xn--kprw13d|xn--kpry57d|xn--kpu716f|xn--mgbbh1a|xn--mgbtx2b|xn--mix891f|xn--nyqy26a|xn--otu796d|xn--pbt977c|xn--pgbs0dh|xn--q9jyb4c|xn--rhqv96g|xn--rovu88b|xn--s9brj9c|xn--ses554g|xn--t60b56a|xn--vuq861b|xn--w4rs40l|xn--xhq521b|xn--zfr164b|சிங்கப்பூர்|accountant|apartments|associates|basketball|bnpparibas|boehringer|capitalone|consulting|creditcard|cuisinella|eurovision|extraspace|foundation|healthcare|immobilien|industries|management|mitsubishi|nationwide|newholland|nextdirect|onyourside|properties|protection|prudential|realestate|republican|restaurant|schaeffler|swiftcover|tatamotors|technology|telefonica|university|vistaprint|vlaanderen|volkswagen|xn--30rr7y|xn--3pxu8k|xn--45q11c|xn--4gbrim|xn--55qx5d|xn--5tzm5g|xn--80aswg|xn--90a3ac|xn--9dbq2a|xn--9et52u|xn--c2br7g|xn--cg4bki|xn--czrs0t|xn--czru2d|xn--fiq64b|xn--fiqs8s|xn--fiqz9s|xn--io0a7i|xn--kput3i|xn--mxtq1m|xn--o3cw4h|xn--pssy2u|xn--unup4y|xn--wgbh1c|xn--wgbl6a|xn--y9a3aq|accenture|alfaromeo|allfinanz|amsterdam|analytics|aquarelle|barcelona|bloomberg|christmas|community|directory|education|equipment|fairwinds|financial|firestone|fresenius|frontdoor|fujixerox|furniture|goldpoint|hisamitsu|homedepot|homegoods|homesense|honeywell|institute|insurance|kuokgroup|ladbrokes|lancaster|landrover|lifestyle|marketing|marshalls|melbourne|microsoft|panasonic|passagens|pramerica|richardli|scjohnson|shangrila|solutions|statebank|statefarm|stockholm|travelers|vacations|xn--90ais|xn--c1avg|xn--d1alf|xn--e1a4c|xn--fhbei|xn--j1aef|xn--j1amh|xn--l1acc|xn--ngbrx|xn--nqv7f|xn--p1acf|xn--tckwe|xn--vhquv|yodobashi|abudhabi|airforce|allstate|attorney|barclays|barefoot|bargains|baseball|boutique|bradesco|broadway|brussels|budapest|builders|business|capetown|catering|catholic|chrysler|cipriani|cityeats|cleaning|clinique|clothing|commbank|computer|delivery|deloitte|democrat|diamonds|discount|discover|download|engineer|ericsson|esurance|etisalat|everbank|exchange|feedback|fidelity|firmdale|football|frontier|goodyear|grainger|graphics|guardian|hdfcbank|helsinki|holdings|hospital|infiniti|ipiranga|istanbul|jpmorgan|lighting|lundbeck|marriott|maserati|mckinsey|memorial|merckmsd|mortgage|movistar|observer|partners|pharmacy|pictures|plumbing|property|redstone|reliance|saarland|samsclub|security|services|shopping|showtime|softbank|software|stcgroup|supplies|symantec|training|uconnect|vanguard|ventures|verisign|woodside|xn--90ae|xn--node|xn--p1ai|xn--qxam|yokohama|السعودية|abogado|academy|agakhan|alibaba|android|athleta|auction|audible|auspost|avianca|banamex|bauhaus|bentley|bestbuy|booking|brother|bugatti|capital|caravan|careers|cartier|channel|charity|chintai|citadel|clubmed|college|cologne|comcast|company|compare|contact|cooking|corsica|country|coupons|courses|cricket|cruises|dentist|digital|domains|exposed|express|farmers|fashion|ferrari|ferrero|finance|fishing|fitness|flights|florist|flowers|forsale|frogans|fujitsu|gallery|genting|godaddy|grocery|guitars|hamburg|hangout|hitachi|holiday|hosting|hoteles|hotmail|hyundai|iselect|ismaili|jewelry|juniper|kitchen|komatsu|lacaixa|lancome|lanxess|lasalle|latrobe|leclerc|liaison|limited|lincoln|markets|metlife|monster|netbank|netflix|network|neustar|okinawa|oldnavy|organic|origins|philips|pioneer|politie|realtor|recipes|rentals|reviews|rexroth|samsung|sandvik|schmidt|schwarz|science|shiksha|shriram|singles|staples|starhub|storage|support|surgery|systems|temasek|theater|theatre|tickets|tiffany|toshiba|trading|walmart|wanggou|watches|weather|website|wedding|whoswho|windows|winners|xfinity|yamaxun|youtube|zuerich|католик|اتصالات|الجزائر|العليان|پاکستان|كاثوليك|موبايلي|இந்தியா|abarth|abbott|abbvie|active|africa|agency|airbus|airtel|alipay|alsace|alstom|anquan|aramco|author|bayern|beauty|berlin|bharti|blanco|bostik|boston|broker|camera|career|caseih|casino|center|chanel|chrome|church|circle|claims|clinic|coffee|comsec|condos|coupon|credit|cruise|dating|datsun|dealer|degree|dental|design|direct|doctor|dunlop|dupont|durban|emerck|energy|estate|events|expert|family|flickr|futbol|gallup|garden|george|giving|global|google|gratis|health|hermes|hiphop|hockey|hotels|hughes|imamat|insure|intuit|jaguar|joburg|juegos|kaufen|kinder|kindle|kosher|lancia|latino|lawyer|lefrak|living|locker|london|luxury|madrid|maison|makeup|market|mattel|mobile|mobily|monash|mormon|moscow|museum|mutual|nagoya|natura|nissan|nissay|norton|nowruz|office|olayan|online|oracle|orange|otsuka|pfizer|photos|physio|piaget|pictet|quebec|racing|realty|reisen|repair|report|review|rocher|rogers|ryukyu|safety|sakura|sanofi|school|schule|search|secure|select|shouji|soccer|social|stream|studio|supply|suzuki|swatch|sydney|taipei|taobao|target|tattoo|tennis|tienda|tjmaxx|tkmaxx|toyota|travel|unicom|viajes|viking|villas|virgin|vision|voting|voyage|vuelos|walter|warman|webcam|xihuan|yachts|yandex|zappos|москва|онлайн|ابوظبي|ارامكو|الاردن|المغرب|امارات|فلسطين|مليسيا|भारतम्|இலங்கை|ファッション|actor|adult|aetna|amfam|amica|apple|archi|audio|autos|azure|baidu|beats|bible|bingo|black|boats|bosch|build|canon|cards|chase|cheap|cisco|citic|click|cloud|coach|codes|crown|cymru|dabur|dance|deals|delta|dodge|drive|dubai|earth|edeka|email|epost|epson|faith|fedex|final|forex|forum|gallo|games|gifts|gives|glade|glass|globo|gmail|green|gripe|group|gucci|guide|homes|honda|horse|house|hyatt|ikano|intel|irish|iveco|jetzt|koeln|kyoto|lamer|lease|legal|lexus|lilly|linde|lipsy|lixil|loans|locus|lotte|lotto|lupin|macys|mango|media|miami|money|mopar|movie|nadex|nexus|nikon|ninja|nokia|nowtv|omega|osaka|paris|parts|party|phone|photo|pizza|place|poker|praxi|press|prime|promo|quest|radio|rehab|reise|ricoh|rocks|rodeo|rugby|salon|sener|seven|sharp|shell|shoes|skype|sling|smart|smile|solar|space|sport|stada|store|study|style|sucks|swiss|tatar|tires|tirol|tmall|today|tokyo|tools|toray|total|tours|trade|trust|tunes|tushu|ubank|vegas|video|vodka|volvo|wales|watch|weber|weibo|works|world|xerox|yahoo|zippo|ایران|بازار|بھارت|سودان|سورية|همراه|भारोत|संगठन|বাংলা|భారత్|ഭാരതം|嘉里大酒店|aarp|able|adac|aero|aigo|akdn|ally|amex|arab|army|arpa|arte|asda|asia|audi|auto|baby|band|bank|bbva|beer|best|bike|bing|blog|blue|bofa|bond|book|buzz|cafe|call|camp|care|cars|casa|case|cash|cbre|cern|chat|citi|city|club|cool|coop|cyou|data|date|dclk|deal|dell|desi|diet|dish|docs|doha|duck|duns|dvag|erni|fage|fail|fans|farm|fast|fiat|fido|film|fire|fish|flir|food|ford|free|fund|game|gbiz|gent|ggee|gift|gmbh|gold|golf|goog|guge|guru|hair|haus|hdfc|help|here|hgtv|host|hsbc|icbc|ieee|imdb|immo|info|itau|java|jeep|jobs|jprs|kddi|kiwi|kpmg|kred|land|lego|lgbt|lidl|life|like|limo|link|live|loan|loft|love|ltda|luxe|maif|meet|meme|menu|mini|mint|mobi|moda|moto|name|navy|news|next|nico|nike|ollo|open|page|pars|pccw|pics|ping|pink|play|plus|pohl|porn|post|prod|prof|qpon|raid|read|reit|rent|rest|rich|rmit|room|rsvp|ruhr|safe|sale|sarl|save|saxo|scor|scot|seat|seek|sexy|shaw|shia|shop|show|silk|sina|site|skin|sncf|sohu|song|sony|spot|star|surf|talk|taxi|team|tech|teva|tiaa|tips|town|toys|tube|vana|visa|viva|vivo|vote|voto|wang|weir|wien|wiki|wine|work|xbox|yoga|zara|zero|zone|дети|сайт|بارت|بيتك|ڀارت|تونس|شبكة|عراق|عمان|موقع|भारत|ভারত|ভাৰত|ਭਾਰਤ|ભારત|ଭାରତ|ಭಾರತ|ලංකා|グーグル|クラウド|ポイント|大众汽车|组织机构|電訊盈科|香格里拉|aaa|abb|abc|aco|ads|aeg|afl|aig|anz|aol|app|art|aws|axa|bar|bbc|bbt|bcg|bcn|bet|bid|bio|biz|bms|bmw|bnl|bom|boo|bot|box|buy|bzh|cab|cal|cam|car|cat|cba|cbn|cbs|ceb|ceo|cfa|cfd|com|crs|csc|dad|day|dds|dev|dhl|diy|dnp|dog|dot|dtv|dvr|eat|eco|edu|esq|eus|fan|fit|fly|foo|fox|frl|ftr|fun|fyi|gal|gap|gdn|gea|gle|gmo|gmx|goo|gop|got|gov|hbo|hiv|hkt|hot|how|ibm|ice|icu|ifm|inc|ing|ink|int|ist|itv|jcb|jcp|jio|jll|jmp|jnj|jot|joy|kfh|kia|kim|kpn|krd|lat|law|lds|llc|lol|lpl|ltd|man|map|mba|med|men|mil|mit|mlb|mls|mma|moe|moi|mom|mov|msd|mtn|mtr|nab|nba|nec|net|new|nfl|ngo|nhk|now|nra|nrw|ntt|nyc|obi|off|one|ong|onl|ooo|org|ott|ovh|pay|pet|phd|pid|pin|pnc|pro|pru|pub|pwc|qvc|red|ren|ril|rio|rip|run|rwe|sap|sas|sbi|sbs|sca|scb|ses|sew|sex|sfr|ski|sky|soy|srl|srt|stc|tab|tax|tci|tdk|tel|thd|tjx|top|trv|tui|tvs|ubs|uno|uol|ups|vet|vig|vin|vip|wed|win|wme|wow|wtc|wtf|xin|xxx|xyz|you|yun|zip|бел|ком|қаз|мкд|мон|орг|рус|срб|укр|հայ|קום|عرب|قطر|كوم|مصر|कॉम|नेट|คอม|ไทย|ストア|セール|みんな|中文网|天主教|我爱你|新加坡|淡马锡|诺基亚|飞利浦|ac|ad|ae|af|ag|ai|al|am|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cw|cx|cy|cz|de|dj|dk|dm|do|dz|ec|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|za|zm|zw|ελ|бг|ею|рф|გე|닷넷|닷컴|삼성|한국|コム|世界|中信|中国|中國|企业|佛山|信息|健康|八卦|公司|公益|台湾|台灣|商城|商店|商标|嘉里|在线|大拿|娱乐|家電|工行|广东|微博|慈善|手机|手表|招聘|政务|政府|新闻|时尚|書籍|机构|游戏|澳門|点看|珠宝|移动|网址|网店|网站|网络|联通|谷歌|购物|通販|集团|食品|餐厅|香港)/,V=new RegExp("["+W+"!#$%&'*+/=?^_`{|}~-]"),Y=new RegExp("^"+Z.source+"$"),G=(h(J,T=D),J.prototype.parseMatches=function(r){for(var e,t,u,n,a,i,s,o,c,h=this.tagBuilder,l=this.localPartCharRegex,p=this.strictTldRegex,g=[],d=r.length,f=new K,m={m:"a",a:"i",i:"l",l:"t",t:"o",o:":"},A=0,b=0,x=f;A<d;){var y=r.charAt(A);switch(b){case 0:"m"===(c=y)?F(1):l.test(c)&&F();break;case 1:s=r.charAt(A-1),o=y,":"===s?l.test(o)?(b=2,x=new K(R(R({},x),{hasMailtoPrefix:!0}))):v():m[s]===o||(l.test(o)?b=2:"."===o?b=3:"@"===o?b=4:v());break;case 2:"."===(i=y)?b=3:"@"===i?b=4:l.test(i)||v();break;case 3:"."!==(a=y)&&"@"!==a&&l.test(a)?b=2:v();break;case 4:n=y,$.test(n)?b=5:v();break;case 5:"."===(u=y)?b=7:"-"===u?b=6:$.test(u)||w();break;case 6:"-"!==(t=y)&&"."!==t&&$.test(t)?b=5:w();break;case 7:"."!==(e=y)&&"-"!==e&&$.test(e)?(b=5,x=new K(R(R({},x),{hasDomainDot:!0}))):w();break;default:z(b)}A++}return w(),g;function F(e){void 0===e&&(e=2),b=e,x=new K({idx:A})}function v(){b=0,x=f}function w(){var e,t,u;x.hasDomainDot&&(e=r.slice(x.idx,A),/[-.]$/.test(e)&&(e=e.slice(0,-1)),t=x.hasMailtoPrefix?e.slice("mailto:".length):e,u=(t.split(".").pop()||"").toLowerCase(),p.test(u)&&g.push(new B({tagBuilder:h,matchedText:e,offset:x.idx,email:t}))),v()}},J);function J(){var e=null!==T&&T.apply(this,arguments)||this;return e.localPartCharRegex=V,e.strictTldRegex=Y,e}var K=function(e){void 0===e&&(e={}),this.idx=void 0!==e.idx?e.idx:-1,this.hasMailtoPrefix=!!e.hasMailtoPrefix,this.hasDomainDot=!!e.hasDomainDot},Q=(X.isValid=function(e,t){return!(t&&!this.isValidUriScheme(t)||this.urlMatchDoesNotHaveProtocolOrDot(e,t)||this.urlMatchDoesNotHaveAtLeastOneWordChar(e,t)&&!this.isValidIpAddress(e)||this.containsMultipleDots(e))},X.isValidIpAddress=function(e){var t=new RegExp(this.hasFullProtocolRegex.source+this.ipRegex.source);return null!==e.match(t)},X.containsMultipleDots=function(e){var t=e;return this.hasFullProtocolRegex.test(e)&&(t=e.split("://")[1]),-1<t.split("/")[0].indexOf("..")},X.isValidUriScheme=function(e){var t=e.match(this.uriSchemeRegex),u=t&&t[0].toLowerCase();return"javascript:"!==u&&"vbscript:"!==u},X.urlMatchDoesNotHaveProtocolOrDot=function(e,t){return!(!e||t&&this.hasFullProtocolRegex.test(t)||-1!==e.indexOf("."))},X.urlMatchDoesNotHaveAtLeastOneWordChar=function(e,t){return!(!e||!t||this.hasFullProtocolRegex.test(t)||this.hasWordCharAfterProtocolRegex.test(e))},X.hasFullProtocolRegex=/^[A-Za-z][-.+A-Za-z0-9]*:\/\//,X.uriSchemeRegex=/^[A-Za-z][-.+A-Za-z0-9]*:/,X.hasWordCharAfterProtocolRegex=new RegExp(":[^\\s]*?["+P+"]"),X.ipRegex=/[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?(:[0-9]*)?\/?$/,X);function X(){}var ee,te,ue=(ee=new RegExp("[/?#](?:["+W+"\\-+&@#/%=~_()|'$*\\[\\]{}?!:,.;^✓]*["+W+"\\-+&@#/%=~_()|'$*\\[\\]{}✓])?"),new RegExp(["(?:","(",/(?:[A-Za-z][-.+A-Za-z0-9]{0,63}:(?![A-Za-z][-.+A-Za-z0-9]{0,63}:\/\/)(?!\d+\/?)(?:\/\/)?)/.source,k(2),")","|","(","(//)?",/(?:www\.)/.source,k(6),")","|","(","(//)?",k(10)+"\\.",Z.source,"(?![-"+_+"])",")",")","(?::[0-9]+)?","(?:"+ee.source+")?"].join(""),"gi")),re=new RegExp("["+W+"]"),ne=(h(ae,te=D),ae.prototype.parseMatches=function(g){for(var d,e=this.matcherRegex,f=this.stripPrefix,m=this.stripTrailingSlash,A=this.decodePercentEncoding,b=this.tagBuilder,x=[],y=this;null!==(d=e.exec(g));)!function(){var e,t,u,r,n,a=d[0],i=d[1],s=d[4],o=d[5],c=d[9],h=d.index,l=o||c,p=g.charAt(h-1);Q.isValid(a,i)&&(0<h&&"@"===p||0<h&&l&&y.wordCharRegExp.test(p)||(/\?$/.test(a)&&(a=a.substr(0,a.length-1)),y.matchHasUnbalancedClosingParen(a)?a=a.substr(0,a.length-1):-1<(e=y.matchHasInvalidCharAfterTld(a,i))&&(a=a.substr(0,e)),(u=["http://","https://"].find(function(e){return!!i&&-1!==i.indexOf(e)}))&&(t=a.indexOf(u),a=a.substr(t),i=i.substr(t),h+=t),r=i?"scheme":s?"www":"tld",n=!!i,x.push(new w({tagBuilder:b,matchedText:a,offset:h,urlMatchType:r,url:a,protocolUrlMatch:n,protocolRelativeMatch:!!l,stripPrefix:f,stripTrailingSlash:m,decodePercentEncoding:A}))))}();return x},ae.prototype.matchHasUnbalancedClosingParen=function(e){var t,u=e.charAt(e.length-1);if(")"===u)t="(";else if("]"===u)t="[";else{if("}"!==u)return!1;t="{"}for(var r=0,n=0,a=e.length-1;n<a;n++){var i=e.charAt(n);i===t?r++:i===u&&(r=Math.max(r-1,0))}return 0===r},ae.prototype.matchHasInvalidCharAfterTld=function(e,t){if(!e)return-1;var u=0;t&&(u=e.indexOf(":"),e=e.slice(u));var r=new RegExp("^((.?//)?[-."+W+"]*[-"+W+"]\\.[-"+W+"]+)").exec(e);return null===r?-1:(u+=r[1].length,e=e.slice(r[1].length),/^[^-.A-Za-z0-9:\/?#]/.test(e)?u:-1)},ae);function ae(e){var t=te.call(this,e)||this;return t.stripPrefix={scheme:!0,www:!0},t.stripTrailingSlash=!0,t.decodePercentEncoding=!0,t.matcherRegex=ue,t.wordCharRegExp=re,t.stripPrefix=e.stripPrefix,t.stripTrailingSlash=e.stripTrailingSlash,t.decodePercentEncoding=e.decodePercentEncoding,t}var ie,se=new RegExp("#[_"+W+"]{1,139}(?![_"+W+"])","g"),oe=new RegExp("[^"+W+"]"),ce=(h(he,ie=D),he.prototype.parseMatches=function(e){for(var t,u=this.matcherRegex,r=this.nonWordCharRegex,n=this.serviceName,a=this.tagBuilder,i=[];null!==(t=u.exec(e));){var s,o,c=t.index,h=e.charAt(c-1);0!==c&&!r.test(h)||(s=t[0],o=t[0].slice(1),i.push(new d({tagBuilder:a,matchedText:s,offset:c,serviceName:n,hashtag:o})))}return i},he);function he(e){var t=ie.call(this,e)||this;return t.serviceName="twitter",t.matcherRegex=se,t.nonWordCharRegex=oe,t.serviceName=e.serviceName,t}var le,pe=new RegExp(/(?:(?:(?:(\+)?\d{1,3}[-\040.]?)?\(?\d{3}\)?[-\040.]?\d{3}[-\040.]?\d{4})|(?:(\+)(?:9[976]\d|8[987530]\d|6[987]\d|5[90]\d|42\d|3[875]\d|2[98654321]\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)[-\040.]?(?:\d[-\040.]?){6,12}\d+))([,;]+[0-9]+#?)*/.source+"|"+/(0([1-9]{1}-?[1-9]\d{3}|[1-9]{2}-?\d{3}|[1-9]{2}\d{1}-?\d{2}|[1-9]{2}\d{2}-?\d{1})-?\d{4}|0[789]0-?\d{4}-?\d{4}|050-?\d{4}-?\d{4})/.source,"g"),ge=(h(de,le=D),de.prototype.parseMatches=function(e){for(var t,u=this.matcherRegex,r=this.tagBuilder,n=[];null!==(t=u.exec(e));){var a=t[0],i=a.replace(/[^0-9,;#]/g,""),s=!(!t[1]&&!t[2]),o=0==t.index?"":e.substr(t.index-1,1),c=e.substr(t.index+a.length,1),h=!o.match(/\d/)&&!c.match(/\d/);this.testMatch(t[3])&&this.testMatch(a)&&h&&n.push(new y({tagBuilder:r,matchedText:a,offset:t.index,number:i,plusSign:s}))}return n},de.prototype.testMatch=function(e){return M.test(e)},de);function de(){var e=null!==le&&le.apply(this,arguments)||this;return e.matcherRegex=pe,e}var fe,me=new RegExp("@[_"+W+"]{1,50}(?![_"+W+"])","g"),Ae=new RegExp("@[_."+W+"]{1,30}(?![_"+W+"])","g"),be=new RegExp("@[-_."+W+"]{1,50}(?![-_"+W+"])","g"),xe=new RegExp("[^"+W+"]"),ye=(h(Fe,fe=D),Fe.prototype.parseMatches=function(e){var t,u=this.serviceName,r=this.matcherRegexes[this.serviceName],n=this.nonWordCharRegex,a=this.tagBuilder,i=[];if(!r)return i;for(;null!==(t=r.exec(e));){var s,o,c=t.index,h=e.charAt(c-1);0!==c&&!n.test(h)||(o=(s=t[0].replace(/\.+$/g,"")).slice(1),i.push(new A({tagBuilder:a,matchedText:s,offset:c,serviceName:u,mention:o})))}return i},Fe);function Fe(e){var t=fe.call(this,e)||this;return t.serviceName="twitter",t.matcherRegexes={twitter:me,instagram:Ae,soundcloud:be},t.nonWordCharRegex=xe,t.serviceName=e.serviceName,t}function ve(t,e){for(var u,r,n,a,i,s,o,c,h,l,p,g,d,f,m,A=e.onOpenTag,b=e.onCloseTag,x=e.onText,y=e.onComment,F=e.onDoctype,v=new we,w=0,B=t.length,C=0,D=0,E=v;w<B;){var k=t.charAt(w);switch(C){case 0:"<"===k&&M();break;case 1:"!"===(f=k)?C=13:"/"===f?(C=2,E=new we(R(R({},E),{isClosing:!0}))):"<"===f?M():E=q.test(f)?(C=3,new we(R(R({},E),{isOpening:!0}))):(C=0,v);break;case 2:">"!==(d=k)&&q.test(d)?C=3:T();break;case 3:g=k,S.test(g)?(E=new we(R(R({},E),{name:j()})),C=4):"<"===g?M():"/"===g?(E=new we(R(R({},E),{name:j()})),C=12):">"===g?(E=new we(R(R({},E),{name:j()})),P()):q.test(g)||N.test(g)||":"===g||T();break;case 4:p=k,S.test(p)||("/"===p?C=12:">"===p?P():"<"===p?M():"="===p||O.test(p)||H.test(p)?T():C=5);break;case 5:l=k,S.test(l)?C=6:"/"===l?C=12:"="===l?C=7:">"===l?P():"<"===l?M():O.test(l)&&T();break;case 6:h=k,S.test(h)||("/"===h?C=12:"="===h?C=7:">"===h?P():"<"===h?M():O.test(h)?T():C=5);break;case 7:c=k,S.test(c)||('"'===c?C=8:"'"===c?C=9:/[>=`]/.test(c)?T():"<"===c?M():C=10);break;case 8:'"'===k&&(C=11);break;case 9:"'"===k&&(C=11);break;case 10:o=k,S.test(o)?C=4:">"===o?P():"<"===o&&M();break;case 11:s=k,S.test(s)?C=4:"/"===s?C=12:">"===s?P():"<"===s?M():(C=4,w--);break;case 12:">"===k?(E=new we(R(R({},E),{isClosing:!0})),P()):C=4;break;case 13:"--"===t.substr(w,2)?(w+=2,E=new we(R(R({},E),{type:"comment"})),C=14):"DOCTYPE"===t.substr(w,7).toUpperCase()?(w+=7,E=new we(R(R({},E),{type:"doctype"})),C=20):T();break;case 14:"-"===(i=k)?C=15:">"===i?T():C=16;break;case 15:"-"===(a=k)?C=18:">"===a?T():C=16;break;case 16:"-"===k&&(C=17);break;case 17:C="-"===k?18:16;break;case 18:">"===(n=k)?P():"!"===n?C=19:"-"===n||(C=16);break;case 19:"-"===(r=k)?C=17:">"===r?P():C=16;break;case 20:">"===(u=k)?P():"<"===u&&M();break;default:z(C)}w++}function T(){C=0,E=v}function M(){C=1,E=new we({idx:w})}function P(){var e=t.slice(D,E.idx);e&&x(e,D),"comment"===E.type?y(E.idx):"doctype"===E.type?F(E.idx):(E.isOpening&&A(E.name,E.idx),E.isClosing&&b(E.name,E.idx)),T(),D=w+1}function j(){var e=E.idx+(E.isClosing?2:1);return t.slice(e,w).toLowerCase()}D<w&&(m=t.slice(D,w),x(m,D),D=w+1)}var we=function(e){void 0===e&&(e={}),this.idx=void 0!==e.idx?e.idx:-1,this.type=e.type||"tag",this.name=e.name||"",this.isOpening=!!e.isOpening,this.isClosing=!!e.isClosing};function Be(e){void 0===e&&(e={}),this.version=Be.version,this.urls={},this.email=!0,this.phone=!0,this.hashtag=!1,this.mention=!1,this.newWindow=!0,this.stripPrefix={scheme:!0,www:!0},this.stripTrailingSlash=!0,this.decodePercentEncoding=!0,this.truncate={length:0,location:"end"},this.className="",this.replaceFn=null,this.context=void 0,this.sanitizeHtml=!1,this.matchers=null,this.tagBuilder=null,this.urls=this.normalizeUrlsCfg(e.urls),this.email="boolean"==typeof e.email?e.email:this.email,this.phone="boolean"==typeof e.phone?e.phone:this.phone,this.hashtag=e.hashtag||this.hashtag,this.mention=e.mention||this.mention,this.newWindow="boolean"==typeof e.newWindow?e.newWindow:this.newWindow,this.stripPrefix=this.normalizeStripPrefixCfg(e.stripPrefix),this.stripTrailingSlash="boolean"==typeof e.stripTrailingSlash?e.stripTrailingSlash:this.stripTrailingSlash,this.decodePercentEncoding="boolean"==typeof e.decodePercentEncoding?e.decodePercentEncoding:this.decodePercentEncoding,this.sanitizeHtml=e.sanitizeHtml||!1;var t=this.mention;if(!1!==t&&"twitter"!==t&&"instagram"!==t&&"soundcloud"!==t)throw new Error("invalid `mention` cfg - see docs");var u=this.hashtag;if(!1!==u&&"twitter"!==u&&"facebook"!==u&&"instagram"!==u)throw new Error("invalid `hashtag` cfg - see docs");this.truncate=this.normalizeTruncateCfg(e.truncate),this.className=e.className||this.className,this.replaceFn=e.replaceFn||this.replaceFn,this.context=e.context||this}return Be.link=function(e,t){return new Be(t).link(e)},Be.parse=function(e,t){return new Be(t).parse(e)},Be.prototype.normalizeUrlsCfg=function(e){return null==e&&(e=!0),"boolean"==typeof e?{schemeMatches:e,wwwMatches:e,tldMatches:e}:{schemeMatches:"boolean"!=typeof e.schemeMatches||e.schemeMatches,wwwMatches:"boolean"!=typeof e.wwwMatches||e.wwwMatches,tldMatches:"boolean"!=typeof e.tldMatches||e.tldMatches}},Be.prototype.normalizeStripPrefixCfg=function(e){return null==e&&(e=!0),"boolean"==typeof e?{scheme:e,www:e}:{scheme:"boolean"!=typeof e.scheme||e.scheme,www:"boolean"!=typeof e.www||e.www}},Be.prototype.normalizeTruncateCfg=function(e){return"number"==typeof e?{length:e,location:"end"}:function(e,t){for(var u in t)t.hasOwnProperty(u)&&void 0===e[u]&&(e[u]=t[u]);return e}(e||{},{length:Number.POSITIVE_INFINITY,location:"end"})},Be.prototype.parse=function(e){var n=this,t=["a","style","script"],a=0,i=[];return ve(e,{onOpenTag:function(e){0<=t.indexOf(e)&&a++},onText:function(e,t){var u,r;0===a&&(u=function(e,t){if(!t.global)throw new Error("`splitRegex` must have the 'g' flag set");for(var u,r=[],n=0;u=t.exec(e);)r.push(e.substring(n,u.index)),r.push(u[0]),n=u.index+u[0].length;return r.push(e.substring(n)),r}(e,/(&nbsp;|&#160;|&lt;|&#60;|&gt;|&#62;|&quot;|&#34;|&#39;)/gi),r=t,u.forEach(function(e,t){var u;t%2==0&&(u=n.parseText(e,r),i.push.apply(i,u)),r+=e.length}))},onCloseTag:function(e){0<=t.indexOf(e)&&(a=Math.max(a-1,0))},onComment:function(e){},onDoctype:function(e){}}),i=this.compactMatches(i),i=this.removeUnwantedMatches(i)},Be.prototype.compactMatches=function(e){e.sort(function(e,t){return e.getOffset()-t.getOffset()});for(var t=0;t<e.length-1;t++){var u=e[t],r=u.getOffset(),n=u.getMatchedText().length,a=r+n;if(t+1<e.length){if(e[t+1].getOffset()===r){var i=e[t+1].getMatchedText().length>n?t:t+1;e.splice(i,1);continue}e[t+1].getOffset()<a&&e.splice(t+1,1)}}return e},Be.prototype.removeUnwantedMatches=function(e){return this.hashtag||t(e,function(e){return"hashtag"===e.getType()}),this.email||t(e,function(e){return"email"===e.getType()}),this.phone||t(e,function(e){return"phone"===e.getType()}),this.mention||t(e,function(e){return"mention"===e.getType()}),this.urls.schemeMatches||t(e,function(e){return"url"===e.getType()&&"scheme"===e.getUrlMatchType()}),this.urls.wwwMatches||t(e,function(e){return"url"===e.getType()&&"www"===e.getUrlMatchType()}),this.urls.tldMatches||t(e,function(e){return"url"===e.getType()&&"tld"===e.getUrlMatchType()}),e},Be.prototype.parseText=function(e,t){void 0===t&&(t=0),t=t||0;for(var u=this.getMatchers(),r=[],n=0,a=u.length;n<a;n++){for(var i=u[n].parseMatches(e),s=0,o=i.length;s<o;s++)i[s].setOffset(t+i[s].getOffset());r.push.apply(r,i)}return r},Be.prototype.link=function(e){if(!e)return"";this.sanitizeHtml&&(e=e.replace(/</g,"&lt;").replace(/>/g,"&gt;"));for(var t=this.parse(e),u=[],r=0,n=0,a=t.length;n<a;n++){var i=t[n];u.push(e.substring(r,i.getOffset())),u.push(this.createMatchReturnVal(i)),r=i.getOffset()+i.getMatchedText().length}return u.push(e.substring(r)),u.join("")},Be.prototype.createMatchReturnVal=function(e){var t;return this.replaceFn&&(t=this.replaceFn.call(this.context,e)),"string"==typeof t?t:!1===t?e.getMatchedText():t instanceof u?t.toAnchorString():e.buildTag().toAnchorString()},Be.prototype.getMatchers=function(){if(this.matchers)return this.matchers;var e=this.getTagBuilder(),t=[new ce({tagBuilder:e,serviceName:this.hashtag}),new G({tagBuilder:e}),new ge({tagBuilder:e}),new ye({tagBuilder:e,serviceName:this.mention}),new ne({tagBuilder:e,stripPrefix:this.stripPrefix,stripTrailingSlash:this.stripTrailingSlash,decodePercentEncoding:this.decodePercentEncoding})];return this.matchers=t},Be.prototype.getTagBuilder=function(){return this.tagBuilder||(this.tagBuilder=new r({newWindow:this.newWindow,truncate:this.truncate,className:this.className}))},Be.version="3.14.3",Be.AnchorTagBuilder=r,Be.HtmlTag=u,Be.matcher={Email:G,Hashtag:ce,Matcher:D,Mention:ye,Phone:ge,Url:ne},Be.match={Email:B,Hashtag:d,Match:a,Mention:A,Phone:y,Url:w},Be});
//# sourceMappingURL=Autolinker.min.js.map
