<p align="center"><a href="http://autonumeric.org"><img src="http://autonumeric.org/statics/icons/apple-icon-152x152.png" alt="autonumeric.org"></a></p>
<p align="center">
<a href="https://npmjs.org/package/autonumeric"><img src="https://img.shields.io/npm/v/autonumeric.svg" alt="Latest Version"></a>
<a href="https://app.travis-ci.com/github/autoNumeric/autoNumeric/"><img src="https://app.travis-ci.com/autoNumeric/autoNumeric.svg?branch=next" alt="Build Status"></a>
<a href="https://snyk.io/test/github/autoNumeric/autoNumeric"><img src="https://snyk.io/test/github/autoNumeric/autoNumeric/badge.svg" alt="Known Vulnerabilities"></a>
<a href="https://coveralls.io/github/autoNumeric/autoNumeric?branch=next"><img src="https://coveralls.io/repos/github/autoNumeric/autoNumeric/badge.svg?branch=next" alt="Coverage Status"></a>
<a href="https://github.com/autoNumeric/autoNumeric/stargazers"><img src="https://img.shields.io/github/stars/autoNumeric/autoNumeric?color=yellow" alt="GitHub Repo stars"></a>
<br>
<a href="https://gitter.im/autoNumeric/autoNumeric"><img src="https://img.shields.io/badge/gitter-autoNumeric%2FautoNumeric-brightgreen.svg" alt="Gitter chat"></a>
<a href="http://badge.fury.io/js/autonumeric"><img src="http://img.shields.io/npm/dm/autonumeric.svg" alt="Npm downloads per month"></a>
<a href="https://www.jsdelivr.com/package/npm/autonumeric"><img src="https://data.jsdelivr.com/v1/package/npm/autonumeric/badge?style=rounded" alt="jsDelivr downloads per month"></a>
</p>

## What is [AutoNumeric](http://autonumeric.org)?

AutoNumeric is a standalone Javascript library that provides live *as-you-type* formatting for international numbers and currencies.


### Highlights

AutoNumeric main features are:

- **Easy** to use and configure
- Very **high configurability** (more than 40 [options](https://docs.autonumeric.org/Documentation/configuration%20options/) available)
- User experience oriented ; using autoNumeric just **feels right and natural**, specially with the [function chaining](https://docs.autonumeric.org/Documentation/instantiated%20methods/#function-chaining) feature
- Supports most [**international**](https://docs.autonumeric.org/Documentation/predefined%20options/#predefined-language-options) numeric formats and currencies<br>*(If the one you use is not supported yet, open an [issue](https://github.com/autoNumeric/autoNumeric/issues/new) and we'll add it as soon as possible!)*
- The mobile Android Chrome browser is partially supported

...and [much more](https://docs.autonumeric.org).

All in all, AutoNumeric supports most international numeric formats and currencies including those used in Europe, Asia, and North and South America.

****

### Documentation

The documentation previously shown in that readme has now been moved to a specific web page where it's much more user-friendly; you can check it out on [https://docs.autonumeric.org](https://docs.autonumeric.org).

#### Tools
For checking the official AutoNumeric website, you can take a look at [http://autonumeric.org](http://autonumeric.org). On this website you'll find additional tools for instance to generate your options configuration.

****

### AutoNumeric versions

AutoNumeric provides 2 branches, `master` and `next`.

The very, *very* stable version is on the `master` branch (currently this is version [4.6.*](https://github.com/autoNumeric/autoNumeric/tree/master)).

The `next` [branch](https://github.com/autoNumeric/autoNumeric/tree/next) contains all the new features and fixes, and is considered 'stable' too.

> Do note that the `next` branch can see changes in the API (check the [semver](http://semver.org/)), but is always fully tested for regressions.<br>It's safe to use on production servers since it's always thoroughly tested and should not contain any bugs *(that we know of)*.

****

### Licence
AutoNumeric is an [MIT](http://opensource.org/licenses/MIT)-licensed open source project, and its authors are credited in [AUTHORS](https://github.com/autoNumeric/autoNumeric/blob/next/AUTHORS).

****

### Support

AutoNumeric is created using the [JetBrains IDE](https://www.jetbrains.com/community/opensource/#support), which kindly provide access to its tools to the developers.<br>
If you feel AutoNumeric is useful to you, please consider [supporting](https://docs.autonumeric.org/Documentation/support/) the project.

### Contributors

**Thanks** to all the contributors over the years for making AutoNumeric a reality!

<a href="https://github.com/autoNumeric/autoNumeric/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=autoNumeric/autoNumeric" />
</a>
