'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Declaration = require('../declaration');
var shorthand = require('./grid-shorthand');

var GridRowColumn = function (_Declaration) {
    _inherits(GridRowColumn, _Declaration);

    function GridRowColumn() {
        _classCallCheck(this, GridRowColumn);

        return _possibleConstructorReturn(this, _Declaration.apply(this, arguments));
    }

    /**
     * Translate grid-row / grid-column to separate -ms- prefixed properties
     */
    GridRowColumn.prototype.insert = function insert(decl, prefix, prefixes) {
        if (prefix !== '-ms-') return _Declaration.prototype.insert.call(this, decl, prefix, prefixes);

        var values = shorthand.parse(decl);

        var _shorthand$translate = shorthand.translate(values, 0, 1),
            start = _shorthand$translate[0],
            span = _shorthand$translate[1];

        if (start) {
            decl.cloneBefore({
                prop: '-ms-' + decl.prop,
                value: start.toString()
            });
        }

        if (span) {
            decl.cloneBefore({
                prop: '-ms-' + decl.prop + '-span',
                value: span.toString()
            });
        }

        return undefined;
    };

    return GridRowColumn;
}(Declaration);

Object.defineProperty(GridRowColumn, 'names', {
    enumerable: true,
    writable: true,
    value: ['grid-row', 'grid-column']
});


module.exports = GridRowColumn;