import WebAwesomeElement from '../../internal/webawesome-element.js';
/**
 * @summary Spinners are used to show the progress of an indeterminate operation.
 * @documentation https://backers.webawesome.com/docs/components/spinner
 * @status stable
 * @since 2.0
 *
 * @csspart base - The component's base wrapper.
 *
 * @cssproperty --track-width - The width of the track.
 * @cssproperty --track-color - The color of the track.
 * @cssproperty --indicator-color - The color of the spinner's indicator.
 * @cssproperty --speed - The time it takes for the spinner to complete one animation cycle.
 */
export default class WaSpinner extends WebAwesomeElement {
    static css: string;
    private readonly localize;
    render(): import("lit-html").TemplateResult<1>;
}
declare global {
    interface HTMLElementTagNameMap {
        'wa-spinner': WaSpinner;
    }
}
