import Observable from 'zen-observable-ts';
import { MutationEvent } from '../';
import { ModelInstanceCreator } from '../../datastore/datastore';
import { ExclusiveStorage as Storage } from '../../storage/storage';
import { AuthModeStrategy, ConflictHandler, ErrorHandler, InternalSchema, PersistentModel, PersistentModelConstructor, SchemaModel, TypeConstructorMap } from '../../types';
import { MutationEventOutbox } from '../outbox';
import { TransformerMutationType } from '../utils';
declare type MutationProcessorEvent = {
    operation: TransformerMutationType;
    modelDefinition: SchemaModel;
    model: PersistentModel;
    hasMore: boolean;
};
declare class MutationProcessor {
    private readonly schema;
    private readonly storage;
    private readonly userClasses;
    private readonly outbox;
    private readonly modelInstanceCreator;
    private readonly MutationEvent;
    private readonly amplifyConfig;
    private readonly authModeStrategy;
    private readonly conflictHandler?;
    private readonly errorHandler?;
    private observer;
    private readonly typeQuery;
    private processing;
    constructor(schema: InternalSchema, storage: Storage, userClasses: TypeConstructorMap, outbox: MutationEventOutbox, modelInstanceCreator: ModelInstanceCreator, MutationEvent: PersistentModelConstructor<MutationEvent>, amplifyConfig: Record<string, any>, authModeStrategy: AuthModeStrategy, conflictHandler?: ConflictHandler, errorHandler?: ErrorHandler);
    private generateQueries;
    private isReady;
    start(): Observable<MutationProcessorEvent>;
    resume(): Promise<void>;
    private jitteredRetry;
    private createQueryVariables;
    private opTypeFromTransformerOperation;
    pause(): void;
}
declare const originalJitteredBackoff: import("@aws-amplify/core/lib-esm/types").DelayFunction;
/**
 * @private
 * Internal use of Amplify only.
 *
 * Wraps the jittered backoff calculation to retry Network Errors indefinitely.
 * Backs off according to original jittered retry logic until the original retry
 * logic hits its max. After this occurs, if the error is a Network Error, we
 * ignore the attempt count and return MAX_RETRY_DELAY_MS to retry forever (until
 * the request succeeds).
 *
 * @param attempt ignored
 * @param _args ignored
 * @param error tested to see if `.message` is 'Network Error'
 * @returns number | false :
 */
export declare const safeJitteredBackoff: typeof originalJitteredBackoff;
export { MutationProcessor };
