export interface GeoConfig {
    region?: string;
    AmazonLocationService?: {
        maps?: {
            items: {};
            default: string;
        };
        search_indices?: {
            items: string[];
            default: string;
        };
    };
}
export interface MapStyle {
    mapName: string;
    style: string;
}
export declare type Latitude = number;
export declare type Longitude = number;
export declare type Coordinates = [Longitude, Latitude];
export declare type SWLongitude = Longitude;
export declare type SWLatitude = Latitude;
export declare type NELongitude = Longitude;
export declare type NELatitude = Latitude;
export declare type BoundingBox = [SWLongitude, SWLatitude, NELongitude, NELatitude];
export interface SearchByTextOptionsBase {
    countries?: string[];
    maxResults?: number;
    searchIndexName?: string;
    providerName?: string;
}
export interface SearchByTextOptionsWithBiasPosition extends SearchByTextOptionsBase {
    biasPosition?: Coordinates;
}
export interface SearchByTextOptionsWithSearchAreaConstraints extends SearchByTextOptionsBase {
    searchAreaConstraints?: BoundingBox;
}
export declare type SearchByTextOptions = SearchByTextOptionsWithBiasPosition | SearchByTextOptionsWithSearchAreaConstraints;
export declare type SearchByCoordinatesOptions = {
    maxResults?: number;
    searchIndexName?: string;
    providerName?: string;
};
export declare type PlaceGeometry = {
    point: Coordinates;
};
export interface Place {
    addressNumber?: string;
    country?: string;
    geometry: PlaceGeometry | undefined;
    label?: string;
    municipality?: string;
    neighborhood?: string;
    postalCode?: string;
    region?: string;
    street?: string;
    subRegion?: string;
}
export declare type SearchForSuggestionsResults = string[];
