import { SearchByTextOptions, SearchByCoordinatesOptions, SearchForSuggestionsResults, Coordinates, Place, MapStyle } from './Geo';
export interface GeoProvider {
    getCategory(): string;
    getProviderName(): string;
    configure(config: object): object;
    getAvailableMaps(): MapStyle[];
    getDefaultMap(): MapStyle;
    searchByText(text: string, options?: SearchByTextOptions): Promise<Place[]>;
    searchByCoordinates(coordinates: Coordinates, options?: SearchByCoordinatesOptions): Promise<Place>;
    searchForSuggestions(text: string, options?: SearchByTextOptions): Promise<SearchForSuggestionsResults>;
}
