import { GeoConfig, Coordinates, SearchByTextOptions, SearchForSuggestionsResults, SearchByCoordinatesOptions, GeoProvider, MapStyle } from './types';
export declare class GeoClass {
    static MODULE: string;
    /**
     * @private
     */
    private _config;
    private _pluggables;
    constructor();
    /**
     * get the name of the module category
     * @returns {string} name of the module category
     */
    getModuleName(): string;
    /**
     * add plugin into Geo category
     * @param {Object} pluggable - an instance of the plugin
     */
    addPluggable(pluggable: GeoProvider): object;
    /**
     * Get the plugin object
     * @param providerName - the name of the plugin
     */
    getPluggable(providerName: string): GeoProvider;
    /**
     * Remove the plugin object
     * @param providerName - the name of the plugin
     */
    removePluggable(providerName: string): void;
    /**
     * Configure Geo
     * @param {Object} config - Configuration object for Geo
     * @return {Object} - Current configuration
     */
    configure(config?: any): GeoConfig;
    /**
     * Get the map resources that are currently available through the provider
     * @param {string} provider
     * @returns - Array of available map resources
     */
    getAvailableMaps(provider?: string): MapStyle[];
    /**
     * Get the map resource set as default in amplify config
     * @param {string} provider
     * @returns - Map resource set as the default in amplify config
     */
    getDefaultMap(provider?: string): MapStyle;
    /**
     * Search by text input with optional parameters
     * @param  {string} text - The text string that is to be searched for
     * @param  {SearchByTextOptions} options? - Optional parameters to the search
     * @returns {Promise<Place[]>} - Promise resolves to a list of Places that match search parameters
     */
    searchByText(text: string, options?: SearchByTextOptions): Promise<import("./types").Place[]>;
    /**
     * Search for search term suggestions based on input text
     * @param  {string} text - The text string that is to be search for
     * @param  {SearchByTextOptions} options? - Optional parameters to the search
     * @returns {Promise<SearchForSuggestionsResults>} - Resolves to an array of search suggestion strings
     */
    searchForSuggestions(text: string, options?: SearchByTextOptions): Promise<SearchForSuggestionsResults>;
    /**
     * Reverse geocoding search via a coordinate point on the map
     * @param coordinates - Coordinates array for the search input
     * @param options - Options parameters for the search
     * @returns {Promise<Place>} - Promise that resolves to a place matching search coordinates
     */
    searchByCoordinates(coordinates: Coordinates, options?: SearchByCoordinatesOptions): Promise<import("./types").Place>;
}
export declare const Geo: GeoClass;
