import { GeoConfig, SearchByTextOptions, SearchByCoordinatesOptions, GeoProvider, Place, AmazonLocationServiceMapStyle, Coordinates, SearchForSuggestionsResults } from '../types';
export declare class AmazonLocationServiceProvider implements GeoProvider {
    static CATEGORY: string;
    static PROVIDER_NAME: string;
    /**
     * @private
     */
    private _config;
    /**
     * Initialize Geo with AWS configurations
     * @param {Object} config - Configuration object for Geo
     */
    constructor(config?: GeoConfig);
    /**
     * get the category of the plugin
     * @returns {string} name of the category
     */
    getCategory(): string;
    /**
     * get provider name of the plugin
     * @returns {string} name of the provider
     */
    getProviderName(): string;
    /**
     * Configure Geo part with aws configuration
     * @param {Object} config - Configuration of the Geo
     * @return {Object} - Current configuration
     */
    configure(config?: any): object;
    /**
     * Get the map resources that are currently available through the provider
     * @returns {AmazonLocationServiceMapStyle[]}- Array of available map resources
     */
    getAvailableMaps(): AmazonLocationServiceMapStyle[];
    /**
     * Get the map resource set as default in amplify config
     * @returns {AmazonLocationServiceMapStyle} - Map resource set as the default in amplify config
     */
    getDefaultMap(): AmazonLocationServiceMapStyle;
    /**
     * Search by text input with optional parameters
     * @param  {string} text - The text string that is to be searched for
     * @param  {SearchByTextOptions} options? - Optional parameters to the search
     * @returns {Promise<Place[]>} - Promise resolves to a list of Places that match search parameters
     */
    searchByText(text: string, options?: SearchByTextOptions): Promise<Place[]>;
    /**
     * Search for suggestions based on the input text
     * @param  {string} text - The text string that is to be searched for
     * @param  {SearchByTextOptions} options? - Optional parameters to the search
     * @returns {Promise<SearchForSuggestionsResults>} - Resolves to an array of search suggestion strings
     */
    searchForSuggestions(text: string, options?: SearchByTextOptions): Promise<SearchForSuggestionsResults>;
    /**
     * Reverse geocoding search via a coordinate point on the map
     * @param coordinates - Coordinates array for the search input
     * @param options - Options parameters for the search
     * @returns {Promise<Place>} - Promise that resolves to a place matching search coordinates
     */
    searchByCoordinates(coordinates: Coordinates, options?: SearchByCoordinatesOptions): Promise<Place>;
    /**
     * @private
     */
    private _ensureCredentials;
    private _verifyMapResources;
    private _verifySearchIndex;
}
