"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Copyright 2017-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 *
 *     http://aws.amazon.com/apache2.0/
 *
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
var camelcase_keys_1 = __importDefault(require("camelcase-keys"));
var core_1 = require("@aws-amplify/core");
var client_location_1 = require("@aws-sdk/client-location");
var logger = new core_1.ConsoleLogger('AmazonLocationServiceProvider');
var AmazonLocationServiceProvider = /** @class */ (function () {
    /**
     * Initialize Geo with AWS configurations
     * @param {Object} config - Configuration object for Geo
     */
    function AmazonLocationServiceProvider(config) {
        this._config = config ? config : {};
        logger.debug('Geo Options', this._config);
    }
    /**
     * get the category of the plugin
     * @returns {string} name of the category
     */
    AmazonLocationServiceProvider.prototype.getCategory = function () {
        return AmazonLocationServiceProvider.CATEGORY;
    };
    /**
     * get provider name of the plugin
     * @returns {string} name of the provider
     */
    AmazonLocationServiceProvider.prototype.getProviderName = function () {
        return AmazonLocationServiceProvider.PROVIDER_NAME;
    };
    /**
     * Configure Geo part with aws configuration
     * @param {Object} config - Configuration of the Geo
     * @return {Object} - Current configuration
     */
    AmazonLocationServiceProvider.prototype.configure = function (config) {
        logger.debug('configure Amazon Location Service Provider', config);
        if (!config)
            return this._config;
        this._config = Object.assign({}, this._config, config);
        return this._config;
    };
    /**
     * Get the map resources that are currently available through the provider
     * @returns {AmazonLocationServiceMapStyle[]}- Array of available map resources
     */
    AmazonLocationServiceProvider.prototype.getAvailableMaps = function () {
        this._verifyMapResources();
        var mapStyles = [];
        var availableMaps = this._config.maps.items;
        var region = this._config.region;
        for (var mapName in availableMaps) {
            var style = availableMaps[mapName].style;
            mapStyles.push({ mapName: mapName, style: style, region: region });
        }
        return mapStyles;
    };
    /**
     * Get the map resource set as default in amplify config
     * @returns {AmazonLocationServiceMapStyle} - Map resource set as the default in amplify config
     */
    AmazonLocationServiceProvider.prototype.getDefaultMap = function () {
        this._verifyMapResources();
        var mapName = this._config.maps.default;
        var style = this._config.maps.items[mapName].style;
        var region = this._config.region;
        return { mapName: mapName, style: style, region: region };
    };
    /**
     * Search by text input with optional parameters
     * @param  {string} text - The text string that is to be searched for
     * @param  {SearchByTextOptions} options? - Optional parameters to the search
     * @returns {Promise<Place[]>} - Promise resolves to a list of Places that match search parameters
     */
    AmazonLocationServiceProvider.prototype.searchByText = function (text, options) {
        return __awaiter(this, void 0, void 0, function () {
            var credentialsOK, locationServiceInput, client, command, response, error_1, PascalResults, results;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._ensureCredentials()];
                    case 1:
                        credentialsOK = _a.sent();
                        if (!credentialsOK) {
                            throw new Error('No credentials');
                        }
                        this._verifySearchIndex(options === null || options === void 0 ? void 0 : options.searchIndexName);
                        locationServiceInput = {
                            Text: text,
                            IndexName: this._config.search_indices.default,
                        };
                        /**
                         * Map search options to Amazon Location Service input object
                         */
                        if (options) {
                            locationServiceInput.FilterCountries = options.countries;
                            locationServiceInput.MaxResults = options.maxResults;
                            if (options.searchIndexName) {
                                locationServiceInput.IndexName = options.searchIndexName;
                            }
                            if (options['biasPosition'] && options['searchAreaConstraints']) {
                                throw new Error('BiasPosition and SearchAreaConstraints are mutually exclusive, please remove one or the other from the options object');
                            }
                            if (options['biasPosition']) {
                                locationServiceInput.BiasPosition = options['biasPosition'];
                            }
                            if (options['searchAreaConstraints']) {
                                locationServiceInput.FilterBBox = options['searchAreaConstraints'];
                            }
                        }
                        client = new client_location_1.LocationClient({
                            credentials: this._config.credentials,
                            region: this._config.region,
                            customUserAgent: core_1.getAmplifyUserAgent(),
                        });
                        command = new client_location_1.SearchPlaceIndexForTextCommand(locationServiceInput);
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, client.send(command)];
                    case 3:
                        response = _a.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        error_1 = _a.sent();
                        logger.debug(error_1);
                        throw error_1;
                    case 5:
                        PascalResults = response.Results.map(function (result) { return result.Place; });
                        results = camelcase_keys_1.default(PascalResults, {
                            deep: true,
                        });
                        return [2 /*return*/, results];
                }
            });
        });
    };
    /**
     * Search for suggestions based on the input text
     * @param  {string} text - The text string that is to be searched for
     * @param  {SearchByTextOptions} options? - Optional parameters to the search
     * @returns {Promise<SearchForSuggestionsResults>} - Resolves to an array of search suggestion strings
     */
    AmazonLocationServiceProvider.prototype.searchForSuggestions = function (text, options) {
        return __awaiter(this, void 0, void 0, function () {
            var credentialsOK, locationServiceInput, client, command, response, error_2, results;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._ensureCredentials()];
                    case 1:
                        credentialsOK = _a.sent();
                        if (!credentialsOK) {
                            throw new Error('No credentials');
                        }
                        this._verifySearchIndex(options === null || options === void 0 ? void 0 : options.searchIndexName);
                        locationServiceInput = {
                            Text: text,
                            IndexName: this._config.search_indices.default,
                        };
                        /**
                         * Map search options to Amazon Location Service input object
                         */
                        if (options) {
                            locationServiceInput.FilterCountries = options.countries;
                            locationServiceInput.MaxResults = options.maxResults;
                            if (options.searchIndexName) {
                                locationServiceInput.IndexName = options.searchIndexName;
                            }
                            if (options['biasPosition'] && options['searchAreaConstraints']) {
                                throw new Error('BiasPosition and SearchAreaConstraints are mutually exclusive, please remove one or the other from the options object');
                            }
                            if (options['biasPosition']) {
                                locationServiceInput.BiasPosition = options['biasPosition'];
                            }
                            if (options['searchAreaConstraints']) {
                                locationServiceInput.FilterBBox = options['searchAreaConstraints'];
                            }
                        }
                        client = new client_location_1.LocationClient({
                            credentials: this._config.credentials,
                            region: this._config.region,
                            customUserAgent: core_1.getAmplifyUserAgent(),
                        });
                        command = new client_location_1.SearchPlaceIndexForSuggestionsCommand(locationServiceInput);
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, client.send(command)];
                    case 3:
                        response = _a.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        error_2 = _a.sent();
                        logger.debug(error_2);
                        throw error_2;
                    case 5:
                        results = response.Results.map(function (result) { return result.Text; });
                        return [2 /*return*/, results];
                }
            });
        });
    };
    /**
     * Reverse geocoding search via a coordinate point on the map
     * @param coordinates - Coordinates array for the search input
     * @param options - Options parameters for the search
     * @returns {Promise<Place>} - Promise that resolves to a place matching search coordinates
     */
    AmazonLocationServiceProvider.prototype.searchByCoordinates = function (coordinates, options) {
        return __awaiter(this, void 0, void 0, function () {
            var credentialsOK, locationServiceInput, client, command, response, error_3, PascalResults, results;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this._ensureCredentials()];
                    case 1:
                        credentialsOK = _a.sent();
                        if (!credentialsOK) {
                            throw new Error('No credentials');
                        }
                        this._verifySearchIndex(options === null || options === void 0 ? void 0 : options.searchIndexName);
                        locationServiceInput = {
                            Position: coordinates,
                            IndexName: this._config.search_indices.default,
                        };
                        if (options) {
                            if (options.searchIndexName) {
                                locationServiceInput.IndexName = options.searchIndexName;
                            }
                            locationServiceInput.MaxResults = options.maxResults;
                        }
                        client = new client_location_1.LocationClient({
                            credentials: this._config.credentials,
                            region: this._config.region,
                            customUserAgent: core_1.getAmplifyUserAgent(),
                        });
                        command = new client_location_1.SearchPlaceIndexForPositionCommand(locationServiceInput);
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, client.send(command)];
                    case 3:
                        response = _a.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        error_3 = _a.sent();
                        logger.debug(error_3);
                        throw error_3;
                    case 5:
                        PascalResults = response.Results.map(function (result) { return result.Place; });
                        results = camelcase_keys_1.default(PascalResults[0], {
                            deep: true,
                        });
                        return [2 /*return*/, results];
                }
            });
        });
    };
    /**
     * @private
     */
    AmazonLocationServiceProvider.prototype._ensureCredentials = function () {
        return __awaiter(this, void 0, void 0, function () {
            var credentials, cred, error_4;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, core_1.Credentials.get()];
                    case 1:
                        credentials = _a.sent();
                        if (!credentials)
                            return [2 /*return*/, false];
                        cred = core_1.Credentials.shear(credentials);
                        logger.debug('Set credentials for storage. Credentials are:', cred);
                        this._config.credentials = cred;
                        return [2 /*return*/, true];
                    case 2:
                        error_4 = _a.sent();
                        logger.warn('Ensure credentials error. Credentials are:', error_4);
                        return [2 /*return*/, false];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    AmazonLocationServiceProvider.prototype._verifyMapResources = function () {
        if (!this._config.maps) {
            var errorString = "No map resources found in amplify config, run 'amplify add geo' to create them and run `amplify push` after";
            logger.warn(errorString);
            throw new Error(errorString);
        }
        if (!this._config.maps.default) {
            var errorString = "No default map resource found in amplify config, run 'amplify add geo' to create one and run `amplify push` after";
            logger.warn(errorString);
            throw new Error(errorString);
        }
    };
    AmazonLocationServiceProvider.prototype._verifySearchIndex = function (optionalSearchIndex) {
        if ((!this._config.search_indices || !this._config.search_indices.default) &&
            !optionalSearchIndex) {
            var errorString = 'No Search Index found, please run `amplify add geo` to add one and run `amplify push` after.';
            logger.warn(errorString);
            throw new Error(errorString);
        }
    };
    AmazonLocationServiceProvider.CATEGORY = 'Geo';
    AmazonLocationServiceProvider.PROVIDER_NAME = 'AmazonLocationService';
    return AmazonLocationServiceProvider;
}());
exports.AmazonLocationServiceProvider = AmazonLocationServiceProvider;
//# sourceMappingURL=AmazonLocationServiceProvider.js.map