import { PutObjectCommandInput } from '@aws-sdk/client-s3';
import { StorageOptions, StorageProvider, S3ProviderGetConfig, S3ProviderGetOuput, S3ProviderPutConfig, S3ProviderRemoveConfig, S3ProviderListOutput, S3ProviderListConfig, S3ProviderCopyConfig, S3ProviderCopyOutput, S3CopySource, S3CopyDestination, S3ProviderRemoveOutput, S3ProviderPutOutput } from '../types';
/**
 * Provide storage methods to use AWS S3
 */
export declare class AWSS3Provider implements StorageProvider {
    static readonly CATEGORY = "Storage";
    static readonly PROVIDER_NAME = "AWSS3";
    private _config;
    private _storage;
    /**
     * Initialize Storage with AWS configurations
     * @param {Object} config - Configuration object for storage
     */
    constructor(config?: StorageOptions);
    /**
     * get the category of the plugin
     */
    getCategory(): string;
    /**
     * get provider name of the plugin
     */
    getProviderName(): 'AWSS3';
    /**
     * Configure Storage part with aws configuration
     * @param {Object} config - Configuration of the Storage
     * @return {Object} - Current configuration
     */
    configure(config?: any): object;
    private startResumableUpload;
    /**
     * Copy an object from a source object to a new object within the same bucket. Can optionally copy files across
     * different level or identityId (if source object's level is 'protected').
     *
     * @async
     * @param {S3CopySource} src - Key and optionally access level and identityId of the source object.
     * @param {S3CopyDestination} dest - Key and optionally access level of the destination object.
     * @param {S3ProviderCopyConfig} [config] - Optional configuration for s3 commands.
     * @return {Promise<S3ProviderCopyOutput>} The key of the copied object.
     */
    copy(src: S3CopySource, dest: S3CopyDestination, config?: S3ProviderCopyConfig): Promise<S3ProviderCopyOutput>;
    /**
     * Get a presigned URL of the file or the object data when download:true
     *
     * @param {string} key - key of the object
     * @param {S3ProviderGetConfig} [config] - Optional configuration for the underlying S3 command
     * @return {Promise<string | GetObjectCommandOutput>} - A promise resolves to Amazon S3 presigned URL or the
     * GetObjectCommandOutput if download is set to true on success
     */
    get<T extends S3ProviderGetConfig & StorageOptions>(key: string, config?: T): Promise<S3ProviderGetOuput<T>>;
    /**
     * Put a file in S3 bucket specified to configure method
     * @param key - key of the object
     * @param object - File to be put in Amazon S3 bucket
     * @param [config] - Optional configuration for the underlying S3 command
     * @return an instance of AWSS3UploadTask or a promise that resolves to an object with the new object's key on
     * success.
     */
    put<T extends S3ProviderPutConfig>(key: string, object: PutObjectCommandInput['Body'], config?: T): S3ProviderPutOutput<T>;
    /**
     * Remove the object for specified key
     * @param {string} key - key of the object
     * @param {S3ProviderRemoveConfig} [config] - Optional configuration for the underlying S3 command
     * @return {Promise<S3ProviderRemoveOutput>} - Promise resolves upon successful removal of the object
     */
    remove(key: string, config?: S3ProviderRemoveConfig): Promise<S3ProviderRemoveOutput>;
    /**
     * List bucket objects relative to the level and prefix specified
     * @param {string} path - the path that contains objects
     * @param {S3ProviderListConfig} [config] - Optional configuration for the underlying S3 command
     * @return {Promise<S3ProviderListOutput>} - Promise resolves to list of keys, eTags, lastModified and file size for
     * all objects in path
     */
    list(path: string, config?: S3ProviderListConfig): Promise<S3ProviderListOutput>;
    private _ensureCredentials;
    private _isWithCredentials;
    private _prefix;
    /**
     * Creates an S3 client with new V3 aws sdk
     */
    private _createNewS3Client;
}
/**
 * @deprecated use named import
 */
export default AWSS3Provider;
