import {Request} from '../lib/request';
import {Response} from '../lib/response';
import {AWSError} from '../lib/error';
import {Service} from '../lib/service';
import {ServiceConfigurationOptions} from '../lib/service';
import {ConfigBase as Config} from '../lib/config';
interface Blob {}
declare class PinpointEmail extends Service {
  /**
   * Constructs a service object. This object has one method for each API operation.
   */
  constructor(options?: PinpointEmail.Types.ClientConfiguration)
  config: Config & PinpointEmail.Types.ClientConfiguration;
  /**
   * Create a configuration set. Configuration sets are groups of rules that you can apply to the emails you send using Amazon Pinpoint. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email. 
   */
  createConfigurationSet(params: PinpointEmail.Types.CreateConfigurationSetRequest, callback?: (err: AWSError, data: PinpointEmail.Types.CreateConfigurationSetResponse) => void): Request<PinpointEmail.Types.CreateConfigurationSetResponse, AWSError>;
  /**
   * Create a configuration set. Configuration sets are groups of rules that you can apply to the emails you send using Amazon Pinpoint. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email. 
   */
  createConfigurationSet(callback?: (err: AWSError, data: PinpointEmail.Types.CreateConfigurationSetResponse) => void): Request<PinpointEmail.Types.CreateConfigurationSetResponse, AWSError>;
  /**
   * Create an event destination. In Amazon Pinpoint, events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage. A single configuration set can include more than one event destination.
   */
  createConfigurationSetEventDestination(params: PinpointEmail.Types.CreateConfigurationSetEventDestinationRequest, callback?: (err: AWSError, data: PinpointEmail.Types.CreateConfigurationSetEventDestinationResponse) => void): Request<PinpointEmail.Types.CreateConfigurationSetEventDestinationResponse, AWSError>;
  /**
   * Create an event destination. In Amazon Pinpoint, events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage. A single configuration set can include more than one event destination.
   */
  createConfigurationSetEventDestination(callback?: (err: AWSError, data: PinpointEmail.Types.CreateConfigurationSetEventDestinationResponse) => void): Request<PinpointEmail.Types.CreateConfigurationSetEventDestinationResponse, AWSError>;
  /**
   * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your Amazon Pinpoint account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, Amazon Pinpoint sends it using only the IP addresses in the associated pool.
   */
  createDedicatedIpPool(params: PinpointEmail.Types.CreateDedicatedIpPoolRequest, callback?: (err: AWSError, data: PinpointEmail.Types.CreateDedicatedIpPoolResponse) => void): Request<PinpointEmail.Types.CreateDedicatedIpPoolResponse, AWSError>;
  /**
   * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your Amazon Pinpoint account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, Amazon Pinpoint sends it using only the IP addresses in the associated pool.
   */
  createDedicatedIpPool(callback?: (err: AWSError, data: PinpointEmail.Types.CreateDedicatedIpPoolResponse) => void): Request<PinpointEmail.Types.CreateDedicatedIpPoolResponse, AWSError>;
  /**
   * Verifies an email identity for use with Amazon Pinpoint. In Amazon Pinpoint, an identity is an email address or domain that you use when you send email. Before you can use an identity to send email with Amazon Pinpoint, you first have to verify it. By verifying an address, you demonstrate that you're the owner of the address, and that you've given Amazon Pinpoint permission to send email from the address. When you verify an email address, Amazon Pinpoint sends an email to the address. Your email address is verified as soon as you follow the link in the verification email.  When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon Pinpoint detects these records in the DNS configuration for your domain. It usually takes around 72 hours to complete the domain verification process.
   */
  createEmailIdentity(params: PinpointEmail.Types.CreateEmailIdentityRequest, callback?: (err: AWSError, data: PinpointEmail.Types.CreateEmailIdentityResponse) => void): Request<PinpointEmail.Types.CreateEmailIdentityResponse, AWSError>;
  /**
   * Verifies an email identity for use with Amazon Pinpoint. In Amazon Pinpoint, an identity is an email address or domain that you use when you send email. Before you can use an identity to send email with Amazon Pinpoint, you first have to verify it. By verifying an address, you demonstrate that you're the owner of the address, and that you've given Amazon Pinpoint permission to send email from the address. When you verify an email address, Amazon Pinpoint sends an email to the address. Your email address is verified as soon as you follow the link in the verification email.  When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon Pinpoint detects these records in the DNS configuration for your domain. It usually takes around 72 hours to complete the domain verification process.
   */
  createEmailIdentity(callback?: (err: AWSError, data: PinpointEmail.Types.CreateEmailIdentityResponse) => void): Request<PinpointEmail.Types.CreateEmailIdentityResponse, AWSError>;
  /**
   * Delete an existing configuration set. In Amazon Pinpoint, configuration sets are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
   */
  deleteConfigurationSet(params: PinpointEmail.Types.DeleteConfigurationSetRequest, callback?: (err: AWSError, data: PinpointEmail.Types.DeleteConfigurationSetResponse) => void): Request<PinpointEmail.Types.DeleteConfigurationSetResponse, AWSError>;
  /**
   * Delete an existing configuration set. In Amazon Pinpoint, configuration sets are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
   */
  deleteConfigurationSet(callback?: (err: AWSError, data: PinpointEmail.Types.DeleteConfigurationSetResponse) => void): Request<PinpointEmail.Types.DeleteConfigurationSetResponse, AWSError>;
  /**
   * Delete an event destination. In Amazon Pinpoint, events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
   */
  deleteConfigurationSetEventDestination(params: PinpointEmail.Types.DeleteConfigurationSetEventDestinationRequest, callback?: (err: AWSError, data: PinpointEmail.Types.DeleteConfigurationSetEventDestinationResponse) => void): Request<PinpointEmail.Types.DeleteConfigurationSetEventDestinationResponse, AWSError>;
  /**
   * Delete an event destination. In Amazon Pinpoint, events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
   */
  deleteConfigurationSetEventDestination(callback?: (err: AWSError, data: PinpointEmail.Types.DeleteConfigurationSetEventDestinationResponse) => void): Request<PinpointEmail.Types.DeleteConfigurationSetEventDestinationResponse, AWSError>;
  /**
   * Delete a dedicated IP pool.
   */
  deleteDedicatedIpPool(params: PinpointEmail.Types.DeleteDedicatedIpPoolRequest, callback?: (err: AWSError, data: PinpointEmail.Types.DeleteDedicatedIpPoolResponse) => void): Request<PinpointEmail.Types.DeleteDedicatedIpPoolResponse, AWSError>;
  /**
   * Delete a dedicated IP pool.
   */
  deleteDedicatedIpPool(callback?: (err: AWSError, data: PinpointEmail.Types.DeleteDedicatedIpPoolResponse) => void): Request<PinpointEmail.Types.DeleteDedicatedIpPoolResponse, AWSError>;
  /**
   * Deletes an email identity that you previously verified for use with Amazon Pinpoint. An identity can be either an email address or a domain name.
   */
  deleteEmailIdentity(params: PinpointEmail.Types.DeleteEmailIdentityRequest, callback?: (err: AWSError, data: PinpointEmail.Types.DeleteEmailIdentityResponse) => void): Request<PinpointEmail.Types.DeleteEmailIdentityResponse, AWSError>;
  /**
   * Deletes an email identity that you previously verified for use with Amazon Pinpoint. An identity can be either an email address or a domain name.
   */
  deleteEmailIdentity(callback?: (err: AWSError, data: PinpointEmail.Types.DeleteEmailIdentityResponse) => void): Request<PinpointEmail.Types.DeleteEmailIdentityResponse, AWSError>;
  /**
   * Obtain information about the email-sending status and capabilities of your Amazon Pinpoint account in the current AWS Region.
   */
  getAccount(params: PinpointEmail.Types.GetAccountRequest, callback?: (err: AWSError, data: PinpointEmail.Types.GetAccountResponse) => void): Request<PinpointEmail.Types.GetAccountResponse, AWSError>;
  /**
   * Obtain information about the email-sending status and capabilities of your Amazon Pinpoint account in the current AWS Region.
   */
  getAccount(callback?: (err: AWSError, data: PinpointEmail.Types.GetAccountResponse) => void): Request<PinpointEmail.Types.GetAccountResponse, AWSError>;
  /**
   * Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more. In Amazon Pinpoint, configuration sets are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
   */
  getConfigurationSet(params: PinpointEmail.Types.GetConfigurationSetRequest, callback?: (err: AWSError, data: PinpointEmail.Types.GetConfigurationSetResponse) => void): Request<PinpointEmail.Types.GetConfigurationSetResponse, AWSError>;
  /**
   * Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more. In Amazon Pinpoint, configuration sets are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
   */
  getConfigurationSet(callback?: (err: AWSError, data: PinpointEmail.Types.GetConfigurationSetResponse) => void): Request<PinpointEmail.Types.GetConfigurationSetResponse, AWSError>;
  /**
   * Retrieve a list of event destinations that are associated with a configuration set. In Amazon Pinpoint, events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
   */
  getConfigurationSetEventDestinations(params: PinpointEmail.Types.GetConfigurationSetEventDestinationsRequest, callback?: (err: AWSError, data: PinpointEmail.Types.GetConfigurationSetEventDestinationsResponse) => void): Request<PinpointEmail.Types.GetConfigurationSetEventDestinationsResponse, AWSError>;
  /**
   * Retrieve a list of event destinations that are associated with a configuration set. In Amazon Pinpoint, events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
   */
  getConfigurationSetEventDestinations(callback?: (err: AWSError, data: PinpointEmail.Types.GetConfigurationSetEventDestinationsResponse) => void): Request<PinpointEmail.Types.GetConfigurationSetEventDestinationsResponse, AWSError>;
  /**
   * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address.
   */
  getDedicatedIp(params: PinpointEmail.Types.GetDedicatedIpRequest, callback?: (err: AWSError, data: PinpointEmail.Types.GetDedicatedIpResponse) => void): Request<PinpointEmail.Types.GetDedicatedIpResponse, AWSError>;
  /**
   * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address.
   */
  getDedicatedIp(callback?: (err: AWSError, data: PinpointEmail.Types.GetDedicatedIpResponse) => void): Request<PinpointEmail.Types.GetDedicatedIpResponse, AWSError>;
  /**
   * List the dedicated IP addresses that are associated with your Amazon Pinpoint account.
   */
  getDedicatedIps(params: PinpointEmail.Types.GetDedicatedIpsRequest, callback?: (err: AWSError, data: PinpointEmail.Types.GetDedicatedIpsResponse) => void): Request<PinpointEmail.Types.GetDedicatedIpsResponse, AWSError>;
  /**
   * List the dedicated IP addresses that are associated with your Amazon Pinpoint account.
   */
  getDedicatedIps(callback?: (err: AWSError, data: PinpointEmail.Types.GetDedicatedIpsResponse) => void): Request<PinpointEmail.Types.GetDedicatedIpsResponse, AWSError>;
  /**
   * Provides information about a specific identity associated with your Amazon Pinpoint account, including the identity's verification status, its DKIM authentication status, and its custom Mail-From settings.
   */
  getEmailIdentity(params: PinpointEmail.Types.GetEmailIdentityRequest, callback?: (err: AWSError, data: PinpointEmail.Types.GetEmailIdentityResponse) => void): Request<PinpointEmail.Types.GetEmailIdentityResponse, AWSError>;
  /**
   * Provides information about a specific identity associated with your Amazon Pinpoint account, including the identity's verification status, its DKIM authentication status, and its custom Mail-From settings.
   */
  getEmailIdentity(callback?: (err: AWSError, data: PinpointEmail.Types.GetEmailIdentityResponse) => void): Request<PinpointEmail.Types.GetEmailIdentityResponse, AWSError>;
  /**
   * List all of the configuration sets associated with your Amazon Pinpoint account in the current region. In Amazon Pinpoint, configuration sets are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
   */
  listConfigurationSets(params: PinpointEmail.Types.ListConfigurationSetsRequest, callback?: (err: AWSError, data: PinpointEmail.Types.ListConfigurationSetsResponse) => void): Request<PinpointEmail.Types.ListConfigurationSetsResponse, AWSError>;
  /**
   * List all of the configuration sets associated with your Amazon Pinpoint account in the current region. In Amazon Pinpoint, configuration sets are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
   */
  listConfigurationSets(callback?: (err: AWSError, data: PinpointEmail.Types.ListConfigurationSetsResponse) => void): Request<PinpointEmail.Types.ListConfigurationSetsResponse, AWSError>;
  /**
   * List all of the dedicated IP pools that exist in your Amazon Pinpoint account in the current AWS Region.
   */
  listDedicatedIpPools(params: PinpointEmail.Types.ListDedicatedIpPoolsRequest, callback?: (err: AWSError, data: PinpointEmail.Types.ListDedicatedIpPoolsResponse) => void): Request<PinpointEmail.Types.ListDedicatedIpPoolsResponse, AWSError>;
  /**
   * List all of the dedicated IP pools that exist in your Amazon Pinpoint account in the current AWS Region.
   */
  listDedicatedIpPools(callback?: (err: AWSError, data: PinpointEmail.Types.ListDedicatedIpPoolsResponse) => void): Request<PinpointEmail.Types.ListDedicatedIpPoolsResponse, AWSError>;
  /**
   * Returns a list of all of the email identities that are associated with your Amazon Pinpoint account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't.
   */
  listEmailIdentities(params: PinpointEmail.Types.ListEmailIdentitiesRequest, callback?: (err: AWSError, data: PinpointEmail.Types.ListEmailIdentitiesResponse) => void): Request<PinpointEmail.Types.ListEmailIdentitiesResponse, AWSError>;
  /**
   * Returns a list of all of the email identities that are associated with your Amazon Pinpoint account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't.
   */
  listEmailIdentities(callback?: (err: AWSError, data: PinpointEmail.Types.ListEmailIdentitiesResponse) => void): Request<PinpointEmail.Types.ListEmailIdentitiesResponse, AWSError>;
  /**
   * Enable or disable the automatic warm-up feature for dedicated IP addresses.
   */
  putAccountDedicatedIpWarmupAttributes(params: PinpointEmail.Types.PutAccountDedicatedIpWarmupAttributesRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutAccountDedicatedIpWarmupAttributesResponse) => void): Request<PinpointEmail.Types.PutAccountDedicatedIpWarmupAttributesResponse, AWSError>;
  /**
   * Enable or disable the automatic warm-up feature for dedicated IP addresses.
   */
  putAccountDedicatedIpWarmupAttributes(callback?: (err: AWSError, data: PinpointEmail.Types.PutAccountDedicatedIpWarmupAttributesResponse) => void): Request<PinpointEmail.Types.PutAccountDedicatedIpWarmupAttributesResponse, AWSError>;
  /**
   * Enable or disable the ability of your account to send email.
   */
  putAccountSendingAttributes(params: PinpointEmail.Types.PutAccountSendingAttributesRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutAccountSendingAttributesResponse) => void): Request<PinpointEmail.Types.PutAccountSendingAttributesResponse, AWSError>;
  /**
   * Enable or disable the ability of your account to send email.
   */
  putAccountSendingAttributes(callback?: (err: AWSError, data: PinpointEmail.Types.PutAccountSendingAttributesResponse) => void): Request<PinpointEmail.Types.PutAccountSendingAttributesResponse, AWSError>;
  /**
   * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.
   */
  putConfigurationSetDeliveryOptions(params: PinpointEmail.Types.PutConfigurationSetDeliveryOptionsRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutConfigurationSetDeliveryOptionsResponse) => void): Request<PinpointEmail.Types.PutConfigurationSetDeliveryOptionsResponse, AWSError>;
  /**
   * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.
   */
  putConfigurationSetDeliveryOptions(callback?: (err: AWSError, data: PinpointEmail.Types.PutConfigurationSetDeliveryOptionsResponse) => void): Request<PinpointEmail.Types.PutConfigurationSetDeliveryOptionsResponse, AWSError>;
  /**
   * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific AWS Region.
   */
  putConfigurationSetReputationOptions(params: PinpointEmail.Types.PutConfigurationSetReputationOptionsRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutConfigurationSetReputationOptionsResponse) => void): Request<PinpointEmail.Types.PutConfigurationSetReputationOptionsResponse, AWSError>;
  /**
   * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific AWS Region.
   */
  putConfigurationSetReputationOptions(callback?: (err: AWSError, data: PinpointEmail.Types.PutConfigurationSetReputationOptionsResponse) => void): Request<PinpointEmail.Types.PutConfigurationSetReputationOptionsResponse, AWSError>;
  /**
   * Enable or disable email sending for messages that use a particular configuration set in a specific AWS Region.
   */
  putConfigurationSetSendingOptions(params: PinpointEmail.Types.PutConfigurationSetSendingOptionsRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutConfigurationSetSendingOptionsResponse) => void): Request<PinpointEmail.Types.PutConfigurationSetSendingOptionsResponse, AWSError>;
  /**
   * Enable or disable email sending for messages that use a particular configuration set in a specific AWS Region.
   */
  putConfigurationSetSendingOptions(callback?: (err: AWSError, data: PinpointEmail.Types.PutConfigurationSetSendingOptionsResponse) => void): Request<PinpointEmail.Types.PutConfigurationSetSendingOptionsResponse, AWSError>;
  /**
   * Specify a custom domain to use for open and click tracking elements in email that you send using Amazon Pinpoint.
   */
  putConfigurationSetTrackingOptions(params: PinpointEmail.Types.PutConfigurationSetTrackingOptionsRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutConfigurationSetTrackingOptionsResponse) => void): Request<PinpointEmail.Types.PutConfigurationSetTrackingOptionsResponse, AWSError>;
  /**
   * Specify a custom domain to use for open and click tracking elements in email that you send using Amazon Pinpoint.
   */
  putConfigurationSetTrackingOptions(callback?: (err: AWSError, data: PinpointEmail.Types.PutConfigurationSetTrackingOptionsResponse) => void): Request<PinpointEmail.Types.PutConfigurationSetTrackingOptionsResponse, AWSError>;
  /**
   * Move a dedicated IP address to an existing dedicated IP pool.  The dedicated IP address that you specify must already exist, and must be associated with your Amazon Pinpoint account.  The dedicated IP pool you specify must already exist. You can create a new pool by using the CreateDedicatedIpPool operation. 
   */
  putDedicatedIpInPool(params: PinpointEmail.Types.PutDedicatedIpInPoolRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutDedicatedIpInPoolResponse) => void): Request<PinpointEmail.Types.PutDedicatedIpInPoolResponse, AWSError>;
  /**
   * Move a dedicated IP address to an existing dedicated IP pool.  The dedicated IP address that you specify must already exist, and must be associated with your Amazon Pinpoint account.  The dedicated IP pool you specify must already exist. You can create a new pool by using the CreateDedicatedIpPool operation. 
   */
  putDedicatedIpInPool(callback?: (err: AWSError, data: PinpointEmail.Types.PutDedicatedIpInPoolResponse) => void): Request<PinpointEmail.Types.PutDedicatedIpInPoolResponse, AWSError>;
  /**
   * 
   */
  putDedicatedIpWarmupAttributes(params: PinpointEmail.Types.PutDedicatedIpWarmupAttributesRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutDedicatedIpWarmupAttributesResponse) => void): Request<PinpointEmail.Types.PutDedicatedIpWarmupAttributesResponse, AWSError>;
  /**
   * 
   */
  putDedicatedIpWarmupAttributes(callback?: (err: AWSError, data: PinpointEmail.Types.PutDedicatedIpWarmupAttributesResponse) => void): Request<PinpointEmail.Types.PutDedicatedIpWarmupAttributesResponse, AWSError>;
  /**
   * Used to enable or disable DKIM authentication for an email identity.
   */
  putEmailIdentityDkimAttributes(params: PinpointEmail.Types.PutEmailIdentityDkimAttributesRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutEmailIdentityDkimAttributesResponse) => void): Request<PinpointEmail.Types.PutEmailIdentityDkimAttributesResponse, AWSError>;
  /**
   * Used to enable or disable DKIM authentication for an email identity.
   */
  putEmailIdentityDkimAttributes(callback?: (err: AWSError, data: PinpointEmail.Types.PutEmailIdentityDkimAttributesResponse) => void): Request<PinpointEmail.Types.PutEmailIdentityDkimAttributesResponse, AWSError>;
  /**
   * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event. When you enable feedback forwarding, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email. When you disable feedback forwarding, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
   */
  putEmailIdentityFeedbackAttributes(params: PinpointEmail.Types.PutEmailIdentityFeedbackAttributesRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutEmailIdentityFeedbackAttributesResponse) => void): Request<PinpointEmail.Types.PutEmailIdentityFeedbackAttributesResponse, AWSError>;
  /**
   * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event. When you enable feedback forwarding, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email. When you disable feedback forwarding, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
   */
  putEmailIdentityFeedbackAttributes(callback?: (err: AWSError, data: PinpointEmail.Types.PutEmailIdentityFeedbackAttributesResponse) => void): Request<PinpointEmail.Types.PutEmailIdentityFeedbackAttributesResponse, AWSError>;
  /**
   * Used to enable or disable the custom Mail-From domain configuration for an email identity.
   */
  putEmailIdentityMailFromAttributes(params: PinpointEmail.Types.PutEmailIdentityMailFromAttributesRequest, callback?: (err: AWSError, data: PinpointEmail.Types.PutEmailIdentityMailFromAttributesResponse) => void): Request<PinpointEmail.Types.PutEmailIdentityMailFromAttributesResponse, AWSError>;
  /**
   * Used to enable or disable the custom Mail-From domain configuration for an email identity.
   */
  putEmailIdentityMailFromAttributes(callback?: (err: AWSError, data: PinpointEmail.Types.PutEmailIdentityMailFromAttributesResponse) => void): Request<PinpointEmail.Types.PutEmailIdentityMailFromAttributesResponse, AWSError>;
  /**
   * Sends an email message. You can use the Amazon Pinpoint Email API to send two types of messages:    Simple – A standard email message. When you create this type of message, you specify the sender, the recipient, and the message body, and Amazon Pinpoint assembles the message for you.    Raw – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of the message headers, as well as the message body. You can use this message type to send messages that contain attachments. The message that you specify has to be a valid MIME message.  
   */
  sendEmail(params: PinpointEmail.Types.SendEmailRequest, callback?: (err: AWSError, data: PinpointEmail.Types.SendEmailResponse) => void): Request<PinpointEmail.Types.SendEmailResponse, AWSError>;
  /**
   * Sends an email message. You can use the Amazon Pinpoint Email API to send two types of messages:    Simple – A standard email message. When you create this type of message, you specify the sender, the recipient, and the message body, and Amazon Pinpoint assembles the message for you.    Raw – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of the message headers, as well as the message body. You can use this message type to send messages that contain attachments. The message that you specify has to be a valid MIME message.  
   */
  sendEmail(callback?: (err: AWSError, data: PinpointEmail.Types.SendEmailResponse) => void): Request<PinpointEmail.Types.SendEmailResponse, AWSError>;
  /**
   * Update the configuration of an event destination for a configuration set. In Amazon Pinpoint, events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
   */
  updateConfigurationSetEventDestination(params: PinpointEmail.Types.UpdateConfigurationSetEventDestinationRequest, callback?: (err: AWSError, data: PinpointEmail.Types.UpdateConfigurationSetEventDestinationResponse) => void): Request<PinpointEmail.Types.UpdateConfigurationSetEventDestinationResponse, AWSError>;
  /**
   * Update the configuration of an event destination for a configuration set. In Amazon Pinpoint, events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
   */
  updateConfigurationSetEventDestination(callback?: (err: AWSError, data: PinpointEmail.Types.UpdateConfigurationSetEventDestinationResponse) => void): Request<PinpointEmail.Types.UpdateConfigurationSetEventDestinationResponse, AWSError>;
}
declare namespace PinpointEmail {
  export type AmazonResourceName = string;
  export type BehaviorOnMxFailure = "USE_DEFAULT_VALUE"|"REJECT_MESSAGE"|string;
  export interface Body {
    /**
     * An object that represents the version of the message that is displayed in email clients that don't support HTML, or clients where the recipient has disabled HTML rendering.
     */
    Text?: Content;
    /**
     * An object that represents the version of the message that is displayed in email clients that support HTML. HTML messages can include formatted text, hyperlinks, images, and more. 
     */
    Html?: Content;
  }
  export type Charset = string;
  export interface CloudWatchDestination {
    /**
     * An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
     */
    DimensionConfigurations: CloudWatchDimensionConfigurations;
  }
  export interface CloudWatchDimensionConfiguration {
    /**
     * The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to meet the following criteria:   It can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).   It can contain no more than 256 characters.  
     */
    DimensionName: DimensionName;
    /**
     * The location where Amazon Pinpoint finds the value of a dimension to publish to Amazon CloudWatch. If you want Amazon Pinpoint to use the message tags that you specify using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail/SendRawEmail API, choose messageTag. If you want Amazon Pinpoint to use your own email headers, choose emailHeader. If you want Amazon Pinpoint to use link tags, choose linkTags.
     */
    DimensionValueSource: DimensionValueSource;
    /**
     * The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of the dimension when you send an email. This value has to meet the following criteria:   It can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).   It can contain no more than 256 characters.  
     */
    DefaultDimensionValue: DefaultDimensionValue;
  }
  export type CloudWatchDimensionConfigurations = CloudWatchDimensionConfiguration[];
  export type ConfigurationSetName = string;
  export type ConfigurationSetNameList = ConfigurationSetName[];
  export interface Content {
    /**
     * The content of the message itself.
     */
    Data: MessageData;
    /**
     * The character set for the content. Because of the constraints of the SMTP protocol, Amazon Pinpoint uses 7-bit ASCII by default. If the text includes characters outside of the ASCII range, you have to specify a character set. For example, you could specify UTF-8, ISO-8859-1, or Shift_JIS.
     */
    Charset?: Charset;
  }
  export interface CreateConfigurationSetEventDestinationRequest {
    /**
     * The name of the configuration set that you want to add an event destination to.
     */
    ConfigurationSetName: ConfigurationSetName;
    /**
     * A name that identifies the event destination within the configuration set.
     */
    EventDestinationName: EventDestinationName;
    /**
     * An object that defines the event destination.
     */
    EventDestination: EventDestinationDefinition;
  }
  export interface CreateConfigurationSetEventDestinationResponse {
  }
  export interface CreateConfigurationSetRequest {
    /**
     * The name of the configuration set.
     */
    ConfigurationSetName?: ConfigurationSetName;
    /**
     * An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    TrackingOptions?: TrackingOptions;
    /**
     * An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
     */
    DeliveryOptions?: DeliveryOptions;
    /**
     * An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.
     */
    ReputationOptions?: ReputationOptions;
    /**
     * An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.
     */
    SendingOptions?: SendingOptions;
  }
  export interface CreateConfigurationSetResponse {
  }
  export interface CreateDedicatedIpPoolRequest {
    /**
     * The name of the dedicated IP pool.
     */
    PoolName: PoolName;
  }
  export interface CreateDedicatedIpPoolResponse {
  }
  export interface CreateEmailIdentityRequest {
    /**
     * The email address or domain that you want to verify.
     */
    EmailIdentity: Identity;
  }
  export interface CreateEmailIdentityResponse {
    /**
     * The email identity type.
     */
    IdentityType?: IdentityType;
    /**
     * Specifies whether or not the identity is verified. In Amazon Pinpoint, you can only send email from verified email addresses or domains. For more information about verifying identities, see the Amazon Pinpoint User Guide.
     */
    VerifiedForSendingStatus?: Enabled;
    /**
     * An object that contains information about the DKIM attributes for the identity. This object includes the tokens that you use to create the CNAME records that are required to complete the DKIM verification process.
     */
    DkimAttributes?: DkimAttributes;
  }
  export type CustomRedirectDomain = string;
  export interface DedicatedIp {
    /**
     * An IP address that is reserved for use by your Amazon Pinpoint account.
     */
    Ip: Ip;
    /**
     * The warm-up status of a dedicated IP address. The status can have one of the following values:    IN_PROGRESS – The IP address isn't ready to use because the dedicated IP warm-up process is ongoing.    DONE – The dedicated IP warm-up process is complete, and the IP address is ready to use.  
     */
    WarmupStatus: WarmupStatus;
    /**
     * Indicates how complete the dedicated IP warm-up process is. When this value equals 1, the address has completed the warm-up process and is ready for use.
     */
    WarmupPercentage: Percentage100Wrapper;
    /**
     * The name of the dedicated IP pool that the IP address is associated with.
     */
    PoolName?: PoolName;
  }
  export type DedicatedIpList = DedicatedIp[];
  export type DefaultDimensionValue = string;
  export interface DeleteConfigurationSetEventDestinationRequest {
    /**
     * The name of the configuration set that contains the event destination that you want to delete.
     */
    ConfigurationSetName: ConfigurationSetName;
    /**
     * The name of the event destination that you want to delete.
     */
    EventDestinationName: EventDestinationName;
  }
  export interface DeleteConfigurationSetEventDestinationResponse {
  }
  export interface DeleteConfigurationSetRequest {
    /**
     * The name of the configuration set that you want to delete.
     */
    ConfigurationSetName: ConfigurationSetName;
  }
  export interface DeleteConfigurationSetResponse {
  }
  export interface DeleteDedicatedIpPoolRequest {
    /**
     * The name of the dedicated IP pool that you want to delete.
     */
    PoolName: PoolName;
  }
  export interface DeleteDedicatedIpPoolResponse {
  }
  export interface DeleteEmailIdentityRequest {
    /**
     * The identity (that is, the email address or domain) that you want to delete from your Amazon Pinpoint account.
     */
    EmailIdentity: Identity;
  }
  export interface DeleteEmailIdentityResponse {
  }
  export interface DeliveryOptions {
    /**
     * The name of the dedicated IP pool that you want to associate with the configuration set.
     */
    SendingPoolName?: PoolName;
  }
  export interface Destination {
    /**
     * An array that contains the email addresses of the "To" recipients for the email.
     */
    ToAddresses?: EmailAddressList;
    /**
     * An array that contains the email addresses of the "CC" (carbon copy) recipients for the email.
     */
    CcAddresses?: EmailAddressList;
    /**
     * An array that contains the email addresses of the "BCC" (blind carbon copy) recipients for the email.
     */
    BccAddresses?: EmailAddressList;
  }
  export type DimensionName = string;
  export type DimensionValueSource = "MESSAGE_TAG"|"EMAIL_HEADER"|"LINK_TAG"|string;
  export interface DkimAttributes {
    /**
     * If the value is true, then the messages that Amazon Pinpoint sends from the identity are DKIM-signed. If the value is false, then the messages that Amazon Pinpoint sends from the identity aren't DKIM-signed.
     */
    SigningEnabled?: Enabled;
    /**
     * Describes whether or not Amazon Pinpoint has successfully located the DKIM records in the DNS records for the domain. The status can be one of the following:    PENDING – Amazon Pinpoint hasn't yet located the DKIM records in the DNS configuration for the domain, but will continue to attempt to locate them.    SUCCESS – Amazon Pinpoint located the DKIM records in the DNS configuration for the domain and determined that they're correct. Amazon Pinpoint can now send DKIM-signed email from the identity.    FAILED – Amazon Pinpoint was unable to locate the DKIM records in the DNS settings for the domain, and won't continue to search for them.    TEMPORARY_FAILURE – A temporary issue occurred, which prevented Amazon Pinpoint from determining the DKIM status for the domain.    NOT_STARTED – Amazon Pinpoint hasn't yet started searching for the DKIM records in the DKIM records for the domain.  
     */
    Status?: DkimStatus;
    /**
     * A set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon Pinpoint detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. Amazon Pinpoint usually detects these records within about 72 hours of adding them to the DNS configuration for your domain.
     */
    Tokens?: DnsTokenList;
  }
  export type DkimStatus = "PENDING"|"SUCCESS"|"FAILED"|"TEMPORARY_FAILURE"|"NOT_STARTED"|string;
  export type DnsToken = string;
  export type DnsTokenList = DnsToken[];
  export type EmailAddress = string;
  export type EmailAddressList = EmailAddress[];
  export interface EmailContent {
    /**
     * The simple email message. The message consists of a subject and a message body.
     */
    Simple?: Message;
    /**
     * The raw email message. The message has to meet the following criteria:   The message has to contain a header and a body, separated by one blank line.   All of the required header fields must be present in the message.   Each part of a multipart MIME message must be formatted properly.   If you include attachments, they must be in a file format that Amazon Pinpoint supports.    The entire message must be Base64 encoded.   If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you should encode that content to ensure that recipients' email clients render the message properly.   The length of any single line of text in the message can't exceed 1,000 characters. This restriction is defined in RFC 5321.  
     */
    Raw?: RawMessage;
  }
  export type Enabled = boolean;
  export interface EventDestination {
    /**
     * A name that identifies the event destination.
     */
    Name: EventDestinationName;
    /**
     * If true, the event destination is enabled. When the event destination is enabled, the specified event types are sent to the destinations in this EventDestinationDefinition. If false, the event destination is disabled. When the event destination is disabled, events aren't sent to the specified destinations.
     */
    Enabled?: Enabled;
    /**
     * The types of events that Amazon Pinpoint sends to the specified event destinations.
     */
    MatchingEventTypes: EventTypes;
    /**
     * An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
     */
    KinesisFirehoseDestination?: KinesisFirehoseDestination;
    /**
     * An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.
     */
    CloudWatchDestination?: CloudWatchDestination;
    /**
     * An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send notification when certain email events occur.
     */
    SnsDestination?: SnsDestination;
    /**
     * An object that defines a Amazon Pinpoint destination for email events. You can use Amazon Pinpoint events to create attributes in Amazon Pinpoint projects. You can use these attributes to create segments for your campaigns.
     */
    PinpointDestination?: PinpointDestination;
  }
  export interface EventDestinationDefinition {
    /**
     * If true, the event destination is enabled. When the event destination is enabled, the specified event types are sent to the destinations in this EventDestinationDefinition. If false, the event destination is disabled. When the event destination is disabled, events aren't sent to the specified destinations.
     */
    Enabled?: Enabled;
    /**
     * An array that specifies which events Amazon Pinpoint should send to the destinations in this EventDestinationDefinition.
     */
    MatchingEventTypes?: EventTypes;
    /**
     * An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
     */
    KinesisFirehoseDestination?: KinesisFirehoseDestination;
    /**
     * An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.
     */
    CloudWatchDestination?: CloudWatchDestination;
    /**
     * An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send notification when certain email events occur.
     */
    SnsDestination?: SnsDestination;
    /**
     * An object that defines a Amazon Pinpoint destination for email events. You can use Amazon Pinpoint events to create attributes in Amazon Pinpoint projects. You can use these attributes to create segments for your campaigns.
     */
    PinpointDestination?: PinpointDestination;
  }
  export type EventDestinationName = string;
  export type EventDestinations = EventDestination[];
  export type EventType = "SEND"|"REJECT"|"BOUNCE"|"COMPLAINT"|"DELIVERY"|"OPEN"|"CLICK"|"RENDERING_FAILURE"|string;
  export type EventTypes = EventType[];
  export type GeneralEnforcementStatus = string;
  export interface GetAccountRequest {
  }
  export interface GetAccountResponse {
    /**
     * An object that contains information about the per-day and per-second sending limits for your Amazon Pinpoint account in the current AWS Region.
     */
    SendQuota?: SendQuota;
    /**
     * Indicates whether or not email sending is enabled for your Amazon Pinpoint account in the current AWS Region.
     */
    SendingEnabled?: Enabled;
    /**
     * Indicates whether or not the automatic warm-up feature is enabled for dedicated IP addresses that are associated with your account.
     */
    DedicatedIpAutoWarmupEnabled?: Enabled;
    /**
     * The reputation status of your Amazon Pinpoint account. The status can be one of the following:    HEALTHY – There are no reputation-related issues that currently impact your account.    PROBATION – We've identified some issues with your Amazon Pinpoint account. We're placing your account under review while you work on correcting these issues.    SHUTDOWN – Your account's ability to send email is currently paused because of an issue with the email sent from your account. When you correct the issue, you can contact us and request that your account's ability to send email is resumed.  
     */
    EnforcementStatus?: GeneralEnforcementStatus;
    /**
     * Indicates whether or not your account has production access in the current AWS Region. If the value is false, then your account is in the sandbox. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1. If the value is true, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.
     */
    ProductionAccessEnabled?: Enabled;
  }
  export interface GetConfigurationSetEventDestinationsRequest {
    /**
     * The name of the configuration set that contains the event destination.
     */
    ConfigurationSetName: ConfigurationSetName;
  }
  export interface GetConfigurationSetEventDestinationsResponse {
    /**
     * An array that includes all of the events destinations that have been configured for the configuration set.
     */
    EventDestinations?: EventDestinations;
  }
  export interface GetConfigurationSetRequest {
    /**
     * The name of the configuration set that you want to obtain more information about.
     */
    ConfigurationSetName: ConfigurationSetName;
  }
  export interface GetConfigurationSetResponse {
    /**
     * The name of the configuration set.
     */
    ConfigurationSetName?: ConfigurationSetName;
    /**
     * An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    TrackingOptions?: TrackingOptions;
    /**
     * An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
     */
    DeliveryOptions?: DeliveryOptions;
    /**
     * An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.
     */
    ReputationOptions?: ReputationOptions;
    /**
     * An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.
     */
    SendingOptions?: SendingOptions;
  }
  export interface GetDedicatedIpRequest {
    /**
     * The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Pinpoint account.
     */
    Ip: Ip;
  }
  export interface GetDedicatedIpResponse {
    /**
     * An object that contains information about a dedicated IP address.
     */
    DedicatedIp?: DedicatedIp;
  }
  export interface GetDedicatedIpsRequest {
    /**
     * The name of the IP pool that the dedicated IP address is associated with.
     */
    PoolName?: PoolName;
    /**
     * A token returned from a previous call to GetDedicatedIps to indicate the position of the dedicated IP pool in the list of IP pools.
     */
    NextToken?: NextToken;
    /**
     * The number of results to show in a single call to GetDedicatedIpsRequest. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results.
     */
    PageSize?: MaxItems;
  }
  export interface GetDedicatedIpsResponse {
    /**
     * A list of dedicated IP addresses that are reserved for use by your Amazon Pinpoint account.
     */
    DedicatedIps?: DedicatedIpList;
    /**
     * A token that indicates that there are additional dedicated IP addresses to list. To view additional addresses, issue another request to GetDedicatedIps, passing this token in the NextToken parameter.
     */
    NextToken?: NextToken;
  }
  export interface GetEmailIdentityRequest {
    /**
     * The email identity that you want to retrieve details for.
     */
    EmailIdentity: Identity;
  }
  export interface GetEmailIdentityResponse {
    /**
     * The email identity type.
     */
    IdentityType?: IdentityType;
    /**
     * The feedback forwarding configuration for the identity. If the value is true, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email. When you set this value to false, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic or another event destination. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
     */
    FeedbackForwardingStatus?: Enabled;
    /**
     * Specifies whether or not the identity is verified. In Amazon Pinpoint, you can only send email from verified email addresses or domains. For more information about verifying identities, see the Amazon Pinpoint User Guide.
     */
    VerifiedForSendingStatus?: Enabled;
    /**
     * An object that contains information about the DKIM attributes for the identity. This object includes the tokens that you use to create the CNAME records that are required to complete the DKIM verification process.
     */
    DkimAttributes?: DkimAttributes;
    /**
     * An object that contains information about the Mail-From attributes for the email identity.
     */
    MailFromAttributes?: MailFromAttributes;
  }
  export type Identity = string;
  export interface IdentityInfo {
    /**
     * The email identity type. The identity type can be one of the following:    EMAIL_ADDRESS – The identity is an email address.    DOMAIN – The identity is a domain.    MANAGED_DOMAIN – The identity is a domain that is managed by AWS.  
     */
    IdentityType?: IdentityType;
    /**
     * The address or domain of the identity.
     */
    IdentityName?: Identity;
    /**
     * Indicates whether or not you can send email from the identity. In Amazon Pinpoint, an identity is an email address or domain that you send email from. Before you can send email from an identity, you have to demostrate that you own the identity, and that you authorize Amazon Pinpoint to send email from that identity.
     */
    SendingEnabled?: Enabled;
  }
  export type IdentityInfoList = IdentityInfo[];
  export type IdentityType = "EMAIL_ADDRESS"|"DOMAIN"|"MANAGED_DOMAIN"|string;
  export type Ip = string;
  export interface KinesisFirehoseDestination {
    /**
     * The Amazon Resource Name (ARN) of the IAM role that Amazon Pinpoint uses when sending email events to the Amazon Kinesis Data Firehose stream.
     */
    IamRoleArn: AmazonResourceName;
    /**
     * The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that Amazon Pinpoint sends email events to.
     */
    DeliveryStreamArn: AmazonResourceName;
  }
  export type LastFreshStart = Date;
  export interface ListConfigurationSetsRequest {
    /**
     * A token returned from a previous call to ListConfigurationSets to indicate the position in the list of configuration sets.
     */
    NextToken?: NextToken;
    /**
     * The number of results to show in a single call to ListConfigurationSets. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results.
     */
    PageSize?: MaxItems;
  }
  export interface ListConfigurationSetsResponse {
    /**
     * An array that contains all of the configuration sets in your Amazon Pinpoint account in the current AWS Region.
     */
    ConfigurationSets?: ConfigurationSetNameList;
    /**
     * A token that indicates that there are additional configuration sets to list. To view additional configuration sets, issue another request to ListConfigurationSets, and pass this token in the NextToken parameter.
     */
    NextToken?: NextToken;
  }
  export interface ListDedicatedIpPoolsRequest {
    /**
     * A token returned from a previous call to ListDedicatedIpPools to indicate the position in the list of dedicated IP pools.
     */
    NextToken?: NextToken;
    /**
     * The number of results to show in a single call to ListDedicatedIpPools. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results.
     */
    PageSize?: MaxItems;
  }
  export interface ListDedicatedIpPoolsResponse {
    /**
     * A list of all of the dedicated IP pools that are associated with your Amazon Pinpoint account.
     */
    DedicatedIpPools?: ListOfDedicatedIpPools;
    /**
     * A token that indicates that there are additional IP pools to list. To view additional IP pools, issue another request to ListDedicatedIpPools, passing this token in the NextToken parameter.
     */
    NextToken?: NextToken;
  }
  export interface ListEmailIdentitiesRequest {
    /**
     * A token returned from a previous call to ListEmailIdentities to indicate the position in the list of identities.
     */
    NextToken?: NextToken;
    /**
     * The number of results to show in a single call to ListEmailIdentities. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results. The value you specify has to be at least 0, and can be no more than 1000.
     */
    PageSize?: MaxItems;
  }
  export interface ListEmailIdentitiesResponse {
    /**
     * An array that includes all of the identities associated with your Amazon Pinpoint account.
     */
    EmailIdentities?: IdentityInfoList;
    /**
     * A token that indicates that there are additional configuration sets to list. To view additional configuration sets, issue another request to ListEmailIdentities, and pass this token in the NextToken parameter.
     */
    NextToken?: NextToken;
  }
  export type ListOfDedicatedIpPools = PoolName[];
  export interface MailFromAttributes {
    /**
     * The name of a domain that an email identity uses as a custom MAIL FROM domain.
     */
    MailFromDomain: MailFromDomainName;
    /**
     * The status of the MAIL FROM domain. This status can have the following values:    PENDING – Amazon Pinpoint hasn't started searching for the MX record yet.    SUCCESS – Amazon Pinpoint detected the required MX record for the MAIL FROM domain.    FAILED – Amazon Pinpoint can't find the required MX record, or the record no longer exists.    TEMPORARY_FAILURE – A temporary issue occurred, which prevented Amazon Pinpoint from determining the status of the MAIL FROM domain.  
     */
    MailFromDomainStatus: MailFromDomainStatus;
    /**
     * The action that Amazon Pinpoint to takes if it can't read the required MX record for a custom MAIL FROM domain. When you set this value to UseDefaultValue, Amazon Pinpoint uses amazonses.com as the MAIL FROM domain. When you set this value to RejectMessage, Amazon Pinpoint returns a MailFromDomainNotVerified error, and doesn't attempt to deliver the email. These behaviors are taken when the custom MAIL FROM domain configuration is in the Pending, Failed, and TemporaryFailure states.
     */
    BehaviorOnMxFailure: BehaviorOnMxFailure;
  }
  export type MailFromDomainName = string;
  export type MailFromDomainStatus = "PENDING"|"SUCCESS"|"FAILED"|"TEMPORARY_FAILURE"|string;
  export type Max24HourSend = number;
  export type MaxItems = number;
  export type MaxSendRate = number;
  export interface Message {
    /**
     * The subject line of the email. The subject line can only contain 7-bit ASCII characters. However, you can specify non-ASCII characters in the subject line by using encoded-word syntax, as described in RFC 2047.
     */
    Subject: Content;
    /**
     * The body of the message. You can specify an HTML version of the message, a text-only version of the message, or both.
     */
    Body: Body;
  }
  export type MessageData = string;
  export interface MessageTag {
    /**
     * The name of the message tag. The message tag name has to meet the following criteria:   It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).   It can contain no more than 256 characters.  
     */
    Name: MessageTagName;
    /**
     * The value of the message tag. The message tag value has to meet the following criteria:   It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).   It can contain no more than 256 characters.  
     */
    Value: MessageTagValue;
  }
  export type MessageTagList = MessageTag[];
  export type MessageTagName = string;
  export type MessageTagValue = string;
  export type NextToken = string;
  export type OutboundMessageId = string;
  export type Percentage100Wrapper = number;
  export interface PinpointDestination {
    /**
     * The Amazon Resource Name (ARN) of the Amazon Pinpoint project that you want to send email events to.
     */
    ApplicationArn?: AmazonResourceName;
  }
  export type PoolName = string;
  export interface PutAccountDedicatedIpWarmupAttributesRequest {
    /**
     * Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon Pinpoint account in the current AWS Region. Set to true to enable the automatic warm-up feature, or set to false to disable it.
     */
    AutoWarmupEnabled?: Enabled;
  }
  export interface PutAccountDedicatedIpWarmupAttributesResponse {
  }
  export interface PutAccountSendingAttributesRequest {
    /**
     * Enables or disables your account's ability to send email. Set to true to enable email sending, or set to false to disable email sending.  If AWS paused your account's ability to send email, you can't use this operation to resume your account's ability to send email. 
     */
    SendingEnabled?: Enabled;
  }
  export interface PutAccountSendingAttributesResponse {
  }
  export interface PutConfigurationSetDeliveryOptionsRequest {
    /**
     * The name of the configuration set that you want to associate with a dedicated IP pool.
     */
    ConfigurationSetName: ConfigurationSetName;
    /**
     * The name of the dedicated IP pool that you want to associate with the configuration set.
     */
    SendingPoolName?: SendingPoolName;
  }
  export interface PutConfigurationSetDeliveryOptionsResponse {
  }
  export interface PutConfigurationSetReputationOptionsRequest {
    /**
     * The name of the configuration set that you want to enable or disable reputation metric tracking for.
     */
    ConfigurationSetName: ConfigurationSetName;
    /**
     * If true, tracking of reputation metrics is enabled for the configuration set. If false, tracking of reputation metrics is disabled for the configuration set.
     */
    ReputationMetricsEnabled?: Enabled;
  }
  export interface PutConfigurationSetReputationOptionsResponse {
  }
  export interface PutConfigurationSetSendingOptionsRequest {
    /**
     * The name of the configuration set that you want to enable or disable email sending for.
     */
    ConfigurationSetName: ConfigurationSetName;
    /**
     * If true, email sending is enabled for the configuration set. If false, email sending is disabled for the configuration set.
     */
    SendingEnabled?: Enabled;
  }
  export interface PutConfigurationSetSendingOptionsResponse {
  }
  export interface PutConfigurationSetTrackingOptionsRequest {
    /**
     * The name of the configuration set that you want to add a custom tracking domain to.
     */
    ConfigurationSetName: ConfigurationSetName;
    /**
     * The domain that you want to use to track open and click events.
     */
    CustomRedirectDomain?: CustomRedirectDomain;
  }
  export interface PutConfigurationSetTrackingOptionsResponse {
  }
  export interface PutDedicatedIpInPoolRequest {
    /**
     * The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Pinpoint account.
     */
    Ip: Ip;
    /**
     * The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.
     */
    DestinationPoolName: PoolName;
  }
  export interface PutDedicatedIpInPoolResponse {
  }
  export interface PutDedicatedIpWarmupAttributesRequest {
    /**
     * The dedicated IP address that you want to update the warm-up attributes for.
     */
    Ip: Ip;
    /**
     * The warm-up percentage that you want to associate with the dedicated IP address.
     */
    WarmupPercentage: Percentage100Wrapper;
  }
  export interface PutDedicatedIpWarmupAttributesResponse {
  }
  export interface PutEmailIdentityDkimAttributesRequest {
    /**
     * The email identity that you want to change the DKIM settings for.
     */
    EmailIdentity: Identity;
    /**
     * Sets the DKIM signing configuration for the identity. When you set this value true, then the messages that Amazon Pinpoint sends from the identity are DKIM-signed. When you set this value to false, then the messages that Amazon Pinpoint sends from the identity aren't DKIM-signed.
     */
    SigningEnabled?: Enabled;
  }
  export interface PutEmailIdentityDkimAttributesResponse {
  }
  export interface PutEmailIdentityFeedbackAttributesRequest {
    /**
     * The email identity that you want to configure bounce and complaint feedback forwarding for.
     */
    EmailIdentity: Identity;
    /**
     * Sets the feedback forwarding configuration for the identity. If the value is true, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email. When you set this value to false, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic or another event destination. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
     */
    EmailForwardingEnabled?: Enabled;
  }
  export interface PutEmailIdentityFeedbackAttributesResponse {
  }
  export interface PutEmailIdentityMailFromAttributesRequest {
    /**
     * The verified email identity that you want to set up the custom MAIL FROM domain for.
     */
    EmailIdentity: Identity;
    /**
     *  The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:   It has to be a subdomain of the verified identity.   It can't be used to receive email.   It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.  
     */
    MailFromDomain?: MailFromDomainName;
    /**
     * The action that you want Amazon Pinpoint to take if it can't read the required MX record when you send an email. When you set this value to UseDefaultValue, Amazon Pinpoint uses amazonses.com as the MAIL FROM domain. When you set this value to RejectMessage, Amazon Pinpoint returns a MailFromDomainNotVerified error, and doesn't attempt to deliver the email. These behaviors are taken when the custom MAIL FROM domain configuration is in the Pending, Failed, and TemporaryFailure states.
     */
    BehaviorOnMxFailure?: BehaviorOnMxFailure;
  }
  export interface PutEmailIdentityMailFromAttributesResponse {
  }
  export interface RawMessage {
    /**
     * The raw email message. The message has to meet the following criteria:   The message has to contain a header and a body, separated by one blank line.   All of the required header fields must be present in the message.   Each part of a multipart MIME message must be formatted properly.   Attachments must be in a file format that Amazon Pinpoint supports.    The entire message must be Base64 encoded.   If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you should encode that content to ensure that recipients' email clients render the message properly.   The length of any single line of text in the message can't exceed 1,000 characters. This restriction is defined in RFC 5321.  
     */
    Data: RawMessageData;
  }
  export type RawMessageData = Buffer|Uint8Array|Blob|string;
  export interface ReputationOptions {
    /**
     * If true, tracking of reputation metrics is enabled for the configuration set. If false, tracking of reputation metrics is disabled for the configuration set.
     */
    ReputationMetricsEnabled?: Enabled;
    /**
     * The date and time when the reputation metrics were last given a fresh start. When your account is given a fresh start, your reputation metrics are calculated starting from the date of the fresh start.
     */
    LastFreshStart?: LastFreshStart;
  }
  export interface SendEmailRequest {
    /**
     * The email address that you want to use as the "From" address for the email. The address that you specify has to be verified. 
     */
    FromEmailAddress?: EmailAddress;
    /**
     * An object that contains the recipients of the email message.
     */
    Destination: Destination;
    /**
     * The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.
     */
    ReplyToAddresses?: EmailAddressList;
    /**
     * The address that Amazon Pinpoint should send bounce and complaint notifications to.
     */
    FeedbackForwardingEmailAddress?: EmailAddress;
    /**
     * An object that contains the body of the message. You can send either a Simple message or a Raw message.
     */
    Content: EmailContent;
    /**
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using the SendEmail operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. 
     */
    EmailTags?: MessageTagList;
    /**
     * The name of the configuration set that you want to use when sending the email.
     */
    ConfigurationSetName?: ConfigurationSetName;
  }
  export interface SendEmailResponse {
    /**
     * A unique identifier for the message that is generated when Amazon Pinpoint accepts the message.  It is possible for Amazon Pinpoint to accept a message without sending it. This can happen when the message you're trying to send has an attachment doesn't pass a virus check, or when you send a templated email that contains invalid personalization content, for example. 
     */
    MessageId?: OutboundMessageId;
  }
  export interface SendQuota {
    /**
     * The maximum number of emails that you can send in the current AWS Region over a 24-hour period. This value is also called your sending quota.
     */
    Max24HourSend?: Max24HourSend;
    /**
     * The maximum number of emails that you can send per second in the current AWS Region. This value is also called your maximum sending rate or your maximum TPS (transactions per second) rate.
     */
    MaxSendRate?: MaxSendRate;
    /**
     * The number of emails sent from your Amazon Pinpoint account in the current AWS Region over the past 24 hours.
     */
    SentLast24Hours?: SentLast24Hours;
  }
  export interface SendingOptions {
    /**
     * If true, email sending is enabled for the configuration set. If false, email sending is disabled for the configuration set.
     */
    SendingEnabled?: Enabled;
  }
  export type SendingPoolName = string;
  export type SentLast24Hours = number;
  export interface SnsDestination {
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish email events to. For more information about Amazon SNS topics, see the Amazon SNS Developer Guide.
     */
    TopicArn: AmazonResourceName;
  }
  export interface TrackingOptions {
    /**
     * The domain that you want to use for tracking open and click events.
     */
    CustomRedirectDomain: CustomRedirectDomain;
  }
  export interface UpdateConfigurationSetEventDestinationRequest {
    /**
     * The name of the configuration set that contains the event destination that you want to modify.
     */
    ConfigurationSetName: ConfigurationSetName;
    /**
     * The name of the event destination that you want to modify.
     */
    EventDestinationName: EventDestinationName;
    /**
     * An object that defines the event destination.
     */
    EventDestination: EventDestinationDefinition;
  }
  export interface UpdateConfigurationSetEventDestinationResponse {
  }
  export type WarmupStatus = "IN_PROGRESS"|"DONE"|string;
  /**
   * A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service. Specify 'latest' to use the latest possible version.
   */
  export type apiVersion = "2018-07-26"|"latest"|string;
  export interface ClientApiVersions {
    /**
     * A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service. Specify 'latest' to use the latest possible version.
     */
    apiVersion?: apiVersion;
  }
  export type ClientConfiguration = ServiceConfigurationOptions & ClientApiVersions;
  /**
   * Contains interfaces for use with the PinpointEmail client.
   */
  export import Types = PinpointEmail;
}
export = PinpointEmail;
