"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.blobReader = void 0;
function blobReader(blob, onChunk, chunkSize = 1024 * 1024) {
    return new Promise((resolve, reject) => {
        const fileReader = new FileReader();
        fileReader.addEventListener("error", reject);
        fileReader.addEventListener("abort", reject);
        const size = blob.size;
        let totalBytesRead = 0;
        function read() {
            if (totalBytesRead >= size) {
                resolve();
                return;
            }
            fileReader.readAsArrayBuffer(blob.slice(totalBytesRead, Math.min(size, totalBytesRead + chunkSize)));
        }
        fileReader.addEventListener("load", (event) => {
            const result = event.target.result;
            onChunk(new Uint8Array(result));
            totalBytesRead += result.byteLength;
            // read the next block
            read();
        });
        // kick off the read
        read();
    });
}
exports.blobReader = blobReader;
//# sourceMappingURL=data:application/json;base64,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