export function blobReader(blob, onChunk, chunkSize) {
    if (chunkSize === void 0) { chunkSize = 1024 * 1024; }
    return new Promise(function (resolve, reject) {
        var fileReader = new FileReader();
        fileReader.addEventListener("error", reject);
        fileReader.addEventListener("abort", reject);
        var size = blob.size;
        var totalBytesRead = 0;
        function read() {
            if (totalBytesRead >= size) {
                resolve();
                return;
            }
            fileReader.readAsArrayBuffer(blob.slice(totalBytesRead, Math.min(size, totalBytesRead + chunkSize)));
        }
        fileReader.addEventListener("load", function (event) {
            var result = event.target.result;
            onChunk(new Uint8Array(result));
            totalBytesRead += result.byteLength;
            // read the next block
            read();
        });
        // kick off the read
        read();
    });
}
//# sourceMappingURL=data:application/json;base64,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