import { __extends } from "tslib";
import { CreateIdentityPoolInput, IdentityPool } from "../models/models_0";
import { deserializeAws_json1_1CreateIdentityPoolCommand, serializeAws_json1_1CreateIdentityPoolCommand, } from "../protocols/Aws_json1_1";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { getAwsAuthPlugin } from "@aws-sdk/middleware-signing";
import { Command as $Command } from "@aws-sdk/smithy-client";
/**
 * <p>Creates a new identity pool. The identity pool is a store of user identity
 *          information that is specific to your AWS account. The keys for <code>SupportedLoginProviders</code> are as follows:</p>
 *
 *          <ul>
 *             <li>
 *                <p>Facebook: <code>graph.facebook.com</code>
 *                </p>
 *             </li>
 *             <li>
 *                <p>Google: <code>accounts.google.com</code>
 *                </p>
 *             </li>
 *             <li>
 *                <p>Amazon: <code>www.amazon.com</code>
 *                </p>
 *             </li>
 *             <li>
 *                <p>Twitter: <code>api.twitter.com</code>
 *                </p>
 *             </li>
 *             <li>
 *                <p>Digits: <code>www.digits.com</code>
 *                </p>
 *             </li>
 *          </ul>
 *
 *          <p>You must use AWS Developer credentials to call this API.</p>
 */
var CreateIdentityPoolCommand = /** @class */ (function (_super) {
    __extends(CreateIdentityPoolCommand, _super);
    // Start section: command_properties
    // End section: command_properties
    function CreateIdentityPoolCommand(input) {
        var _this = 
        // Start section: command_constructor
        _super.call(this) || this;
        _this.input = input;
        return _this;
        // End section: command_constructor
    }
    /**
     * @internal
     */
    CreateIdentityPoolCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getAwsAuthPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "CognitoIdentityClient";
        var commandName = "CreateIdentityPoolCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateIdentityPoolInput.filterSensitiveLog,
            outputFilterSensitiveLog: IdentityPool.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateIdentityPoolCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1CreateIdentityPoolCommand(input, context);
    };
    CreateIdentityPoolCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1CreateIdentityPoolCommand(output, context);
    };
    return CreateIdentityPoolCommand;
}($Command));
export { CreateIdentityPoolCommand };
//# sourceMappingURL=CreateIdentityPoolCommand.js.map