import { __extends } from "tslib";
import { GetIdentityPoolRolesInput, GetIdentityPoolRolesResponse } from "../models/models_0";
import { deserializeAws_json1_1GetIdentityPoolRolesCommand, serializeAws_json1_1GetIdentityPoolRolesCommand, } from "../protocols/Aws_json1_1";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { getAwsAuthPlugin } from "@aws-sdk/middleware-signing";
import { Command as $Command } from "@aws-sdk/smithy-client";
/**
 * <p>Gets the roles for an identity pool.</p>
 *          <p>You must use AWS Developer credentials to call this API.</p>
 */
var GetIdentityPoolRolesCommand = /** @class */ (function (_super) {
    __extends(GetIdentityPoolRolesCommand, _super);
    // Start section: command_properties
    // End section: command_properties
    function GetIdentityPoolRolesCommand(input) {
        var _this = 
        // Start section: command_constructor
        _super.call(this) || this;
        _this.input = input;
        return _this;
        // End section: command_constructor
    }
    /**
     * @internal
     */
    GetIdentityPoolRolesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getAwsAuthPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "CognitoIdentityClient";
        var commandName = "GetIdentityPoolRolesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetIdentityPoolRolesInput.filterSensitiveLog,
            outputFilterSensitiveLog: GetIdentityPoolRolesResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetIdentityPoolRolesCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1GetIdentityPoolRolesCommand(input, context);
    };
    GetIdentityPoolRolesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1GetIdentityPoolRolesCommand(output, context);
    };
    return GetIdentityPoolRolesCommand;
}($Command));
export { GetIdentityPoolRolesCommand };
//# sourceMappingURL=GetIdentityPoolRolesCommand.js.map