import { __extends } from "tslib";
import { ListIdentitiesInput, ListIdentitiesResponse } from "../models/models_0";
import { deserializeAws_json1_1ListIdentitiesCommand, serializeAws_json1_1ListIdentitiesCommand, } from "../protocols/Aws_json1_1";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { getAwsAuthPlugin } from "@aws-sdk/middleware-signing";
import { Command as $Command } from "@aws-sdk/smithy-client";
/**
 * <p>Lists the identities in an identity pool.</p>
 *          <p>You must use AWS Developer credentials to call this API.</p>
 */
var ListIdentitiesCommand = /** @class */ (function (_super) {
    __extends(ListIdentitiesCommand, _super);
    // Start section: command_properties
    // End section: command_properties
    function ListIdentitiesCommand(input) {
        var _this = 
        // Start section: command_constructor
        _super.call(this) || this;
        _this.input = input;
        return _this;
        // End section: command_constructor
    }
    /**
     * @internal
     */
    ListIdentitiesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getAwsAuthPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "CognitoIdentityClient";
        var commandName = "ListIdentitiesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListIdentitiesInput.filterSensitiveLog,
            outputFilterSensitiveLog: ListIdentitiesResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListIdentitiesCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1ListIdentitiesCommand(input, context);
    };
    ListIdentitiesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1ListIdentitiesCommand(output, context);
    };
    return ListIdentitiesCommand;
}($Command));
export { ListIdentitiesCommand };
//# sourceMappingURL=ListIdentitiesCommand.js.map