import { CognitoIdentityClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CognitoIdentityClient";
import { GetOpenIdTokenInput, GetOpenIdTokenResponse } from "../models/models_0";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, MiddlewareStack, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer } from "@aws-sdk/types";
export declare type GetOpenIdTokenCommandInput = GetOpenIdTokenInput;
export declare type GetOpenIdTokenCommandOutput = GetOpenIdTokenResponse & __MetadataBearer;
/**
 * <p>Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by
 *             <a>GetId</a>. You can optionally add additional logins for the identity.
 *          Supplying multiple logins creates an implicit link.</p>
 *          <p>The OpenId token is valid for 10 minutes.</p>
 *          <p>This is a public API. You do not need any credentials to call this API.</p>
 */
export declare class GetOpenIdTokenCommand extends $Command<GetOpenIdTokenCommandInput, GetOpenIdTokenCommandOutput, CognitoIdentityClientResolvedConfig> {
    readonly input: GetOpenIdTokenCommandInput;
    constructor(input: GetOpenIdTokenCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CognitoIdentityClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetOpenIdTokenCommandInput, GetOpenIdTokenCommandOutput>;
    private serialize;
    private deserialize;
}
