import { CognitoIdentityClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CognitoIdentityClient";
import { SetIdentityPoolRolesInput } from "../models/models_0";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, MiddlewareStack, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer } from "@aws-sdk/types";
export declare type SetIdentityPoolRolesCommandInput = SetIdentityPoolRolesInput;
export declare type SetIdentityPoolRolesCommandOutput = __MetadataBearer;
/**
 * <p>Sets the roles for an identity pool. These roles are used when making calls to <a>GetCredentialsForIdentity</a> action.</p>
 *          <p>You must use AWS Developer credentials to call this API.</p>
 */
export declare class SetIdentityPoolRolesCommand extends $Command<SetIdentityPoolRolesCommandInput, SetIdentityPoolRolesCommandOutput, CognitoIdentityClientResolvedConfig> {
    readonly input: SetIdentityPoolRolesCommandInput;
    constructor(input: SetIdentityPoolRolesCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CognitoIdentityClientResolvedConfig, options?: __HttpHandlerOptions): Handler<SetIdentityPoolRolesCommandInput, SetIdentityPoolRolesCommandOutput>;
    private serialize;
    private deserialize;
}
