import { __extends } from "tslib";
import { BatchDetectEntitiesRequest, BatchDetectEntitiesResponse } from "../models/models_0";
import { deserializeAws_json1_1BatchDetectEntitiesCommand, serializeAws_json1_1BatchDetectEntitiesCommand, } from "../protocols/Aws_json1_1";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
/**
 * <p>Inspects the text of a batch of documents for named entities and returns information
 *       about them. For more information about named entities, see <a>how-entities</a>
 *          </p>
 */
var BatchDetectEntitiesCommand = /** @class */ (function (_super) {
    __extends(BatchDetectEntitiesCommand, _super);
    // Start section: command_properties
    // End section: command_properties
    function BatchDetectEntitiesCommand(input) {
        var _this = 
        // Start section: command_constructor
        _super.call(this) || this;
        _this.input = input;
        return _this;
        // End section: command_constructor
    }
    /**
     * @internal
     */
    BatchDetectEntitiesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "ComprehendClient";
        var commandName = "BatchDetectEntitiesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: BatchDetectEntitiesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: BatchDetectEntitiesResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    BatchDetectEntitiesCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1BatchDetectEntitiesCommand(input, context);
    };
    BatchDetectEntitiesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1BatchDetectEntitiesCommand(output, context);
    };
    return BatchDetectEntitiesCommand;
}($Command));
export { BatchDetectEntitiesCommand };
//# sourceMappingURL=BatchDetectEntitiesCommand.js.map