import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetDevicePositionHistoryRequest, GetDevicePositionHistoryResponse } from "../models/models_0";
import { deserializeAws_restJson1GetDevicePositionHistoryCommand, serializeAws_restJson1GetDevicePositionHistoryCommand, } from "../protocols/Aws_restJson1";
var GetDevicePositionHistoryCommand = (function (_super) {
    __extends(GetDevicePositionHistoryCommand, _super);
    function GetDevicePositionHistoryCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetDevicePositionHistoryCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "LocationClient";
        var commandName = "GetDevicePositionHistoryCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetDevicePositionHistoryRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetDevicePositionHistoryResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetDevicePositionHistoryCommand.prototype.serialize = function (input, context) {
        return serializeAws_restJson1GetDevicePositionHistoryCommand(input, context);
    };
    GetDevicePositionHistoryCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restJson1GetDevicePositionHistoryCommand(output, context);
    };
    return GetDevicePositionHistoryCommand;
}($Command));
export { GetDevicePositionHistoryCommand };
