import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListMapsRequest, ListMapsResponse } from "../models/models_0";
import { deserializeAws_restJson1ListMapsCommand, serializeAws_restJson1ListMapsCommand, } from "../protocols/Aws_restJson1";
var ListMapsCommand = (function (_super) {
    __extends(ListMapsCommand, _super);
    function ListMapsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListMapsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "LocationClient";
        var commandName = "ListMapsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListMapsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListMapsResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListMapsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restJson1ListMapsCommand(input, context);
    };
    ListMapsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restJson1ListMapsCommand(output, context);
    };
    return ListMapsCommand;
}($Command));
export { ListMapsCommand };
