import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListPlaceIndexesRequest, ListPlaceIndexesResponse } from "../models/models_0";
import { deserializeAws_restJson1ListPlaceIndexesCommand, serializeAws_restJson1ListPlaceIndexesCommand, } from "../protocols/Aws_restJson1";
var ListPlaceIndexesCommand = (function (_super) {
    __extends(ListPlaceIndexesCommand, _super);
    function ListPlaceIndexesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListPlaceIndexesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "LocationClient";
        var commandName = "ListPlaceIndexesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListPlaceIndexesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListPlaceIndexesResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListPlaceIndexesCommand.prototype.serialize = function (input, context) {
        return serializeAws_restJson1ListPlaceIndexesCommand(input, context);
    };
    ListPlaceIndexesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restJson1ListPlaceIndexesCommand(output, context);
    };
    return ListPlaceIndexesCommand;
}($Command));
export { ListPlaceIndexesCommand };
