import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListTrackersRequest, ListTrackersResponse } from "../models/models_0";
import { deserializeAws_restJson1ListTrackersCommand, serializeAws_restJson1ListTrackersCommand, } from "../protocols/Aws_restJson1";
var ListTrackersCommand = (function (_super) {
    __extends(ListTrackersCommand, _super);
    function ListTrackersCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListTrackersCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "LocationClient";
        var commandName = "ListTrackersCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListTrackersRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListTrackersResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListTrackersCommand.prototype.serialize = function (input, context) {
        return serializeAws_restJson1ListTrackersCommand(input, context);
    };
    ListTrackersCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restJson1ListTrackersCommand(output, context);
    };
    return ListTrackersCommand;
}($Command));
export { ListTrackersCommand };
