import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { LocationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../LocationClient";
import { GetGeofenceRequest, GetGeofenceResponse } from "../models/models_0";
export interface GetGeofenceCommandInput extends GetGeofenceRequest {
}
export interface GetGeofenceCommandOutput extends GetGeofenceResponse, __MetadataBearer {
}
/**
 * <p>Retrieves the geofence details from a geofence collection.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { LocationClient, GetGeofenceCommand } from "@aws-sdk/client-location"; // ES Modules import
 * // const { LocationClient, GetGeofenceCommand } = require("@aws-sdk/client-location"); // CommonJS import
 * const client = new LocationClient(config);
 * const command = new GetGeofenceCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link GetGeofenceCommandInput} for command's `input` shape.
 * @see {@link GetGeofenceCommandOutput} for command's `response` shape.
 * @see {@link LocationClientResolvedConfig | config} for LocationClient's `config` shape.
 *
 */
export declare class GetGeofenceCommand extends $Command<GetGeofenceCommandInput, GetGeofenceCommandOutput, LocationClientResolvedConfig> {
    readonly input: GetGeofenceCommandInput;
    constructor(input: GetGeofenceCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: LocationClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetGeofenceCommandInput, GetGeofenceCommandOutput>;
    private serialize;
    private deserialize;
}
