import { EndpointsInputConfig, EndpointsResolvedConfig, RegionInputConfig, RegionResolvedConfig } from "@aws-sdk/config-resolver";
import { HostHeaderInputConfig, HostHeaderResolvedConfig } from "@aws-sdk/middleware-host-header";
import { RetryInputConfig, RetryResolvedConfig } from "@aws-sdk/middleware-retry";
import { AwsAuthInputConfig, AwsAuthResolvedConfig } from "@aws-sdk/middleware-signing";
import { UserAgentInputConfig, UserAgentResolvedConfig } from "@aws-sdk/middleware-user-agent";
import { HttpHandler as __HttpHandler } from "@aws-sdk/protocol-http";
import { Client as __Client, DefaultsMode, SmithyConfiguration as __SmithyConfiguration, SmithyResolvedConfiguration as __SmithyResolvedConfiguration } from "@aws-sdk/smithy-client";
import { Credentials as __Credentials, Decoder as __Decoder, Encoder as __Encoder, HashConstructor as __HashConstructor, HttpHandlerOptions as __HttpHandlerOptions, Logger as __Logger, Provider as __Provider, Provider, RegionInfoProvider, StreamCollector as __StreamCollector, UrlParser as __UrlParser, UserAgent as __UserAgent } from "@aws-sdk/types";
import { AssociateTrackerConsumerCommandInput, AssociateTrackerConsumerCommandOutput } from "./commands/AssociateTrackerConsumerCommand";
import { BatchDeleteDevicePositionHistoryCommandInput, BatchDeleteDevicePositionHistoryCommandOutput } from "./commands/BatchDeleteDevicePositionHistoryCommand";
import { BatchDeleteGeofenceCommandInput, BatchDeleteGeofenceCommandOutput } from "./commands/BatchDeleteGeofenceCommand";
import { BatchEvaluateGeofencesCommandInput, BatchEvaluateGeofencesCommandOutput } from "./commands/BatchEvaluateGeofencesCommand";
import { BatchGetDevicePositionCommandInput, BatchGetDevicePositionCommandOutput } from "./commands/BatchGetDevicePositionCommand";
import { BatchPutGeofenceCommandInput, BatchPutGeofenceCommandOutput } from "./commands/BatchPutGeofenceCommand";
import { BatchUpdateDevicePositionCommandInput, BatchUpdateDevicePositionCommandOutput } from "./commands/BatchUpdateDevicePositionCommand";
import { CalculateRouteCommandInput, CalculateRouteCommandOutput } from "./commands/CalculateRouteCommand";
import { CalculateRouteMatrixCommandInput, CalculateRouteMatrixCommandOutput } from "./commands/CalculateRouteMatrixCommand";
import { CreateGeofenceCollectionCommandInput, CreateGeofenceCollectionCommandOutput } from "./commands/CreateGeofenceCollectionCommand";
import { CreateMapCommandInput, CreateMapCommandOutput } from "./commands/CreateMapCommand";
import { CreatePlaceIndexCommandInput, CreatePlaceIndexCommandOutput } from "./commands/CreatePlaceIndexCommand";
import { CreateRouteCalculatorCommandInput, CreateRouteCalculatorCommandOutput } from "./commands/CreateRouteCalculatorCommand";
import { CreateTrackerCommandInput, CreateTrackerCommandOutput } from "./commands/CreateTrackerCommand";
import { DeleteGeofenceCollectionCommandInput, DeleteGeofenceCollectionCommandOutput } from "./commands/DeleteGeofenceCollectionCommand";
import { DeleteMapCommandInput, DeleteMapCommandOutput } from "./commands/DeleteMapCommand";
import { DeletePlaceIndexCommandInput, DeletePlaceIndexCommandOutput } from "./commands/DeletePlaceIndexCommand";
import { DeleteRouteCalculatorCommandInput, DeleteRouteCalculatorCommandOutput } from "./commands/DeleteRouteCalculatorCommand";
import { DeleteTrackerCommandInput, DeleteTrackerCommandOutput } from "./commands/DeleteTrackerCommand";
import { DescribeGeofenceCollectionCommandInput, DescribeGeofenceCollectionCommandOutput } from "./commands/DescribeGeofenceCollectionCommand";
import { DescribeMapCommandInput, DescribeMapCommandOutput } from "./commands/DescribeMapCommand";
import { DescribePlaceIndexCommandInput, DescribePlaceIndexCommandOutput } from "./commands/DescribePlaceIndexCommand";
import { DescribeRouteCalculatorCommandInput, DescribeRouteCalculatorCommandOutput } from "./commands/DescribeRouteCalculatorCommand";
import { DescribeTrackerCommandInput, DescribeTrackerCommandOutput } from "./commands/DescribeTrackerCommand";
import { DisassociateTrackerConsumerCommandInput, DisassociateTrackerConsumerCommandOutput } from "./commands/DisassociateTrackerConsumerCommand";
import { GetDevicePositionCommandInput, GetDevicePositionCommandOutput } from "./commands/GetDevicePositionCommand";
import { GetDevicePositionHistoryCommandInput, GetDevicePositionHistoryCommandOutput } from "./commands/GetDevicePositionHistoryCommand";
import { GetGeofenceCommandInput, GetGeofenceCommandOutput } from "./commands/GetGeofenceCommand";
import { GetMapGlyphsCommandInput, GetMapGlyphsCommandOutput } from "./commands/GetMapGlyphsCommand";
import { GetMapSpritesCommandInput, GetMapSpritesCommandOutput } from "./commands/GetMapSpritesCommand";
import { GetMapStyleDescriptorCommandInput, GetMapStyleDescriptorCommandOutput } from "./commands/GetMapStyleDescriptorCommand";
import { GetMapTileCommandInput, GetMapTileCommandOutput } from "./commands/GetMapTileCommand";
import { ListDevicePositionsCommandInput, ListDevicePositionsCommandOutput } from "./commands/ListDevicePositionsCommand";
import { ListGeofenceCollectionsCommandInput, ListGeofenceCollectionsCommandOutput } from "./commands/ListGeofenceCollectionsCommand";
import { ListGeofencesCommandInput, ListGeofencesCommandOutput } from "./commands/ListGeofencesCommand";
import { ListMapsCommandInput, ListMapsCommandOutput } from "./commands/ListMapsCommand";
import { ListPlaceIndexesCommandInput, ListPlaceIndexesCommandOutput } from "./commands/ListPlaceIndexesCommand";
import { ListRouteCalculatorsCommandInput, ListRouteCalculatorsCommandOutput } from "./commands/ListRouteCalculatorsCommand";
import { ListTagsForResourceCommandInput, ListTagsForResourceCommandOutput } from "./commands/ListTagsForResourceCommand";
import { ListTrackerConsumersCommandInput, ListTrackerConsumersCommandOutput } from "./commands/ListTrackerConsumersCommand";
import { ListTrackersCommandInput, ListTrackersCommandOutput } from "./commands/ListTrackersCommand";
import { PutGeofenceCommandInput, PutGeofenceCommandOutput } from "./commands/PutGeofenceCommand";
import { SearchPlaceIndexForPositionCommandInput, SearchPlaceIndexForPositionCommandOutput } from "./commands/SearchPlaceIndexForPositionCommand";
import { SearchPlaceIndexForSuggestionsCommandInput, SearchPlaceIndexForSuggestionsCommandOutput } from "./commands/SearchPlaceIndexForSuggestionsCommand";
import { SearchPlaceIndexForTextCommandInput, SearchPlaceIndexForTextCommandOutput } from "./commands/SearchPlaceIndexForTextCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdateGeofenceCollectionCommandInput, UpdateGeofenceCollectionCommandOutput } from "./commands/UpdateGeofenceCollectionCommand";
import { UpdateMapCommandInput, UpdateMapCommandOutput } from "./commands/UpdateMapCommand";
import { UpdatePlaceIndexCommandInput, UpdatePlaceIndexCommandOutput } from "./commands/UpdatePlaceIndexCommand";
import { UpdateRouteCalculatorCommandInput, UpdateRouteCalculatorCommandOutput } from "./commands/UpdateRouteCalculatorCommand";
import { UpdateTrackerCommandInput, UpdateTrackerCommandOutput } from "./commands/UpdateTrackerCommand";
export declare type ServiceInputTypes = AssociateTrackerConsumerCommandInput | BatchDeleteDevicePositionHistoryCommandInput | BatchDeleteGeofenceCommandInput | BatchEvaluateGeofencesCommandInput | BatchGetDevicePositionCommandInput | BatchPutGeofenceCommandInput | BatchUpdateDevicePositionCommandInput | CalculateRouteCommandInput | CalculateRouteMatrixCommandInput | CreateGeofenceCollectionCommandInput | CreateMapCommandInput | CreatePlaceIndexCommandInput | CreateRouteCalculatorCommandInput | CreateTrackerCommandInput | DeleteGeofenceCollectionCommandInput | DeleteMapCommandInput | DeletePlaceIndexCommandInput | DeleteRouteCalculatorCommandInput | DeleteTrackerCommandInput | DescribeGeofenceCollectionCommandInput | DescribeMapCommandInput | DescribePlaceIndexCommandInput | DescribeRouteCalculatorCommandInput | DescribeTrackerCommandInput | DisassociateTrackerConsumerCommandInput | GetDevicePositionCommandInput | GetDevicePositionHistoryCommandInput | GetGeofenceCommandInput | GetMapGlyphsCommandInput | GetMapSpritesCommandInput | GetMapStyleDescriptorCommandInput | GetMapTileCommandInput | ListDevicePositionsCommandInput | ListGeofenceCollectionsCommandInput | ListGeofencesCommandInput | ListMapsCommandInput | ListPlaceIndexesCommandInput | ListRouteCalculatorsCommandInput | ListTagsForResourceCommandInput | ListTrackerConsumersCommandInput | ListTrackersCommandInput | PutGeofenceCommandInput | SearchPlaceIndexForPositionCommandInput | SearchPlaceIndexForSuggestionsCommandInput | SearchPlaceIndexForTextCommandInput | TagResourceCommandInput | UntagResourceCommandInput | UpdateGeofenceCollectionCommandInput | UpdateMapCommandInput | UpdatePlaceIndexCommandInput | UpdateRouteCalculatorCommandInput | UpdateTrackerCommandInput;
export declare type ServiceOutputTypes = AssociateTrackerConsumerCommandOutput | BatchDeleteDevicePositionHistoryCommandOutput | BatchDeleteGeofenceCommandOutput | BatchEvaluateGeofencesCommandOutput | BatchGetDevicePositionCommandOutput | BatchPutGeofenceCommandOutput | BatchUpdateDevicePositionCommandOutput | CalculateRouteCommandOutput | CalculateRouteMatrixCommandOutput | CreateGeofenceCollectionCommandOutput | CreateMapCommandOutput | CreatePlaceIndexCommandOutput | CreateRouteCalculatorCommandOutput | CreateTrackerCommandOutput | DeleteGeofenceCollectionCommandOutput | DeleteMapCommandOutput | DeletePlaceIndexCommandOutput | DeleteRouteCalculatorCommandOutput | DeleteTrackerCommandOutput | DescribeGeofenceCollectionCommandOutput | DescribeMapCommandOutput | DescribePlaceIndexCommandOutput | DescribeRouteCalculatorCommandOutput | DescribeTrackerCommandOutput | DisassociateTrackerConsumerCommandOutput | GetDevicePositionCommandOutput | GetDevicePositionHistoryCommandOutput | GetGeofenceCommandOutput | GetMapGlyphsCommandOutput | GetMapSpritesCommandOutput | GetMapStyleDescriptorCommandOutput | GetMapTileCommandOutput | ListDevicePositionsCommandOutput | ListGeofenceCollectionsCommandOutput | ListGeofencesCommandOutput | ListMapsCommandOutput | ListPlaceIndexesCommandOutput | ListRouteCalculatorsCommandOutput | ListTagsForResourceCommandOutput | ListTrackerConsumersCommandOutput | ListTrackersCommandOutput | PutGeofenceCommandOutput | SearchPlaceIndexForPositionCommandOutput | SearchPlaceIndexForSuggestionsCommandOutput | SearchPlaceIndexForTextCommandOutput | TagResourceCommandOutput | UntagResourceCommandOutput | UpdateGeofenceCollectionCommandOutput | UpdateMapCommandOutput | UpdatePlaceIndexCommandOutput | UpdateRouteCalculatorCommandOutput | UpdateTrackerCommandOutput;
export interface ClientDefaults extends Partial<__SmithyResolvedConfiguration<__HttpHandlerOptions>> {
    
    requestHandler?: __HttpHandler;
    
    sha256?: __HashConstructor;
    
    urlParser?: __UrlParser;
    
    bodyLengthChecker?: (body: any) => number | undefined;
    
    streamCollector?: __StreamCollector;
    
    base64Decoder?: __Decoder;
    
    base64Encoder?: __Encoder;
    
    utf8Decoder?: __Decoder;
    
    utf8Encoder?: __Encoder;
    
    runtime?: string;
    
    disableHostPrefix?: boolean;
    
    maxAttempts?: number | __Provider<number>;
    
    retryMode?: string | __Provider<string>;
    
    logger?: __Logger;
    
    useDualstackEndpoint?: boolean | __Provider<boolean>;
    
    useFipsEndpoint?: boolean | __Provider<boolean>;
    
    serviceId?: string;
    
    region?: string | __Provider<string>;
    
    credentialDefaultProvider?: (input: any) => __Provider<__Credentials>;
    
    regionInfoProvider?: RegionInfoProvider;
    
    defaultUserAgentProvider?: Provider<__UserAgent>;
    
    defaultsMode?: DefaultsMode | Provider<DefaultsMode>;
}
declare type LocationClientConfigType = Partial<__SmithyConfiguration<__HttpHandlerOptions>> & ClientDefaults & RegionInputConfig & EndpointsInputConfig & RetryInputConfig & HostHeaderInputConfig & AwsAuthInputConfig & UserAgentInputConfig;

export interface LocationClientConfig extends LocationClientConfigType {
}
declare type LocationClientResolvedConfigType = __SmithyResolvedConfiguration<__HttpHandlerOptions> & Required<ClientDefaults> & RegionResolvedConfig & EndpointsResolvedConfig & RetryResolvedConfig & HostHeaderResolvedConfig & AwsAuthResolvedConfig & UserAgentResolvedConfig;

export interface LocationClientResolvedConfig extends LocationClientResolvedConfigType {
}

export declare class LocationClient extends __Client<__HttpHandlerOptions, ServiceInputTypes, ServiceOutputTypes, LocationClientResolvedConfig> {
    
    readonly config: LocationClientResolvedConfig;
    constructor(configuration: LocationClientConfig);
    
    destroy(): void;
}
export {};
