import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { LocationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../LocationClient";
import { CreateGeofenceCollectionRequest, CreateGeofenceCollectionResponse } from "../models/models_0";
export interface CreateGeofenceCollectionCommandInput extends CreateGeofenceCollectionRequest {
}
export interface CreateGeofenceCollectionCommandOutput extends CreateGeofenceCollectionResponse, __MetadataBearer {
}

export declare class CreateGeofenceCollectionCommand extends $Command<CreateGeofenceCollectionCommandInput, CreateGeofenceCollectionCommandOutput, LocationClientResolvedConfig> {
    readonly input: CreateGeofenceCollectionCommandInput;
    constructor(input: CreateGeofenceCollectionCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: LocationClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateGeofenceCollectionCommandInput, CreateGeofenceCollectionCommandOutput>;
    private serialize;
    private deserialize;
}
