import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { LocationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../LocationClient";
import { PutGeofenceRequest, PutGeofenceResponse } from "../models/models_0";
export interface PutGeofenceCommandInput extends PutGeofenceRequest {
}
export interface PutGeofenceCommandOutput extends PutGeofenceResponse, __MetadataBearer {
}

export declare class PutGeofenceCommand extends $Command<PutGeofenceCommandInput, PutGeofenceCommandOutput, LocationClientResolvedConfig> {
    readonly input: PutGeofenceCommandInput;
    constructor(input: PutGeofenceCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: LocationClientResolvedConfig, options?: __HttpHandlerOptions): Handler<PutGeofenceCommandInput, PutGeofenceCommandOutput>;
    private serialize;
    private deserialize;
}
