import { MetadataBearer as $MetadataBearer, SmithyException as __SmithyException } from "@aws-sdk/types";

export interface AccessDeniedException extends __SmithyException, $MetadataBearer {
    name: "AccessDeniedException";
    $fault: "client";
    Message: string | undefined;
}
export interface AssociateTrackerConsumerRequest {
    
    TrackerName: string | undefined;
    
    ConsumerArn: string | undefined;
}
export declare namespace AssociateTrackerConsumerRequest {
    
    const filterSensitiveLog: (obj: AssociateTrackerConsumerRequest) => any;
}
export interface AssociateTrackerConsumerResponse {
}
export declare namespace AssociateTrackerConsumerResponse {
    
    const filterSensitiveLog: (obj: AssociateTrackerConsumerResponse) => any;
}

export interface ConflictException extends __SmithyException, $MetadataBearer {
    name: "ConflictException";
    $fault: "client";
    Message: string | undefined;
}

export interface InternalServerException extends __SmithyException, $MetadataBearer {
    name: "InternalServerException";
    $fault: "server";
    $retryable: {};
    Message: string | undefined;
}

export interface ResourceNotFoundException extends __SmithyException, $MetadataBearer {
    name: "ResourceNotFoundException";
    $fault: "client";
    Message: string | undefined;
}

export interface ServiceQuotaExceededException extends __SmithyException, $MetadataBearer {
    name: "ServiceQuotaExceededException";
    $fault: "client";
    
    Message: string | undefined;
}

export interface ThrottlingException extends __SmithyException, $MetadataBearer {
    name: "ThrottlingException";
    $fault: "client";
    $retryable: {};
    Message: string | undefined;
}

export interface ValidationExceptionField {
    
    Name: string | undefined;
    
    Message: string | undefined;
}
export declare namespace ValidationExceptionField {
    
    const filterSensitiveLog: (obj: ValidationExceptionField) => any;
}
export declare type ValidationExceptionReason = "CannotParse" | "FieldValidationFailed" | "Missing" | "Other" | "UnknownOperation";

export interface ValidationException extends __SmithyException, $MetadataBearer {
    name: "ValidationException";
    $fault: "client";
    Message: string | undefined;
    
    Reason: ValidationExceptionReason | string | undefined;
    
    FieldList: ValidationExceptionField[] | undefined;
}
export interface BatchDeleteDevicePositionHistoryRequest {
    
    TrackerName: string | undefined;
    
    DeviceIds: string[] | undefined;
}
export declare namespace BatchDeleteDevicePositionHistoryRequest {
    
    const filterSensitiveLog: (obj: BatchDeleteDevicePositionHistoryRequest) => any;
}
export declare type BatchItemErrorCode = "AccessDeniedError" | "ConflictError" | "InternalServerError" | "ResourceNotFoundError" | "ThrottlingError" | "ValidationError";

export interface BatchItemError {
    
    Code?: BatchItemErrorCode | string;
    
    Message?: string;
}
export declare namespace BatchItemError {
    
    const filterSensitiveLog: (obj: BatchItemError) => any;
}

export interface BatchDeleteDevicePositionHistoryError {
    
    DeviceId: string | undefined;
    
    Error: BatchItemError | undefined;
}
export declare namespace BatchDeleteDevicePositionHistoryError {
    
    const filterSensitiveLog: (obj: BatchDeleteDevicePositionHistoryError) => any;
}
export interface BatchDeleteDevicePositionHistoryResponse {
    
    Errors: BatchDeleteDevicePositionHistoryError[] | undefined;
}
export declare namespace BatchDeleteDevicePositionHistoryResponse {
    
    const filterSensitiveLog: (obj: BatchDeleteDevicePositionHistoryResponse) => any;
}
export interface BatchDeleteGeofenceRequest {
    
    CollectionName: string | undefined;
    
    GeofenceIds: string[] | undefined;
}
export declare namespace BatchDeleteGeofenceRequest {
    
    const filterSensitiveLog: (obj: BatchDeleteGeofenceRequest) => any;
}

export interface BatchDeleteGeofenceError {
    
    GeofenceId: string | undefined;
    
    Error: BatchItemError | undefined;
}
export declare namespace BatchDeleteGeofenceError {
    
    const filterSensitiveLog: (obj: BatchDeleteGeofenceError) => any;
}
export interface BatchDeleteGeofenceResponse {
    
    Errors: BatchDeleteGeofenceError[] | undefined;
}
export declare namespace BatchDeleteGeofenceResponse {
    
    const filterSensitiveLog: (obj: BatchDeleteGeofenceResponse) => any;
}

export interface PositionalAccuracy {
    
    Horizontal: number | undefined;
}
export declare namespace PositionalAccuracy {
    
    const filterSensitiveLog: (obj: PositionalAccuracy) => any;
}

export interface DevicePositionUpdate {
    
    DeviceId: string | undefined;
    
    SampleTime: Date | undefined;
    
    Position: number[] | undefined;
    
    Accuracy?: PositionalAccuracy;
    
    PositionProperties?: {
        [key: string]: string;
    };
}
export declare namespace DevicePositionUpdate {
    
    const filterSensitiveLog: (obj: DevicePositionUpdate) => any;
}
export interface BatchEvaluateGeofencesRequest {
    
    CollectionName: string | undefined;
    
    DevicePositionUpdates: DevicePositionUpdate[] | undefined;
}
export declare namespace BatchEvaluateGeofencesRequest {
    
    const filterSensitiveLog: (obj: BatchEvaluateGeofencesRequest) => any;
}

export interface BatchEvaluateGeofencesError {
    
    DeviceId: string | undefined;
    
    SampleTime: Date | undefined;
    
    Error: BatchItemError | undefined;
}
export declare namespace BatchEvaluateGeofencesError {
    
    const filterSensitiveLog: (obj: BatchEvaluateGeofencesError) => any;
}
export interface BatchEvaluateGeofencesResponse {
    
    Errors: BatchEvaluateGeofencesError[] | undefined;
}
export declare namespace BatchEvaluateGeofencesResponse {
    
    const filterSensitiveLog: (obj: BatchEvaluateGeofencesResponse) => any;
}
export interface BatchGetDevicePositionRequest {
    
    TrackerName: string | undefined;
    
    DeviceIds: string[] | undefined;
}
export declare namespace BatchGetDevicePositionRequest {
    
    const filterSensitiveLog: (obj: BatchGetDevicePositionRequest) => any;
}

export interface DevicePosition {
    
    DeviceId?: string;
    
    SampleTime: Date | undefined;
    
    ReceivedTime: Date | undefined;
    
    Position: number[] | undefined;
    
    Accuracy?: PositionalAccuracy;
    
    PositionProperties?: {
        [key: string]: string;
    };
}
export declare namespace DevicePosition {
    
    const filterSensitiveLog: (obj: DevicePosition) => any;
}

export interface BatchGetDevicePositionError {
    
    DeviceId: string | undefined;
    
    Error: BatchItemError | undefined;
}
export declare namespace BatchGetDevicePositionError {
    
    const filterSensitiveLog: (obj: BatchGetDevicePositionError) => any;
}
export interface BatchGetDevicePositionResponse {
    
    Errors: BatchGetDevicePositionError[] | undefined;
    
    DevicePositions: DevicePosition[] | undefined;
}
export declare namespace BatchGetDevicePositionResponse {
    
    const filterSensitiveLog: (obj: BatchGetDevicePositionResponse) => any;
}

export interface GeofenceGeometry {
    
    Polygon?: number[][][];
}
export declare namespace GeofenceGeometry {
    
    const filterSensitiveLog: (obj: GeofenceGeometry) => any;
}

export interface BatchPutGeofenceRequestEntry {
    
    GeofenceId: string | undefined;
    
    Geometry: GeofenceGeometry | undefined;
}
export declare namespace BatchPutGeofenceRequestEntry {
    
    const filterSensitiveLog: (obj: BatchPutGeofenceRequestEntry) => any;
}
export interface BatchPutGeofenceRequest {
    
    CollectionName: string | undefined;
    
    Entries: BatchPutGeofenceRequestEntry[] | undefined;
}
export declare namespace BatchPutGeofenceRequest {
    
    const filterSensitiveLog: (obj: BatchPutGeofenceRequest) => any;
}

export interface BatchPutGeofenceError {
    
    GeofenceId: string | undefined;
    
    Error: BatchItemError | undefined;
}
export declare namespace BatchPutGeofenceError {
    
    const filterSensitiveLog: (obj: BatchPutGeofenceError) => any;
}

export interface BatchPutGeofenceSuccess {
    
    GeofenceId: string | undefined;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace BatchPutGeofenceSuccess {
    
    const filterSensitiveLog: (obj: BatchPutGeofenceSuccess) => any;
}
export interface BatchPutGeofenceResponse {
    
    Successes: BatchPutGeofenceSuccess[] | undefined;
    
    Errors: BatchPutGeofenceError[] | undefined;
}
export declare namespace BatchPutGeofenceResponse {
    
    const filterSensitiveLog: (obj: BatchPutGeofenceResponse) => any;
}
export interface BatchUpdateDevicePositionRequest {
    
    TrackerName: string | undefined;
    
    Updates: DevicePositionUpdate[] | undefined;
}
export declare namespace BatchUpdateDevicePositionRequest {
    
    const filterSensitiveLog: (obj: BatchUpdateDevicePositionRequest) => any;
}

export interface BatchUpdateDevicePositionError {
    
    DeviceId: string | undefined;
    
    SampleTime: Date | undefined;
    
    Error: BatchItemError | undefined;
}
export declare namespace BatchUpdateDevicePositionError {
    
    const filterSensitiveLog: (obj: BatchUpdateDevicePositionError) => any;
}
export interface BatchUpdateDevicePositionResponse {
    
    Errors: BatchUpdateDevicePositionError[] | undefined;
}
export declare namespace BatchUpdateDevicePositionResponse {
    
    const filterSensitiveLog: (obj: BatchUpdateDevicePositionResponse) => any;
}

export interface CalculateRouteCarModeOptions {
    
    AvoidFerries?: boolean;
    
    AvoidTolls?: boolean;
}
export declare namespace CalculateRouteCarModeOptions {
    
    const filterSensitiveLog: (obj: CalculateRouteCarModeOptions) => any;
}
export declare type DistanceUnit = "Kilometers" | "Miles";
export declare type TravelMode = "Car" | "Truck" | "Walking";
export declare type DimensionUnit = "Feet" | "Meters";

export interface TruckDimensions {
    
    Length?: number;
    
    Height?: number;
    
    Width?: number;
    
    Unit?: DimensionUnit | string;
}
export declare namespace TruckDimensions {
    
    const filterSensitiveLog: (obj: TruckDimensions) => any;
}
export declare type VehicleWeightUnit = "Kilograms" | "Pounds";

export interface TruckWeight {
    
    Total?: number;
    
    Unit?: VehicleWeightUnit | string;
}
export declare namespace TruckWeight {
    
    const filterSensitiveLog: (obj: TruckWeight) => any;
}

export interface CalculateRouteTruckModeOptions {
    
    AvoidFerries?: boolean;
    
    AvoidTolls?: boolean;
    
    Dimensions?: TruckDimensions;
    
    Weight?: TruckWeight;
}
export declare namespace CalculateRouteTruckModeOptions {
    
    const filterSensitiveLog: (obj: CalculateRouteTruckModeOptions) => any;
}
export interface CalculateRouteRequest {
    
    CalculatorName: string | undefined;
    
    DeparturePosition: number[] | undefined;
    
    DestinationPosition: number[] | undefined;
    
    WaypointPositions?: number[][];
    
    TravelMode?: TravelMode | string;
    
    DepartureTime?: Date;
    
    DepartNow?: boolean;
    
    DistanceUnit?: DistanceUnit | string;
    
    IncludeLegGeometry?: boolean;
    
    CarModeOptions?: CalculateRouteCarModeOptions;
    
    TruckModeOptions?: CalculateRouteTruckModeOptions;
}
export declare namespace CalculateRouteRequest {
    
    const filterSensitiveLog: (obj: CalculateRouteRequest) => any;
}

export interface LegGeometry {
    
    LineString?: number[][];
}
export declare namespace LegGeometry {
    
    const filterSensitiveLog: (obj: LegGeometry) => any;
}

export interface Step {
    
    StartPosition: number[] | undefined;
    
    EndPosition: number[] | undefined;
    
    Distance: number | undefined;
    
    DurationSeconds: number | undefined;
    
    GeometryOffset?: number;
}
export declare namespace Step {
    
    const filterSensitiveLog: (obj: Step) => any;
}

export interface Leg {
    
    StartPosition: number[] | undefined;
    
    EndPosition: number[] | undefined;
    
    Distance: number | undefined;
    
    DurationSeconds: number | undefined;
    
    Geometry?: LegGeometry;
    
    Steps: Step[] | undefined;
}
export declare namespace Leg {
    
    const filterSensitiveLog: (obj: Leg) => any;
}

export interface CalculateRouteSummary {
    
    RouteBBox: number[] | undefined;
    
    DataSource: string | undefined;
    
    Distance: number | undefined;
    
    DurationSeconds: number | undefined;
    
    DistanceUnit: DistanceUnit | string | undefined;
}
export declare namespace CalculateRouteSummary {
    
    const filterSensitiveLog: (obj: CalculateRouteSummary) => any;
}

export interface CalculateRouteResponse {
    
    Legs: Leg[] | undefined;
    
    Summary: CalculateRouteSummary | undefined;
}
export declare namespace CalculateRouteResponse {
    
    const filterSensitiveLog: (obj: CalculateRouteResponse) => any;
}
export interface CalculateRouteMatrixRequest {
    
    CalculatorName: string | undefined;
    
    DeparturePositions: number[][] | undefined;
    
    DestinationPositions: number[][] | undefined;
    
    TravelMode?: TravelMode | string;
    
    DepartureTime?: Date;
    
    DepartNow?: boolean;
    
    DistanceUnit?: DistanceUnit | string;
    
    CarModeOptions?: CalculateRouteCarModeOptions;
    
    TruckModeOptions?: CalculateRouteTruckModeOptions;
}
export declare namespace CalculateRouteMatrixRequest {
    
    const filterSensitiveLog: (obj: CalculateRouteMatrixRequest) => any;
}
export declare type RouteMatrixErrorCode = "DeparturePositionNotFound" | "DestinationPositionNotFound" | "OtherValidationError" | "PositionsNotFound" | "RouteNotFound" | "RouteTooLong";

export interface RouteMatrixEntryError {
    
    Code: RouteMatrixErrorCode | string | undefined;
    
    Message?: string;
}
export declare namespace RouteMatrixEntryError {
    
    const filterSensitiveLog: (obj: RouteMatrixEntryError) => any;
}

export interface RouteMatrixEntry {
    
    Distance?: number;
    
    DurationSeconds?: number;
    
    Error?: RouteMatrixEntryError;
}
export declare namespace RouteMatrixEntry {
    
    const filterSensitiveLog: (obj: RouteMatrixEntry) => any;
}

export interface CalculateRouteMatrixSummary {
    
    DataSource: string | undefined;
    
    RouteCount: number | undefined;
    
    ErrorCount: number | undefined;
    
    DistanceUnit: DistanceUnit | string | undefined;
}
export declare namespace CalculateRouteMatrixSummary {
    
    const filterSensitiveLog: (obj: CalculateRouteMatrixSummary) => any;
}

export interface CalculateRouteMatrixResponse {
    
    RouteMatrix: RouteMatrixEntry[][] | undefined;
    
    SnappedDeparturePositions?: number[][];
    
    SnappedDestinationPositions?: number[][];
    
    Summary: CalculateRouteMatrixSummary | undefined;
}
export declare namespace CalculateRouteMatrixResponse {
    
    const filterSensitiveLog: (obj: CalculateRouteMatrixResponse) => any;
}
export declare type PricingPlan = "MobileAssetManagement" | "MobileAssetTracking" | "RequestBasedUsage";
export interface CreateGeofenceCollectionRequest {
    
    CollectionName: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    PricingPlanDataSource?: string;
    
    Description?: string;
    
    Tags?: {
        [key: string]: string;
    };
    
    KmsKeyId?: string;
}
export declare namespace CreateGeofenceCollectionRequest {
    
    const filterSensitiveLog: (obj: CreateGeofenceCollectionRequest) => any;
}
export interface CreateGeofenceCollectionResponse {
    
    CollectionName: string | undefined;
    
    CollectionArn: string | undefined;
    
    CreateTime: Date | undefined;
}
export declare namespace CreateGeofenceCollectionResponse {
    
    const filterSensitiveLog: (obj: CreateGeofenceCollectionResponse) => any;
}

export interface MapConfiguration {
    
    Style: string | undefined;
}
export declare namespace MapConfiguration {
    
    const filterSensitiveLog: (obj: MapConfiguration) => any;
}
export interface CreateMapRequest {
    
    MapName: string | undefined;
    
    Configuration: MapConfiguration | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    Description?: string;
    
    Tags?: {
        [key: string]: string;
    };
}
export declare namespace CreateMapRequest {
    
    const filterSensitiveLog: (obj: CreateMapRequest) => any;
}
export interface CreateMapResponse {
    
    MapName: string | undefined;
    
    MapArn: string | undefined;
    
    CreateTime: Date | undefined;
}
export declare namespace CreateMapResponse {
    
    const filterSensitiveLog: (obj: CreateMapResponse) => any;
}
export declare type IntendedUse = "SingleUse" | "Storage";

export interface DataSourceConfiguration {
    
    IntendedUse?: IntendedUse | string;
}
export declare namespace DataSourceConfiguration {
    
    const filterSensitiveLog: (obj: DataSourceConfiguration) => any;
}
export interface CreatePlaceIndexRequest {
    
    IndexName: string | undefined;
    
    DataSource: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    Description?: string;
    
    DataSourceConfiguration?: DataSourceConfiguration;
    
    Tags?: {
        [key: string]: string;
    };
}
export declare namespace CreatePlaceIndexRequest {
    
    const filterSensitiveLog: (obj: CreatePlaceIndexRequest) => any;
}
export interface CreatePlaceIndexResponse {
    
    IndexName: string | undefined;
    
    IndexArn: string | undefined;
    
    CreateTime: Date | undefined;
}
export declare namespace CreatePlaceIndexResponse {
    
    const filterSensitiveLog: (obj: CreatePlaceIndexResponse) => any;
}
export interface CreateRouteCalculatorRequest {
    
    CalculatorName: string | undefined;
    
    DataSource: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    Description?: string;
    
    Tags?: {
        [key: string]: string;
    };
}
export declare namespace CreateRouteCalculatorRequest {
    
    const filterSensitiveLog: (obj: CreateRouteCalculatorRequest) => any;
}
export interface CreateRouteCalculatorResponse {
    
    CalculatorName: string | undefined;
    
    CalculatorArn: string | undefined;
    
    CreateTime: Date | undefined;
}
export declare namespace CreateRouteCalculatorResponse {
    
    const filterSensitiveLog: (obj: CreateRouteCalculatorResponse) => any;
}
export declare type PositionFiltering = "AccuracyBased" | "DistanceBased" | "TimeBased";
export interface CreateTrackerRequest {
    
    TrackerName: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    KmsKeyId?: string;
    
    PricingPlanDataSource?: string;
    
    Description?: string;
    
    Tags?: {
        [key: string]: string;
    };
    
    PositionFiltering?: PositionFiltering | string;
}
export declare namespace CreateTrackerRequest {
    
    const filterSensitiveLog: (obj: CreateTrackerRequest) => any;
}
export interface CreateTrackerResponse {
    
    TrackerName: string | undefined;
    
    TrackerArn: string | undefined;
    
    CreateTime: Date | undefined;
}
export declare namespace CreateTrackerResponse {
    
    const filterSensitiveLog: (obj: CreateTrackerResponse) => any;
}
export interface DeleteGeofenceCollectionRequest {
    
    CollectionName: string | undefined;
}
export declare namespace DeleteGeofenceCollectionRequest {
    
    const filterSensitiveLog: (obj: DeleteGeofenceCollectionRequest) => any;
}
export interface DeleteGeofenceCollectionResponse {
}
export declare namespace DeleteGeofenceCollectionResponse {
    
    const filterSensitiveLog: (obj: DeleteGeofenceCollectionResponse) => any;
}
export interface DeleteMapRequest {
    
    MapName: string | undefined;
}
export declare namespace DeleteMapRequest {
    
    const filterSensitiveLog: (obj: DeleteMapRequest) => any;
}
export interface DeleteMapResponse {
}
export declare namespace DeleteMapResponse {
    
    const filterSensitiveLog: (obj: DeleteMapResponse) => any;
}
export interface DeletePlaceIndexRequest {
    
    IndexName: string | undefined;
}
export declare namespace DeletePlaceIndexRequest {
    
    const filterSensitiveLog: (obj: DeletePlaceIndexRequest) => any;
}
export interface DeletePlaceIndexResponse {
}
export declare namespace DeletePlaceIndexResponse {
    
    const filterSensitiveLog: (obj: DeletePlaceIndexResponse) => any;
}
export interface DeleteRouteCalculatorRequest {
    
    CalculatorName: string | undefined;
}
export declare namespace DeleteRouteCalculatorRequest {
    
    const filterSensitiveLog: (obj: DeleteRouteCalculatorRequest) => any;
}
export interface DeleteRouteCalculatorResponse {
}
export declare namespace DeleteRouteCalculatorResponse {
    
    const filterSensitiveLog: (obj: DeleteRouteCalculatorResponse) => any;
}
export interface DeleteTrackerRequest {
    
    TrackerName: string | undefined;
}
export declare namespace DeleteTrackerRequest {
    
    const filterSensitiveLog: (obj: DeleteTrackerRequest) => any;
}
export interface DeleteTrackerResponse {
}
export declare namespace DeleteTrackerResponse {
    
    const filterSensitiveLog: (obj: DeleteTrackerResponse) => any;
}
export interface DescribeGeofenceCollectionRequest {
    
    CollectionName: string | undefined;
}
export declare namespace DescribeGeofenceCollectionRequest {
    
    const filterSensitiveLog: (obj: DescribeGeofenceCollectionRequest) => any;
}
export interface DescribeGeofenceCollectionResponse {
    
    CollectionName: string | undefined;
    
    CollectionArn: string | undefined;
    
    Description: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    PricingPlanDataSource?: string;
    
    KmsKeyId?: string;
    
    Tags?: {
        [key: string]: string;
    };
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace DescribeGeofenceCollectionResponse {
    
    const filterSensitiveLog: (obj: DescribeGeofenceCollectionResponse) => any;
}
export interface DescribeMapRequest {
    
    MapName: string | undefined;
}
export declare namespace DescribeMapRequest {
    
    const filterSensitiveLog: (obj: DescribeMapRequest) => any;
}
export interface DescribeMapResponse {
    
    MapName: string | undefined;
    
    MapArn: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    DataSource: string | undefined;
    
    Configuration: MapConfiguration | undefined;
    
    Description: string | undefined;
    
    Tags?: {
        [key: string]: string;
    };
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace DescribeMapResponse {
    
    const filterSensitiveLog: (obj: DescribeMapResponse) => any;
}
export interface DescribePlaceIndexRequest {
    
    IndexName: string | undefined;
}
export declare namespace DescribePlaceIndexRequest {
    
    const filterSensitiveLog: (obj: DescribePlaceIndexRequest) => any;
}
export interface DescribePlaceIndexResponse {
    
    IndexName: string | undefined;
    
    IndexArn: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    Description: string | undefined;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
    
    DataSource: string | undefined;
    
    DataSourceConfiguration: DataSourceConfiguration | undefined;
    
    Tags?: {
        [key: string]: string;
    };
}
export declare namespace DescribePlaceIndexResponse {
    
    const filterSensitiveLog: (obj: DescribePlaceIndexResponse) => any;
}
export interface DescribeRouteCalculatorRequest {
    
    CalculatorName: string | undefined;
}
export declare namespace DescribeRouteCalculatorRequest {
    
    const filterSensitiveLog: (obj: DescribeRouteCalculatorRequest) => any;
}
export interface DescribeRouteCalculatorResponse {
    
    CalculatorName: string | undefined;
    
    CalculatorArn: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    Description: string | undefined;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
    
    DataSource: string | undefined;
    
    Tags?: {
        [key: string]: string;
    };
}
export declare namespace DescribeRouteCalculatorResponse {
    
    const filterSensitiveLog: (obj: DescribeRouteCalculatorResponse) => any;
}
export interface DescribeTrackerRequest {
    
    TrackerName: string | undefined;
}
export declare namespace DescribeTrackerRequest {
    
    const filterSensitiveLog: (obj: DescribeTrackerRequest) => any;
}
export interface DescribeTrackerResponse {
    
    TrackerName: string | undefined;
    
    TrackerArn: string | undefined;
    
    Description: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    PricingPlanDataSource?: string;
    
    Tags?: {
        [key: string]: string;
    };
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
    
    KmsKeyId?: string;
    
    PositionFiltering?: PositionFiltering | string;
}
export declare namespace DescribeTrackerResponse {
    
    const filterSensitiveLog: (obj: DescribeTrackerResponse) => any;
}
export interface DisassociateTrackerConsumerRequest {
    
    TrackerName: string | undefined;
    
    ConsumerArn: string | undefined;
}
export declare namespace DisassociateTrackerConsumerRequest {
    
    const filterSensitiveLog: (obj: DisassociateTrackerConsumerRequest) => any;
}
export interface DisassociateTrackerConsumerResponse {
}
export declare namespace DisassociateTrackerConsumerResponse {
    
    const filterSensitiveLog: (obj: DisassociateTrackerConsumerResponse) => any;
}
export interface ListTagsForResourceRequest {
    
    ResourceArn: string | undefined;
}
export declare namespace ListTagsForResourceRequest {
    
    const filterSensitiveLog: (obj: ListTagsForResourceRequest) => any;
}
export interface ListTagsForResourceResponse {
    
    Tags?: {
        [key: string]: string;
    };
}
export declare namespace ListTagsForResourceResponse {
    
    const filterSensitiveLog: (obj: ListTagsForResourceResponse) => any;
}
export interface TagResourceRequest {
    
    ResourceArn: string | undefined;
    
    Tags: {
        [key: string]: string;
    } | undefined;
}
export declare namespace TagResourceRequest {
    
    const filterSensitiveLog: (obj: TagResourceRequest) => any;
}
export interface TagResourceResponse {
}
export declare namespace TagResourceResponse {
    
    const filterSensitiveLog: (obj: TagResourceResponse) => any;
}
export interface UntagResourceRequest {
    
    ResourceArn: string | undefined;
    
    TagKeys: string[] | undefined;
}
export declare namespace UntagResourceRequest {
    
    const filterSensitiveLog: (obj: UntagResourceRequest) => any;
}
export interface UntagResourceResponse {
}
export declare namespace UntagResourceResponse {
    
    const filterSensitiveLog: (obj: UntagResourceResponse) => any;
}
export interface GetGeofenceRequest {
    
    CollectionName: string | undefined;
    
    GeofenceId: string | undefined;
}
export declare namespace GetGeofenceRequest {
    
    const filterSensitiveLog: (obj: GetGeofenceRequest) => any;
}
export interface GetGeofenceResponse {
    
    GeofenceId: string | undefined;
    
    Geometry: GeofenceGeometry | undefined;
    
    Status: string | undefined;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace GetGeofenceResponse {
    
    const filterSensitiveLog: (obj: GetGeofenceResponse) => any;
}
export interface ListGeofenceCollectionsRequest {
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListGeofenceCollectionsRequest {
    
    const filterSensitiveLog: (obj: ListGeofenceCollectionsRequest) => any;
}

export interface ListGeofenceCollectionsResponseEntry {
    
    CollectionName: string | undefined;
    
    Description: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    PricingPlanDataSource?: string;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace ListGeofenceCollectionsResponseEntry {
    
    const filterSensitiveLog: (obj: ListGeofenceCollectionsResponseEntry) => any;
}
export interface ListGeofenceCollectionsResponse {
    
    Entries: ListGeofenceCollectionsResponseEntry[] | undefined;
    
    NextToken?: string;
}
export declare namespace ListGeofenceCollectionsResponse {
    
    const filterSensitiveLog: (obj: ListGeofenceCollectionsResponse) => any;
}
export interface ListGeofencesRequest {
    
    CollectionName: string | undefined;
    
    NextToken?: string;
}
export declare namespace ListGeofencesRequest {
    
    const filterSensitiveLog: (obj: ListGeofencesRequest) => any;
}

export interface ListGeofenceResponseEntry {
    
    GeofenceId: string | undefined;
    
    Geometry: GeofenceGeometry | undefined;
    
    Status: string | undefined;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace ListGeofenceResponseEntry {
    
    const filterSensitiveLog: (obj: ListGeofenceResponseEntry) => any;
}
export interface ListGeofencesResponse {
    
    Entries: ListGeofenceResponseEntry[] | undefined;
    
    NextToken?: string;
}
export declare namespace ListGeofencesResponse {
    
    const filterSensitiveLog: (obj: ListGeofencesResponse) => any;
}
export interface PutGeofenceRequest {
    
    CollectionName: string | undefined;
    
    GeofenceId: string | undefined;
    
    Geometry: GeofenceGeometry | undefined;
}
export declare namespace PutGeofenceRequest {
    
    const filterSensitiveLog: (obj: PutGeofenceRequest) => any;
}
export interface PutGeofenceResponse {
    
    GeofenceId: string | undefined;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace PutGeofenceResponse {
    
    const filterSensitiveLog: (obj: PutGeofenceResponse) => any;
}
export interface UpdateGeofenceCollectionRequest {
    
    CollectionName: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    PricingPlanDataSource?: string;
    
    Description?: string;
}
export declare namespace UpdateGeofenceCollectionRequest {
    
    const filterSensitiveLog: (obj: UpdateGeofenceCollectionRequest) => any;
}
export interface UpdateGeofenceCollectionResponse {
    
    CollectionName: string | undefined;
    
    CollectionArn: string | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace UpdateGeofenceCollectionResponse {
    
    const filterSensitiveLog: (obj: UpdateGeofenceCollectionResponse) => any;
}
export interface GetDevicePositionRequest {
    
    TrackerName: string | undefined;
    
    DeviceId: string | undefined;
}
export declare namespace GetDevicePositionRequest {
    
    const filterSensitiveLog: (obj: GetDevicePositionRequest) => any;
}
export interface GetDevicePositionResponse {
    
    DeviceId?: string;
    
    SampleTime: Date | undefined;
    
    ReceivedTime: Date | undefined;
    
    Position: number[] | undefined;
    
    Accuracy?: PositionalAccuracy;
    
    PositionProperties?: {
        [key: string]: string;
    };
}
export declare namespace GetDevicePositionResponse {
    
    const filterSensitiveLog: (obj: GetDevicePositionResponse) => any;
}
export interface GetDevicePositionHistoryRequest {
    
    TrackerName: string | undefined;
    
    DeviceId: string | undefined;
    
    NextToken?: string;
    
    StartTimeInclusive?: Date;
    
    EndTimeExclusive?: Date;
}
export declare namespace GetDevicePositionHistoryRequest {
    
    const filterSensitiveLog: (obj: GetDevicePositionHistoryRequest) => any;
}
export interface GetDevicePositionHistoryResponse {
    
    DevicePositions: DevicePosition[] | undefined;
    
    NextToken?: string;
}
export declare namespace GetDevicePositionHistoryResponse {
    
    const filterSensitiveLog: (obj: GetDevicePositionHistoryResponse) => any;
}
export interface GetMapGlyphsRequest {
    
    MapName: string | undefined;
    
    FontStack: string | undefined;
    
    FontUnicodeRange: string | undefined;
}
export declare namespace GetMapGlyphsRequest {
    
    const filterSensitiveLog: (obj: GetMapGlyphsRequest) => any;
}
export interface GetMapGlyphsResponse {
    
    Blob?: Uint8Array;
    
    ContentType?: string;
}
export declare namespace GetMapGlyphsResponse {
    
    const filterSensitiveLog: (obj: GetMapGlyphsResponse) => any;
}
export interface GetMapSpritesRequest {
    
    MapName: string | undefined;
    
    FileName: string | undefined;
}
export declare namespace GetMapSpritesRequest {
    
    const filterSensitiveLog: (obj: GetMapSpritesRequest) => any;
}
export interface GetMapSpritesResponse {
    
    Blob?: Uint8Array;
    
    ContentType?: string;
}
export declare namespace GetMapSpritesResponse {
    
    const filterSensitiveLog: (obj: GetMapSpritesResponse) => any;
}
export interface GetMapStyleDescriptorRequest {
    
    MapName: string | undefined;
}
export declare namespace GetMapStyleDescriptorRequest {
    
    const filterSensitiveLog: (obj: GetMapStyleDescriptorRequest) => any;
}
export interface GetMapStyleDescriptorResponse {
    
    Blob?: Uint8Array;
    
    ContentType?: string;
}
export declare namespace GetMapStyleDescriptorResponse {
    
    const filterSensitiveLog: (obj: GetMapStyleDescriptorResponse) => any;
}
export interface GetMapTileRequest {
    
    MapName: string | undefined;
    
    Z: string | undefined;
    
    X: string | undefined;
    
    Y: string | undefined;
}
export declare namespace GetMapTileRequest {
    
    const filterSensitiveLog: (obj: GetMapTileRequest) => any;
}
export interface GetMapTileResponse {
    
    Blob?: Uint8Array;
    
    ContentType?: string;
}
export declare namespace GetMapTileResponse {
    
    const filterSensitiveLog: (obj: GetMapTileResponse) => any;
}
export interface ListDevicePositionsRequest {
    
    TrackerName: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListDevicePositionsRequest {
    
    const filterSensitiveLog: (obj: ListDevicePositionsRequest) => any;
}

export interface ListDevicePositionsResponseEntry {
    
    DeviceId: string | undefined;
    
    SampleTime: Date | undefined;
    
    Position: number[] | undefined;
    
    Accuracy?: PositionalAccuracy;
    
    PositionProperties?: {
        [key: string]: string;
    };
}
export declare namespace ListDevicePositionsResponseEntry {
    
    const filterSensitiveLog: (obj: ListDevicePositionsResponseEntry) => any;
}
export interface ListDevicePositionsResponse {
    
    Entries: ListDevicePositionsResponseEntry[] | undefined;
    
    NextToken?: string;
}
export declare namespace ListDevicePositionsResponse {
    
    const filterSensitiveLog: (obj: ListDevicePositionsResponse) => any;
}
export interface ListMapsRequest {
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListMapsRequest {
    
    const filterSensitiveLog: (obj: ListMapsRequest) => any;
}

export interface ListMapsResponseEntry {
    
    MapName: string | undefined;
    
    Description: string | undefined;
    
    DataSource: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace ListMapsResponseEntry {
    
    const filterSensitiveLog: (obj: ListMapsResponseEntry) => any;
}
export interface ListMapsResponse {
    
    Entries: ListMapsResponseEntry[] | undefined;
    
    NextToken?: string;
}
export declare namespace ListMapsResponse {
    
    const filterSensitiveLog: (obj: ListMapsResponse) => any;
}
export interface ListPlaceIndexesRequest {
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListPlaceIndexesRequest {
    
    const filterSensitiveLog: (obj: ListPlaceIndexesRequest) => any;
}

export interface ListPlaceIndexesResponseEntry {
    
    IndexName: string | undefined;
    
    Description: string | undefined;
    
    DataSource: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace ListPlaceIndexesResponseEntry {
    
    const filterSensitiveLog: (obj: ListPlaceIndexesResponseEntry) => any;
}
export interface ListPlaceIndexesResponse {
    
    Entries: ListPlaceIndexesResponseEntry[] | undefined;
    
    NextToken?: string;
}
export declare namespace ListPlaceIndexesResponse {
    
    const filterSensitiveLog: (obj: ListPlaceIndexesResponse) => any;
}
export interface ListRouteCalculatorsRequest {
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListRouteCalculatorsRequest {
    
    const filterSensitiveLog: (obj: ListRouteCalculatorsRequest) => any;
}

export interface ListRouteCalculatorsResponseEntry {
    
    CalculatorName: string | undefined;
    
    Description: string | undefined;
    
    DataSource: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace ListRouteCalculatorsResponseEntry {
    
    const filterSensitiveLog: (obj: ListRouteCalculatorsResponseEntry) => any;
}
export interface ListRouteCalculatorsResponse {
    
    Entries: ListRouteCalculatorsResponseEntry[] | undefined;
    
    NextToken?: string;
}
export declare namespace ListRouteCalculatorsResponse {
    
    const filterSensitiveLog: (obj: ListRouteCalculatorsResponse) => any;
}
export interface ListTrackerConsumersRequest {
    
    TrackerName: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListTrackerConsumersRequest {
    
    const filterSensitiveLog: (obj: ListTrackerConsumersRequest) => any;
}
export interface ListTrackerConsumersResponse {
    
    ConsumerArns: string[] | undefined;
    
    NextToken?: string;
}
export declare namespace ListTrackerConsumersResponse {
    
    const filterSensitiveLog: (obj: ListTrackerConsumersResponse) => any;
}
export interface ListTrackersRequest {
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListTrackersRequest {
    
    const filterSensitiveLog: (obj: ListTrackersRequest) => any;
}

export interface ListTrackersResponseEntry {
    
    TrackerName: string | undefined;
    
    Description: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    PricingPlanDataSource?: string;
    
    CreateTime: Date | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace ListTrackersResponseEntry {
    
    const filterSensitiveLog: (obj: ListTrackersResponseEntry) => any;
}
export interface ListTrackersResponse {
    
    Entries: ListTrackersResponseEntry[] | undefined;
    
    NextToken?: string;
}
export declare namespace ListTrackersResponse {
    
    const filterSensitiveLog: (obj: ListTrackersResponse) => any;
}
export interface UpdateMapRequest {
    
    MapName: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    Description?: string;
}
export declare namespace UpdateMapRequest {
    
    const filterSensitiveLog: (obj: UpdateMapRequest) => any;
}
export interface UpdateMapResponse {
    
    MapName: string | undefined;
    
    MapArn: string | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace UpdateMapResponse {
    
    const filterSensitiveLog: (obj: UpdateMapResponse) => any;
}
export interface SearchPlaceIndexForPositionRequest {
    
    IndexName: string | undefined;
    
    Position: number[] | undefined;
    
    MaxResults?: number;
    
    Language?: string;
}
export declare namespace SearchPlaceIndexForPositionRequest {
    
    const filterSensitiveLog: (obj: SearchPlaceIndexForPositionRequest) => any;
}

export interface PlaceGeometry {
    
    Point?: number[];
}
export declare namespace PlaceGeometry {
    
    const filterSensitiveLog: (obj: PlaceGeometry) => any;
}

export interface TimeZone {
    
    Name: string | undefined;
    
    Offset?: number;
}
export declare namespace TimeZone {
    
    const filterSensitiveLog: (obj: TimeZone) => any;
}

export interface Place {
    
    Label?: string;
    
    Geometry: PlaceGeometry | undefined;
    
    AddressNumber?: string;
    
    Street?: string;
    
    Neighborhood?: string;
    
    Municipality?: string;
    
    SubRegion?: string;
    
    Region?: string;
    
    Country?: string;
    
    PostalCode?: string;
    
    Interpolated?: boolean;
    
    TimeZone?: TimeZone;
}
export declare namespace Place {
    
    const filterSensitiveLog: (obj: Place) => any;
}

export interface SearchForPositionResult {
    
    Place: Place | undefined;
    
    Distance: number | undefined;
}
export declare namespace SearchForPositionResult {
    
    const filterSensitiveLog: (obj: SearchForPositionResult) => any;
}

export interface SearchPlaceIndexForPositionSummary {
    
    Position: number[] | undefined;
    
    MaxResults?: number;
    
    DataSource: string | undefined;
    
    Language?: string;
}
export declare namespace SearchPlaceIndexForPositionSummary {
    
    const filterSensitiveLog: (obj: SearchPlaceIndexForPositionSummary) => any;
}
export interface SearchPlaceIndexForPositionResponse {
    
    Summary: SearchPlaceIndexForPositionSummary | undefined;
    
    Results: SearchForPositionResult[] | undefined;
}
export declare namespace SearchPlaceIndexForPositionResponse {
    
    const filterSensitiveLog: (obj: SearchPlaceIndexForPositionResponse) => any;
}
export interface SearchPlaceIndexForSuggestionsRequest {
    
    IndexName: string | undefined;
    
    Text: string | undefined;
    
    BiasPosition?: number[];
    
    FilterBBox?: number[];
    
    FilterCountries?: string[];
    
    MaxResults?: number;
    
    Language?: string;
}
export declare namespace SearchPlaceIndexForSuggestionsRequest {
    
    const filterSensitiveLog: (obj: SearchPlaceIndexForSuggestionsRequest) => any;
}

export interface SearchForSuggestionsResult {
    
    Text: string | undefined;
}
export declare namespace SearchForSuggestionsResult {
    
    const filterSensitiveLog: (obj: SearchForSuggestionsResult) => any;
}

export interface SearchPlaceIndexForSuggestionsSummary {
    
    Text: string | undefined;
    
    BiasPosition?: number[];
    
    FilterBBox?: number[];
    
    FilterCountries?: string[];
    
    MaxResults?: number;
    
    DataSource: string | undefined;
    
    Language?: string;
}
export declare namespace SearchPlaceIndexForSuggestionsSummary {
    
    const filterSensitiveLog: (obj: SearchPlaceIndexForSuggestionsSummary) => any;
}
export interface SearchPlaceIndexForSuggestionsResponse {
    
    Summary: SearchPlaceIndexForSuggestionsSummary | undefined;
    
    Results: SearchForSuggestionsResult[] | undefined;
}
export declare namespace SearchPlaceIndexForSuggestionsResponse {
    
    const filterSensitiveLog: (obj: SearchPlaceIndexForSuggestionsResponse) => any;
}
export interface SearchPlaceIndexForTextRequest {
    
    IndexName: string | undefined;
    
    Text: string | undefined;
    
    BiasPosition?: number[];
    
    FilterBBox?: number[];
    
    FilterCountries?: string[];
    
    MaxResults?: number;
    
    Language?: string;
}
export declare namespace SearchPlaceIndexForTextRequest {
    
    const filterSensitiveLog: (obj: SearchPlaceIndexForTextRequest) => any;
}

export interface SearchForTextResult {
    
    Place: Place | undefined;
    
    Distance?: number;
    
    Relevance?: number;
}
export declare namespace SearchForTextResult {
    
    const filterSensitiveLog: (obj: SearchForTextResult) => any;
}

export interface SearchPlaceIndexForTextSummary {
    
    Text: string | undefined;
    
    BiasPosition?: number[];
    
    FilterBBox?: number[];
    
    FilterCountries?: string[];
    
    MaxResults?: number;
    
    ResultBBox?: number[];
    
    DataSource: string | undefined;
    
    Language?: string;
}
export declare namespace SearchPlaceIndexForTextSummary {
    
    const filterSensitiveLog: (obj: SearchPlaceIndexForTextSummary) => any;
}
export interface SearchPlaceIndexForTextResponse {
    
    Summary: SearchPlaceIndexForTextSummary | undefined;
    
    Results: SearchForTextResult[] | undefined;
}
export declare namespace SearchPlaceIndexForTextResponse {
    
    const filterSensitiveLog: (obj: SearchPlaceIndexForTextResponse) => any;
}
export interface UpdatePlaceIndexRequest {
    
    IndexName: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    Description?: string;
    
    DataSourceConfiguration?: DataSourceConfiguration;
}
export declare namespace UpdatePlaceIndexRequest {
    
    const filterSensitiveLog: (obj: UpdatePlaceIndexRequest) => any;
}
export interface UpdatePlaceIndexResponse {
    
    IndexName: string | undefined;
    
    IndexArn: string | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace UpdatePlaceIndexResponse {
    
    const filterSensitiveLog: (obj: UpdatePlaceIndexResponse) => any;
}
export interface UpdateRouteCalculatorRequest {
    
    CalculatorName: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    Description?: string;
}
export declare namespace UpdateRouteCalculatorRequest {
    
    const filterSensitiveLog: (obj: UpdateRouteCalculatorRequest) => any;
}
export interface UpdateRouteCalculatorResponse {
    
    CalculatorName: string | undefined;
    
    CalculatorArn: string | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace UpdateRouteCalculatorResponse {
    
    const filterSensitiveLog: (obj: UpdateRouteCalculatorResponse) => any;
}
export interface UpdateTrackerRequest {
    
    TrackerName: string | undefined;
    
    PricingPlan?: PricingPlan | string;
    
    PricingPlanDataSource?: string;
    
    Description?: string;
    
    PositionFiltering?: PositionFiltering | string;
}
export declare namespace UpdateTrackerRequest {
    
    const filterSensitiveLog: (obj: UpdateTrackerRequest) => any;
}
export interface UpdateTrackerResponse {
    
    TrackerName: string | undefined;
    
    TrackerArn: string | undefined;
    
    UpdateTime: Date | undefined;
}
export declare namespace UpdateTrackerResponse {
    
    const filterSensitiveLog: (obj: UpdateTrackerResponse) => any;
}
