import { __extends } from "tslib";
import { ListSpeechSynthesisTasksInput, ListSpeechSynthesisTasksOutput } from "../models/models_0";
import { deserializeAws_restJson1ListSpeechSynthesisTasksCommand, serializeAws_restJson1ListSpeechSynthesisTasksCommand, } from "../protocols/Aws_restJson1";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
/**
 * <p>Returns a list of SpeechSynthesisTask objects ordered by their creation date. This
 *       operation can filter the tasks by their status, for example, allowing users to list only tasks
 *       that are completed.</p>
 */
var ListSpeechSynthesisTasksCommand = /** @class */ (function (_super) {
    __extends(ListSpeechSynthesisTasksCommand, _super);
    // Start section: command_properties
    // End section: command_properties
    function ListSpeechSynthesisTasksCommand(input) {
        var _this = 
        // Start section: command_constructor
        _super.call(this) || this;
        _this.input = input;
        return _this;
        // End section: command_constructor
    }
    /**
     * @internal
     */
    ListSpeechSynthesisTasksCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "PollyClient";
        var commandName = "ListSpeechSynthesisTasksCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListSpeechSynthesisTasksInput.filterSensitiveLog,
            outputFilterSensitiveLog: ListSpeechSynthesisTasksOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListSpeechSynthesisTasksCommand.prototype.serialize = function (input, context) {
        return serializeAws_restJson1ListSpeechSynthesisTasksCommand(input, context);
    };
    ListSpeechSynthesisTasksCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restJson1ListSpeechSynthesisTasksCommand(output, context);
    };
    return ListSpeechSynthesisTasksCommand;
}($Command));
export { ListSpeechSynthesisTasksCommand };
//# sourceMappingURL=ListSpeechSynthesisTasksCommand.js.map