"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientDefaultValues = void 0;
const tslib_1 = require("tslib");
const package_json_1 = tslib_1.__importDefault(require("./package.json"));
const config_resolver_1 = require("@aws-sdk/config-resolver");
const credential_provider_node_1 = require("@aws-sdk/credential-provider-node");
const hash_node_1 = require("@aws-sdk/hash-node");
const middleware_retry_1 = require("@aws-sdk/middleware-retry");
const node_config_provider_1 = require("@aws-sdk/node-config-provider");
const node_http_handler_1 = require("@aws-sdk/node-http-handler");
const util_base64_node_1 = require("@aws-sdk/util-base64-node");
const util_body_length_node_1 = require("@aws-sdk/util-body-length-node");
const util_user_agent_node_1 = require("@aws-sdk/util-user-agent-node");
const util_utf8_node_1 = require("@aws-sdk/util-utf8-node");
const runtimeConfig_shared_1 = require("./runtimeConfig.shared");
/**
 * @internal
 */
exports.ClientDefaultValues = {
    ...runtimeConfig_shared_1.ClientSharedValues,
    runtime: "node",
    base64Decoder: util_base64_node_1.fromBase64,
    base64Encoder: util_base64_node_1.toBase64,
    bodyLengthChecker: util_body_length_node_1.calculateBodyLength,
    credentialDefaultProvider: credential_provider_node_1.defaultProvider,
    defaultUserAgentProvider: util_user_agent_node_1.defaultUserAgent({
        serviceId: runtimeConfig_shared_1.ClientSharedValues.serviceId,
        clientVersion: package_json_1.default.version,
    }),
    maxAttempts: node_config_provider_1.loadConfig(middleware_retry_1.NODE_MAX_ATTEMPT_CONFIG_OPTIONS),
    region: node_config_provider_1.loadConfig(config_resolver_1.NODE_REGION_CONFIG_OPTIONS, config_resolver_1.NODE_REGION_CONFIG_FILE_OPTIONS),
    requestHandler: new node_http_handler_1.NodeHttpHandler(),
    sha256: hash_node_1.Hash.bind(null, "sha256"),
    streamCollector: node_http_handler_1.streamCollector,
    utf8Decoder: util_utf8_node_1.fromUtf8,
    utf8Encoder: util_utf8_node_1.toUtf8,
};
//# sourceMappingURL=runtimeConfig.js.map